/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.serializer;

import com.wavemaker.common.Resource;
import com.wavemaker.common.util.SpringUtils;
import com.wavemaker.tools.serializer.FileSerializer;
import com.wavemaker.tools.serializer.FileSerializerException;
import com.wavemaker.tools.service.FileService;
import java.io.File;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSerializerFactory {
    private static FileSerializerFactory instance;
    private Map<String, List<FileSerializer>> serializerMap;

    private FileSerializerFactory() {
        instance = this;
    }

    public static FileSerializerFactory getInstance() {
        if (instance == null) {
            SpringUtils.throwSpringNotInitializedError(FileSerializerFactory.class);
        }
        return instance;
    }

    public FileSerializer getSerializer(String fileExt) {
        List<FileSerializer> serializers = this.getSerializers(fileExt);
        if (serializers != null && !serializers.isEmpty()) {
            return serializers.get(0);
        }
        return null;
    }

    public List<FileSerializer> getSerializers(String fileExt) {
        return this.serializerMap.get(fileExt);
    }

    public Object readObject(FileService fileService, File file) throws FileSerializerException {
        List<FileSerializer> serializers = this.getSerializers(file);
        FileSerializerException serializerException = null;
        for (FileSerializer serializer : serializers) {
            Object ret = null;
            try {
                ret = serializer.readObject(fileService, file);
            }
            catch (FileSerializerException e) {
                serializerException = e;
            }
            if (ret == null) continue;
            return ret;
        }
        if (serializerException != null) {
            throw serializerException;
        }
        return null;
    }

    public void writeObject(FileService fileService, Object object, File file) throws FileSerializerException {
        List<FileSerializer> serializers = this.getSerializers(file);
        FileSerializerException serializerException = null;
        for (FileSerializer serializer : serializers) {
            try {
                serializer.writeObject(fileService, object, file);
            }
            catch (FileSerializerException e) {
                serializerException = e;
            }
        }
        if (serializerException != null) {
            throw serializerException;
        }
    }

    private List<FileSerializer> getSerializers(File file) throws FileSerializerException {
        String fileExt = this.getFileExtension(file);
        List<FileSerializer> serializers = this.serializerMap.get(fileExt);
        if (serializers == null || serializers.isEmpty()) {
            throw new FileSerializerException(Resource.STUDIO_PROJECT_UNKNOWN_TYPE + file.getName());
        }
        return serializers;
    }

    private String getFileExtension(File file) {
        String fileName = file.getName();
        int dotPos = fileName.lastIndexOf(".");
        String fileExt = fileName.substring(dotPos + 1);
        return fileExt;
    }

    public Map<String, List<FileSerializer>> getSerializerMap() {
        return this.serializerMap;
    }

    public void setSerializerMap(Map<String, List<FileSerializer>> serializerMap) {
        this.serializerMap = serializerMap;
    }
}

