/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.service;

import com.wavemaker.tools.service.FileService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.io.FileUtils;

public abstract class AbstractFileService
implements FileService {
    public String getEncoding() {
        return "UTF-8";
    }

    public String readFile(String path) throws IOException {
        return this.readFile(new File(this.getFileServiceRoot(), path));
    }

    public String readFile(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (String)this.getEncoding());
    }

    public void writeFile(String path, String data) throws IOException {
        this.writeFile(new File(this.getFileServiceRoot(), path), data);
    }

    public void writeFile(File file, String data) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)data, (String)this.getEncoding());
    }

    public boolean deleteFile(String path) {
        return new File(this.getFileServiceRoot(), path).delete();
    }

    public Reader getReader(File file) throws UnsupportedEncodingException, FileNotFoundException {
        return new InputStreamReader((InputStream)new FileInputStream(file), this.getEncoding());
    }

    public Reader getReader(String path) throws UnsupportedEncodingException, FileNotFoundException {
        return this.getReader(new File(this.getFileServiceRoot(), path));
    }

    public Writer getWriter(File file) throws UnsupportedEncodingException, FileNotFoundException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getEncoding());
    }

    public Writer getWriter(String path) throws UnsupportedEncodingException, FileNotFoundException {
        return this.getWriter(new File(this.getFileServiceRoot(), path));
    }

    public boolean fileExists(String path) {
        return new File(this.getFileServiceRoot(), path).exists();
    }

    public boolean fileExists(File file) {
        return file.exists();
    }
}

