/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.service;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.IOUtils;
import com.wavemaker.json.JSONMarshaller;
import com.wavemaker.json.JSONState;
import com.wavemaker.json.ValueTransformer;
import com.wavemaker.runtime.service.TypeManager;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.service.FileService;
import com.wavemaker.tools.service.definitions.DataObject;
import com.wavemaker.tools.service.definitions.DataObjects;
import com.wavemaker.tools.service.definitions.Operation;
import com.wavemaker.tools.service.definitions.OperationComparator;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.service.definitions.ServiceComparator;
import com.wavemaker.tools.service.smd.Method;
import com.wavemaker.tools.service.smd.Param;
import com.wavemaker.tools.service.smd.SMD;
import com.wavemaker.tools.service.types.ComplexType;
import com.wavemaker.tools.service.types.Field;
import com.wavemaker.tools.service.types.PrimitiveType;
import com.wavemaker.tools.service.types.Type;
import com.wavemaker.tools.service.types.TypeValueTransformer;
import com.wavemaker.tools.service.types.Types;
import com.wavemaker.tools.spring.SpringConfigSupport;
import com.wavemaker.tools.spring.beans.Bean;
import com.wavemaker.tools.spring.beans.Beans;
import com.wavemaker.tools.spring.beans.DefaultableBoolean;
import com.wavemaker.tools.spring.beans.Entry;
import com.wavemaker.tools.spring.beans.Import;
import com.wavemaker.tools.spring.beans.List;
import com.wavemaker.tools.spring.beans.Map;
import com.wavemaker.tools.spring.beans.Property;
import com.wavemaker.tools.spring.beans.Value;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationCompiler {
    public static final String SERVICE_MANAGER_BEAN_ID = "serviceManager";
    public static final String SERVICE_SMD_EXTENSION = "smd";
    public static final String EVENT_MANAGER_BEAN_ID = "eventManager";
    public static final String TYPE_MANAGER_BEAN_ID = "typeManager";
    public static final String TYPE_MANAGER_PARENT = "typeManagerBase";
    public static final String TYPE_MANAGER_TYPES = "types";
    public static final String TYPE_RUNTIME_FILE = "types.js";
    public static final String RUNTIME_SERVICES_DIR = "services";
    public static final String RUNTIME_SERVICES = "project-services.xml";
    public static final String RUNTIME_MANAGERS = "project-managers.xml";
    public static final String SINGLETON = "singleton";
    public static final String WM_TYPES_PREPEND = "wm.types = ";
    public static final String WM_TYPES_APPEND = ";";

    private ConfigurationCompiler() {
    }

    public static String typeToArrayType(String type) {
        return "[" + type + "]";
    }

    public static File getRuntimeServicesXml(Project p) {
        return new File(p.getWebInf(), RUNTIME_SERVICES);
    }

    public static File getRuntimeManagersXml(Project p) {
        return new File(p.getWebInf(), RUNTIME_MANAGERS);
    }

    public static File getSmdFile(File servicesDir, String serviceName) {
        return new File(servicesDir, serviceName + "." + SERVICE_SMD_EXTENSION);
    }

    public static File getSmdFile(Project currentProject, String serviceName) {
        return ConfigurationCompiler.getSmdFile(new File(currentProject.getWebAppRoot(), RUNTIME_SERVICES_DIR), serviceName);
    }

    public static File getTypesFile(File projectRoot) {
        return new File(new File(projectRoot, "webapproot"), TYPE_RUNTIME_FILE);
    }

    public static File getTypesFile(Project project) {
        return ConfigurationCompiler.getTypesFile(project.getProjectRoot());
    }

    public static void generateServices(FileService fileService, File servicesXml, SortedSet<Service> services) throws JAXBException, IOException {
        TreeSet<Service> allServices = new TreeSet<Service>(new ServiceComparator());
        allServices.addAll(services);
        Beans beans = new Beans();
        java.util.List<Object> imports = beans.getImportsAndAliasAndBeen();
        for (Service service : allServices) {
            if (null == service.getSpringFile()) {
                throw new WMRuntimeException(Resource.NO_EXTERNAL_BEAN_DEF, new Object[]{service.getId()});
            }
            Import i = new Import();
            i.setResource("classpath:" + service.getSpringFile());
            imports.add(i);
        }
        FileUtils.forceMkdir((File)servicesXml.getParentFile());
        SpringConfigSupport.writeBeans(beans, servicesXml, fileService);
    }

    public static SortedSet<Method> getMethods(java.util.List<Operation> ops, String serviceName) {
        Collections.sort(ops, new OperationComparator());
        TreeMap<String, Method> methodMap = new TreeMap<String, Method>();
        for (int i = 0; i < ops.size(); ++i) {
            java.util.List<Operation.Parameter> params;
            Operation op = ops.get(i);
            Method meth = new Method();
            String methodName = op.getName();
            meth.setName(methodName);
            if (null != op.getReturn() && null != op.getReturn().getTypeRef()) {
                String type = op.getReturn().getTypeRef();
                if (op.getReturn().isIsList()) {
                    type = ConfigurationCompiler.typeToArrayType(type);
                }
                meth.setReturnType(type);
            }
            if ((params = op.getParameter()).size() > 0) {
                ArrayList<Param> methArgs = new ArrayList<Param>();
                for (Operation.Parameter param : params) {
                    Param p = new Param();
                    p.setName(param.getName());
                    String type = param.getTypeRef();
                    if (param.isIsList()) {
                        type = ConfigurationCompiler.typeToArrayType(type);
                    }
                    p.setType(type);
                    methArgs.add(p);
                }
                meth.setParameters(methArgs);
            }
            if (params.size() > 0 && null != methodMap.get(methodName)) {
                Method oldMethod = (Method)methodMap.get(methodName);
                java.util.List<Param> oldMapParams = oldMethod.getParameters();
                java.util.List<Param> curMapParams = meth.getParameters();
                if (null == oldMapParams) continue;
                if (oldMapParams.size() > curMapParams.size()) {
                    methodMap.put(methodName, meth);
                    continue;
                }
                if (oldMapParams.size() != curMapParams.size()) continue;
                throw new WMRuntimeException(Resource.JSONUTILS_BADMETHODOVERLOAD, new Object[]{serviceName, methodName});
            }
            methodMap.put(methodName, meth);
        }
        TreeSet<Method> methods = new TreeSet<Method>();
        for (Method elem : methodMap.values()) {
            methods.add(elem);
        }
        return methods;
    }

    protected static SMD getSMD(Service service) {
        SMD ret = new SMD();
        ret.setServiceType("JSON-RPC");
        ret.setServiceURL(service.getId() + ".json");
        ret.setMethods(ConfigurationCompiler.getMethods(service.getOperation(), service.getId()));
        return ret;
    }

    public static void generateSMDs(Project currentProject, SortedSet<Service> services) throws IOException, NoSuchMethodException {
        File servicesDir = new File(currentProject.getWebAppRoot(), RUNTIME_SERVICES_DIR);
        ConfigurationCompiler.generateSMDs(currentProject, servicesDir, services);
    }

    public static void generateSMDs(FileService fileService, File servicesDir, SortedSet<Service> services) throws IOException, NoSuchMethodException {
        IOUtils.makeDirectories((File)servicesDir, (File)fileService.getFileServiceRoot());
        for (Service service : services) {
            SMD smd = ConfigurationCompiler.getSMD(service);
            File smdFile = ConfigurationCompiler.getSmdFile(servicesDir, service.getId());
            JSONState js = new JSONState();
            Writer writer = fileService.getWriter(smdFile);
            JSONMarshaller.marshal((Writer)writer, (Object)smd, (JSONState)js, (boolean)true, (boolean)true);
            writer.close();
        }
    }

    public static void generateManagers(FileService fileService, File managersXml, SortedSet<Service> services) throws JAXBException, IOException {
        Beans beans = new Beans();
        Bean tm = new Bean();
        tm.setScope(SINGLETON);
        tm.setClazz(TypeManager.class.getCanonicalName());
        tm.setParent(TYPE_MANAGER_PARENT);
        tm.setId(TYPE_MANAGER_BEAN_ID);
        Property prop = new Property();
        prop.setName(TYPE_MANAGER_TYPES);
        Map typesMap = new Map();
        typesMap.setMerge(DefaultableBoolean.TRUE);
        for (Service service : services) {
            if (null == service.getDataobjects()) continue;
            Entry entry = new Entry();
            entry.setKey(service.getId());
            List typesList = new List();
            for (DataObject dao : service.getDataobjects().getDataobject()) {
                Value val = new Value();
                ArrayList<String> content = new ArrayList<String>();
                content.add(dao.getJavaType());
                val.setContent(content);
                typesList.getRefElement().add(val);
            }
            entry.getRefElement().add(typesList);
            typesMap.getEntries().add(entry);
        }
        prop.setMap(typesMap);
        tm.addProperty(prop);
        beans.addBean(tm);
        FileUtils.forceMkdir((File)managersXml.getParentFile());
        SpringConfigSupport.writeBeans(beans, managersXml, fileService);
    }

    public static void generateTypes(FileService fileService, File typesFile, SortedSet<Service> services, java.util.List<DataObject> primitiveTypes) throws IOException {
        Types types = ConfigurationCompiler.getTypesFromServices(services, primitiveTypes);
        FileUtils.forceMkdir((File)typesFile.getParentFile());
        Writer writer = fileService.getWriter(typesFile);
        writer.write(WM_TYPES_PREPEND);
        JSONState js = new JSONState();
        js.setValueTransformer((ValueTransformer)new TypeValueTransformer());
        JSONMarshaller.marshal((Writer)writer, (Object)types, (JSONState)js, (boolean)true, (boolean)true);
        writer.write(WM_TYPES_APPEND);
        writer.close();
    }

    public static Types getTypesFromServices(SortedSet<Service> services, java.util.List<DataObject> primitiveTypes) {
        Types ret = new Types();
        for (Service service : services) {
            DataObjects objs = service.getDataobjects();
            if (null == objs) continue;
            ConfigurationCompiler.getTypesFromDataObjects(service.getId(), objs.getDataobject(), ret);
        }
        if (null != primitiveTypes) {
            ConfigurationCompiler.getTypesFromDataObjects("noServicePrimitiveType", primitiveTypes, ret);
        }
        return ret;
    }

    public static void getTypesFromDataObjects(String serviceId, java.util.List<DataObject> daos, Types types) {
        for (DataObject dao : daos) {
            Type type;
            if (null == dao.getJsType()) {
                type = new ComplexType();
                if (dao.isSupportsQuickData()) {
                    ((ComplexType)type).setLiveService(true);
                }
                ((ComplexType)type).setService(serviceId);
                ((ComplexType)type).setInternal(dao.isInternal());
                int fieldOrder = 0;
                for (DataObject.Element et : dao.getElement()) {
                    Field f = new Field();
                    f.setType(et.getTypeRef());
                    f.setIsList(et.isIsList());
                    f.setRequired(!et.isAllowNull());
                    f.setExclude(et.getExclude());
                    f.setNoChange(et.getNoChange());
                    f.setInclude(et.getRequire());
                    f.setFieldOrder(fieldOrder);
                    ((ComplexType)type).getFields().put(et.getName(), f);
                    ++fieldOrder;
                }
                types.getTypes().put(dao.getJavaType(), type);
                continue;
            }
            type = new PrimitiveType();
            ((PrimitiveType)type).setInternal(dao.isInternal());
            ((PrimitiveType)type).setPrimitiveType(dao.getJsType());
            types.getTypes().put(dao.getJavaType(), type);
        }
    }
}

