/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.service;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.json.type.FieldDefinition;
import com.wavemaker.json.type.ObjectTypeDefinition;
import com.wavemaker.json.type.OperationEnumeration;
import com.wavemaker.json.type.TypeDefinition;
import com.wavemaker.runtime.service.definition.ReflectServiceDefinition;
import com.wavemaker.runtime.service.definition.ServiceDefinition;
import com.wavemaker.runtime.service.definition.ServiceOperation;
import com.wavemaker.tools.data.util.DataServiceUtils;
import com.wavemaker.tools.project.DeploymentManager;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.ProjectManager;
import com.wavemaker.tools.service.ConfigurationCompiler;
import com.wavemaker.tools.service.DesignServiceType;
import com.wavemaker.tools.service.DuplicateServiceIdException;
import com.wavemaker.tools.service.InvalidServiceIdException;
import com.wavemaker.tools.service.definitions.DataObject;
import com.wavemaker.tools.service.definitions.DataObjects;
import com.wavemaker.tools.service.definitions.Operation;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.service.definitions.ServiceComparator;
import com.wavemaker.tools.spring.SpringConfigSupport;
import com.wavemaker.tools.spring.beans.Bean;
import com.wavemaker.tools.spring.beans.Beans;
import com.wavemaker.tools.spring.beans.DefaultableBoolean;
import com.wavemaker.tools.spring.beans.Property;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignServiceManager {
    private static final JAXBContext definitionsContext;
    private static final String SERVICES_DIR = "services";
    private static final String SERVICE_DEF_XML = "servicedef.xml";
    private static final String RUNTIME_DIR = "src";
    private static final String DESIGNTIME_DIR = "designtime";
    private static final Collection<String> RESERVED_WORDS;
    private final Map<Project, Map<String, Service>> serviceDefinitions = new HashMap<Project, Map<String, Service>>();
    private final List<DataObject> primitiveTypes;
    private final Map<String, String> primitivesMap;
    private final Service runtimeService;
    public static final String RUNTIME_SERVICE_ID = "runtimeService";
    private static final String SERVICE_BEAN_XML_POSTFIX = ".spring.xml";
    private ProjectManager projectManager;
    private DeploymentManager deploymentManager;
    private List<DesignServiceType> designServiceTypes;

    public DesignServiceManager() throws JAXBException, IOException {
        Unmarshaller unmarshaller = definitionsContext.createUnmarshaller();
        ClassPathResource primitiveServiceFile = new ClassPathResource("com/wavemaker/tools/service/primitive_types.xml");
        Service primitiveService = (Service)unmarshaller.unmarshal(primitiveServiceFile.getInputStream());
        this.primitiveTypes = Collections.unmodifiableList(primitiveService.getDataobjects().getDataobject());
        TreeMap<String, String> m = new TreeMap<String, String>();
        for (DataObject o : this.primitiveTypes) {
            if (o.isInternal()) continue;
            m.put(o.getName(), o.getJavaType());
        }
        this.primitivesMap = Collections.unmodifiableMap(m);
        ClassPathResource runtimeServiceFile = new ClassPathResource("com/wavemaker/runtime/service/runtimeServiceDef.xml");
        this.runtimeService = DesignServiceManager.loadServiceDefinition(runtimeServiceFile.getInputStream());
    }

    public static String getDesigntimeRelativeDir(String serviceId) {
        return "services/" + serviceId + "/" + DESIGNTIME_DIR;
    }

    public static String getRuntimeRelativeDir(String serviceId) {
        return "services/" + serviceId + "/" + RUNTIME_DIR;
    }

    public static String getServicesRelativeDir() {
        return SERVICES_DIR;
    }

    public static String getServiceXmlRelative() {
        return SERVICE_DEF_XML;
    }

    public static String getServiceBeanName(String serviceId) {
        return serviceId + SERVICE_BEAN_XML_POSTFIX;
    }

    public static String getServiceBeanRelative(String serviceId) {
        return DesignServiceManager.getRuntimeRelativeDir(serviceId) + "/" + DesignServiceManager.getServiceBeanName(serviceId);
    }

    public static void generateSpringServiceConfig(String serviceId, String serviceClass, DesignServiceType designServiceType, File serviceBeanFile, Project project) throws JAXBException, IOException {
        Beans beans = new Beans();
        Bean bean = new Bean();
        bean.setClazz(serviceClass);
        bean.setId(serviceId);
        bean.setScope("singleton");
        bean.setLazyInit(DefaultableBoolean.TRUE);
        beans.addBean(bean);
        Bean serviceWireBean = DesignServiceManager.generateServiceWireBean(designServiceType, serviceId);
        beans.addBean(serviceWireBean);
        SpringConfigSupport.writeBeans(beans, serviceBeanFile, project);
    }

    public static Bean generateServiceWireBean(DesignServiceType designServiceType, String serviceId) {
        Bean serviceTypeBean = new Bean();
        serviceTypeBean.setClazz(designServiceType.getServiceType().getClass().getName());
        Property serviceTypeProp = new Property();
        serviceTypeProp.setName("serviceType");
        serviceTypeProp.setRef(designServiceType.getServiceType());
        Bean serviceWireBean = new Bean();
        serviceWireBean.setClazz(designServiceType.getServiceWire().getName());
        serviceWireBean.setScope("singleton");
        serviceWireBean.setLazyInit(DefaultableBoolean.FALSE);
        serviceWireBean.addProperty("serviceId", serviceId);
        serviceWireBean.addProperty(serviceTypeProp);
        return serviceWireBean;
    }

    public void deleteService(String serviceId) throws IOException, NoSuchMethodException {
        Map<String, Service> serviceDefs = this.getCurrentServiceDefinitions();
        serviceDefs.remove(serviceId);
        File serviceHome = this.getServiceHome(serviceId);
        FileUtils.deleteDirectory((File)serviceHome);
        ConfigurationCompiler.getSmdFile(this.getProjectManager().getCurrentProject(), serviceId).delete();
        this.generateRuntimeConfiguration(null);
        this.deploymentManager.testRunClean();
    }

    public void deleteServiceSmd(String serviceId) throws IOException, NoSuchMethodException {
        ConfigurationCompiler.getSmdFile(this.getProjectManager().getCurrentProject(), serviceId).delete();
        this.generateRuntimeConfiguration(null);
        this.deploymentManager.testRunClean();
    }

    public void defineService(ServiceDefinition serviceDef) {
        try {
            this.validateServiceId(serviceDef.getServiceId());
        }
        catch (DuplicateServiceIdException ignore) {
            // empty catch block
        }
        Service oldService = this.getService(serviceDef.getServiceId());
        Service service = new Service();
        this.getCurrentServiceDefinitions().put(serviceDef.getServiceId(), service);
        try {
            for (ServiceOperation op : serviceDef.getServiceOperations()) {
                this.doUpdateOperation(op, service, serviceDef);
            }
            service.setId(serviceDef.getServiceId());
            service.setType(serviceDef.getServiceType().getTypeName());
            service.setCRUDService(serviceDef.isLiveDataService());
            if (serviceDef instanceof ReflectServiceDefinition) {
                service.setClazz(((ReflectServiceDefinition)serviceDef).getServiceClass());
            }
            if (null != serviceDef.getRuntimeConfiguration()) {
                service.setSpringFile(serviceDef.getRuntimeConfiguration());
            } else if (null != oldService && null != oldService.getSpringFile()) {
                service.setSpringFile(oldService.getSpringFile());
            }
            this.updateServiceTypes(service, serviceDef);
        }
        catch (WMRuntimeException e) {
            this.getCurrentServiceDefinitions().remove(serviceDef.getServiceId());
            throw e;
        }
        this.defineService(service);
    }

    public void defineService(Service service) {
        if (null == service.getSpringFile()) {
            service.setSpringFile(DesignServiceManager.getServiceBeanName(service.getId()));
        }
        this.saveServiceDefinition(service.getId());
        File serviceBeanFile = this.getServiceBeanXml(service.getId());
        if (DesignServiceManager.getServiceBeanName(service.getId()).equals(service.getSpringFile()) && !serviceBeanFile.exists()) {
            if (!serviceBeanFile.getParentFile().exists()) {
                serviceBeanFile.getParentFile().mkdir();
            }
            try {
                DesignServiceManager.generateSpringServiceConfig(service.getId(), service.getClazz(), this.getDesignServiceType(service.getType()), serviceBeanFile, this.projectManager.getCurrentProject());
            }
            catch (JAXBException e) {
                throw new WMRuntimeException((Throwable)e);
            }
            catch (IOException e) {
                throw new WMRuntimeException((Throwable)e);
            }
        }
    }

    public void validateServiceId(String id) {
        if (ObjectUtils.isNullOrEmpty((String)id)) {
            throw new InvalidServiceIdException(id, "it cannot be null or empty");
        }
        if (RESERVED_WORDS.contains(id)) {
            throw new InvalidServiceIdException(id, "it contains a reserved word");
        }
        if (!StringUtils.isValidJavaIdentifier((String)id)) {
            throw new InvalidServiceIdException(id, "it must be a valid java identifier");
        }
        if (this.getServiceIds().contains(id)) {
            throw new DuplicateServiceIdException(id);
        }
    }

    public File getServicesDir() {
        return new File(this.getProjectManager().getCurrentProject().getProjectRoot(), SERVICES_DIR);
    }

    public File getServiceHome(String serviceId) {
        return new File(this.getServicesDir(), serviceId);
    }

    public File getServiceRuntimeDirectory(String serviceId) {
        return new File(this.getServiceHome(serviceId), RUNTIME_DIR);
    }

    public File getServiceDesigntimeDirectory(String serviceId) {
        return new File(this.getServiceHome(serviceId), DESIGNTIME_DIR);
    }

    public File getServiceDefXml(String serviceId) {
        return new File(this.getServiceDesigntimeDirectory(serviceId), SERVICE_DEF_XML);
    }

    public File getServiceBeanXml(String serviceId) {
        return new File(this.getProjectManager().getCurrentProject().getProjectRoot(), DesignServiceManager.getServiceBeanRelative(serviceId));
    }

    public Service getCurrentServiceDefinition(String serviceId) {
        Service ret;
        if (this.getCurrentServiceDefinitions().containsKey(serviceId)) {
            ret = this.getCurrentServiceDefinitions().get(serviceId);
        } else {
            Service service = this.loadServiceDefinition(serviceId);
            this.getCurrentServiceDefinitions().put(serviceId, service);
            ret = service;
        }
        return ret;
    }

    public SortedSet<String> getServiceIds() {
        TreeSet<String> ret = new TreeSet<String>();
        File servicesDir = this.getServicesDir();
        if (servicesDir.exists()) {
            for (File child : servicesDir.listFiles()) {
                File serviceXml;
                if (!child.isDirectory() || !(serviceXml = this.getServiceDefXml(child.getName())).exists()) continue;
                ret.add(child.getName());
            }
        }
        ret.add(RUNTIME_SERVICE_ID);
        return ret;
    }

    public SortedSet<Service> getServices() {
        SortedSet<String> serviceIds = this.getServiceIds();
        TreeSet<Service> ret = new TreeSet<Service>(new ServiceComparator());
        for (String id : serviceIds) {
            ret.add(this.getService(id));
        }
        return ret;
    }

    public SortedSet<Service> getServicesByType(String type) {
        SortedSet<Service> services = this.getServices();
        TreeSet<Service> ret = new TreeSet<Service>(new ServiceComparator());
        for (Service service : services) {
            if (!service.getType().equals(type)) continue;
            ret.add(service);
        }
        return ret;
    }

    public DesignServiceType getDesignServiceType(String typeId) {
        for (DesignServiceType dst : this.getDesignServiceTypes()) {
            if (!dst.getServiceType().equals(typeId)) continue;
            return dst;
        }
        throw new WMRuntimeException(Resource.NO_DESIGN_SERVICE_TYPE_FOUND, new Object[]{typeId});
    }

    public boolean serviceExists(String serviceId) {
        try {
            return this.getService(serviceId) != null;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public Service getService(String serviceId) {
        return this.getCurrentServiceDefinition(serviceId);
    }

    public List<String> getOperationNames(String serviceId) {
        Service service = this.getCurrentServiceDefinition(serviceId);
        List<Operation> operations = service.getOperation();
        ArrayList<String> ret = new ArrayList<String>(operations.size());
        for (Operation op : operations) {
            ret.add(op.getName());
        }
        return ret;
    }

    public Operation getOperation(String serviceId, String name) {
        Service service = this.getCurrentServiceDefinition(serviceId);
        for (Operation operation : service.getOperation()) {
            if (!operation.getName().equals(name)) continue;
            return operation;
        }
        return null;
    }

    private void generateRuntimeConfiguration(SortedSet<Service> services) throws IOException, NoSuchMethodException {
        Project project = this.getProjectManager().getCurrentProject();
        if (null == services) {
            services = this.getServices();
        }
        SortedSet<Service> allServices = this.getServices();
        try {
            ConfigurationCompiler.generateServices(project, ConfigurationCompiler.getRuntimeServicesXml(project), allServices);
            ConfigurationCompiler.generateManagers(project, ConfigurationCompiler.getRuntimeManagersXml(project), allServices);
        }
        catch (JAXBException ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        ConfigurationCompiler.generateSMDs(project, services);
        ConfigurationCompiler.generateTypes(project, ConfigurationCompiler.getTypesFile(project), allServices, this.getPrimitiveDataObjects());
    }

    public void updateServiceTypes(Service service, ServiceDefinition serviceDef) {
        if (null == service.getDataobjects()) {
            service.setDataobjects(new DataObjects());
        }
        List<DataObject> dos = service.getDataobjects().getDataobject();
        dos.clear();
        List<TypeDefinition> elementTypes = serviceDef.getLocalTypes();
        for (TypeDefinition et : elementTypes) {
            if (null != this.findDataObjectFromJavaType(et.getTypeName())) {
                throw new WMRuntimeException("Conflicting java type: " + et.getTypeName());
            }
            DataObject dso = new DataObject();
            dos.add(dso);
            dso.setJavaType(et.getTypeName());
            dso.setName(et.getShortName());
            dso.setSupportsQuickData(et.isLiveService());
            if (!(et instanceof ObjectTypeDefinition)) continue;
            ObjectTypeDefinition otd = (ObjectTypeDefinition)et;
            List<DataObject.Element> dsoelems = dso.getElement();
            for (Map.Entry entry : otd.getFields().entrySet()) {
                DataObject.Element e = new DataObject.Element();
                dsoelems.add(e);
                if (0 != ((String)entry.getKey()).compareTo(((FieldDefinition)entry.getValue()).getName())) {
                    throw new WMRuntimeException("key: " + (String)entry.getKey() + " != " + ((FieldDefinition)entry.getValue()).getName());
                }
                e.setName((String)entry.getKey());
                if (null != ((FieldDefinition)entry.getValue()).getTypeDefinition()) {
                    e.setTypeRef(((FieldDefinition)entry.getValue()).getTypeDefinition().getTypeName());
                }
                e.setIsList(((FieldDefinition)entry.getValue()).getDimensions() > 0);
                e.setAllowNull(((FieldDefinition)entry.getValue()).isAllowNull());
                for (OperationEnumeration oe : ((FieldDefinition)entry.getValue()).getRequire()) {
                    e.getRequire().add(oe);
                }
                for (OperationEnumeration oe : ((FieldDefinition)entry.getValue()).getExclude()) {
                    e.getExclude().add(oe);
                }
                for (OperationEnumeration oe : ((FieldDefinition)entry.getValue()).getNoChange()) {
                    e.getNoChange().add(oe);
                }
            }
        }
    }

    public Map<String, String> getPrimitives() {
        return this.primitivesMap;
    }

    public List<DataObject> getDataObjects() {
        ArrayList<DataObject> ret = new ArrayList<DataObject>();
        ret.addAll(this.primitiveTypes);
        ret.addAll(this.getLocalDataObjects());
        return ret;
    }

    public List<DataObject> getLocalDataObjects() {
        HashSet<DataObject> ret = new HashSet<DataObject>();
        SortedSet<Service> services = this.getServices();
        for (Service service : services) {
            if (null == service.getDataobjects()) continue;
            List<DataObject> serviceObjects = service.getDataobjects().getDataobject();
            ret.addAll(serviceObjects);
        }
        return new ArrayList<DataObject>(ret);
    }

    public List<DataObject> getLocalDataObjects(String serviceId) {
        Service service = this.getService(serviceId);
        if (null != service.getDataobjects()) {
            return service.getDataobjects().getDataobject();
        }
        return new ArrayList<DataObject>();
    }

    public List<DataObject> getPrimitiveDataObjects() {
        return this.primitiveTypes;
    }

    public DataObject findDataObjectFromJavaType(String javaType) {
        for (DataObject dataobject : this.getLocalDataObjects()) {
            if (!dataobject.getJavaType().equals(javaType)) continue;
            return dataobject;
        }
        return null;
    }

    public List<String> getExcludeTypeNames(String serviceId) {
        ArrayList<String> excludeTypeNames = new ArrayList<String>();
        SortedSet<String> serviceIds = this.getServiceIds();
        for (String id : serviceIds) {
            if (serviceId.equals(id)) continue;
            List<DataObject> dos = this.getLocalDataObjects(id);
            for (DataObject d : dos) {
                excludeTypeNames.add(d.getJavaType());
            }
        }
        return excludeTypeNames;
    }

    public ClassLoader getServiceRuntimeClassLoader(String sid) {
        ClassLoader rtn = ClassLoaderUtils.getClassLoaderForFile((File[])new File[]{this.getServiceRuntimeDirectory(sid), this.projectManager.getCurrentProject().getWebInfClasses()});
        return rtn;
    }

    protected void doUpdateOperation(ServiceOperation so, Service service, ServiceDefinition sd) {
        List<Operation.Parameter> params;
        List<Operation> ops = service.getOperation();
        Operation op = null;
        for (Operation opTemp : ops) {
            if (!opTemp.getName().equals(so.getName())) continue;
            op = opTemp;
            break;
        }
        if (null == op) {
            op = new Operation();
            op.setName(so.getName());
            ops.add(op);
        }
        if ((params = op.getParameter()).size() > 0) {
            params.clear();
        }
        for (FieldDefinition input : so.getParameterTypes()) {
            Operation.Parameter param = new Operation.Parameter();
            param.setIsList(input.getDimensions() > 0);
            param.setName(input.getName());
            if (null != input.getTypeDefinition()) {
                param.setTypeRef(input.getTypeDefinition().getTypeName());
            }
            params.add(param);
        }
        if (null != so.getReturnType()) {
            Operation.Return ret = new Operation.Return();
            ret.setIsList(so.getReturnType().getDimensions() > 0);
            if (null != so.getReturnType().getTypeDefinition()) {
                ret.setTypeRef(so.getReturnType().getTypeDefinition().getTypeName());
            }
            op.setReturn(ret);
        }
    }

    public Map<Project, Map<String, Service>> getAllServiceDefinitions() {
        return this.serviceDefinitions;
    }

    private Map<String, Service> getCurrentServiceDefinitions() {
        HashMap<String, Service> ret;
        Project currentProject = this.getProjectManager().getCurrentProject();
        if (this.serviceDefinitions.containsKey(currentProject)) {
            ret = this.serviceDefinitions.get(currentProject);
        } else {
            ret = new HashMap<String, Service>();
            ret.put(RUNTIME_SERVICE_ID, this.runtimeService);
            this.serviceDefinitions.put(currentProject, ret);
        }
        return ret;
    }

    public static String beanClassToId(String beanClass) {
        String ret = beanClass;
        if (-1 != ret.indexOf(46)) {
            ret = ret.substring(ret.lastIndexOf(46) + 1);
        }
        ret = ret.substring(0, 1).toLowerCase() + ret.substring(1);
        return ret;
    }

    private Service loadServiceDefinition(String serviceId) {
        Service ret = null;
        File serviceDefFile = this.getServiceDefXml(serviceId);
        if (serviceDefFile.exists()) {
            try {
                ret = DesignServiceManager.loadServiceDefinition(serviceDefFile);
                if (null == ret.getId() || "" == ret.getId()) {
                    throw new WMRuntimeException(Resource.INVALID_SERVICE_DEF_NO_ID, new Object[]{serviceId});
                }
            }
            catch (JAXBException e) {
                throw new WMRuntimeException(Resource.ERROR_LOADING_SERVICEDEF, (Throwable)e, new Object[]{serviceId, serviceDefFile, e.getMessage()});
            }
        }
        return ret;
    }

    public static Service loadServiceDefinition(File serviceDefXml) throws JAXBException {
        Unmarshaller unmarshaller = definitionsContext.createUnmarshaller();
        return (Service)unmarshaller.unmarshal(serviceDefXml);
    }

    public static Service loadServiceDefinition(InputStream serviceDefIS) throws JAXBException {
        Unmarshaller unmarshaller = definitionsContext.createUnmarshaller();
        return (Service)unmarshaller.unmarshal(serviceDefIS);
    }

    public void saveServiceDefinition(String serviceId) {
        File serviceDefFile = this.getServiceDefXml(serviceId);
        Service service = this.getCurrentServiceDefinition(serviceId);
        try {
            FileUtils.forceMkdir((File)this.getServiceDesigntimeDirectory(service.getId()));
            Marshaller marshaller = definitionsContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)service, serviceDefFile);
            TreeSet<Service> s = new TreeSet<Service>();
            s.add(service);
            this.generateRuntimeConfiguration(s);
        }
        catch (JAXBException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    public void setDesignServiceTypes(List<DesignServiceType> designServiceTypes) {
        this.designServiceTypes = designServiceTypes;
    }

    public List<DesignServiceType> getDesignServiceTypes() {
        return this.designServiceTypes;
    }

    static {
        RESERVED_WORDS = new HashSet<String>(DataServiceUtils.RESERVED_WORDS.size());
        RESERVED_WORDS.addAll(DataServiceUtils.RESERVED_WORDS);
        try {
            definitionsContext = JAXBContext.newInstance((String)"com.wavemaker.tools.service.definitions");
        }
        catch (JAXBException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }
}

