/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.service;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.IOUtils;
import com.wavemaker.runtime.service.definition.DeprecatedServiceDefinition;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.ServiceUtils;
import com.wavemaker.tools.service.codegen.GenerationConfiguration;
import com.wavemaker.tools.service.codegen.GenerationException;
import com.wavemaker.tools.service.codegen.ServiceGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceClassGenerator {
    private Log logger = LogFactory.getLog(ServiceClassGenerator.class);
    private List<File> services = new ArrayList<File>();
    private Map<File, String> serviceToServiceId = new HashMap<File, String>();
    private File outputDirectory = null;
    private DesignServiceManager serviceManager = null;

    public void setDesignServiceManager(DesignServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void addService(List<File> serviceFiles) {
        this.addService(serviceFiles, null);
    }

    public void addService(List<File> serviceFiles, String serviceId) {
        for (File f : serviceFiles) {
            this.addService(f, serviceId);
        }
    }

    public void addService(File f) {
        this.addService(f, null);
    }

    public void addService(File f, String serviceId) {
        this.services.add(f);
        if (serviceId != null) {
            this.serviceToServiceId.put(f, serviceId);
        }
    }

    public void run() {
        if (this.serviceManager == null) {
            throw new ConfigurationException("serviceMgr cannot be null");
        }
        for (File f : this.services) {
            File rtdir;
            long l;
            String serviceId;
            DeprecatedServiceDefinition def = ServiceUtils.getServiceDefinition(f, serviceId = this.serviceToServiceId.get(f), this.serviceManager);
            if (null == def) continue;
            GenerationConfiguration cfg = new GenerationConfiguration(def, this.outputDirectory);
            ServiceGenerator generator = ServiceUtils.getServiceGenerator(cfg);
            if (generator.isUpToDate(l = IOUtils.getMostRecentModificationTime((File)(rtdir = this.serviceManager.getServiceRuntimeDirectory(serviceId))))) {
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("service " + def.getServiceId() + " is up to date"));
                continue;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("service " + def.getServiceId() + " needs to be re-generated"));
            }
            try {
                generator.generate();
            }
            catch (GenerationException ex) {
                throw new WMRuntimeException((Throwable)((Object)ex));
            }
            finally {
                try {
                    def.dispose();
                }
                catch (RuntimeException ex) {
                    this.logger.warn((Object)"Error while cleaning up", (Throwable)ex);
                }
            }
        }
    }
}

