/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.service;

import com.wavemaker.runtime.service.definition.ServiceDefinition;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.ServiceDefinitionFactory;
import com.wavemaker.tools.service.ServiceGeneratorFactory;
import com.wavemaker.tools.service.codegen.GenerationConfiguration;
import com.wavemaker.tools.service.codegen.ServiceGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ServiceFactoryManager {
    private static final ServiceFactoryManager instance = new ServiceFactoryManager();
    private List<ServiceDefinitionFactory> sdf = new ArrayList<ServiceDefinitionFactory>();
    private List<ServiceGeneratorFactory> sgf = new ArrayList<ServiceGeneratorFactory>();

    public static ServiceFactoryManager getInstance() {
        return instance;
    }

    private ServiceFactoryManager() {
    }

    public void addServiceDefinitionFactory(ServiceDefinitionFactory f) {
        this.sdf.add(f);
    }

    public void addServiceGeneratorFactory(ServiceGeneratorFactory f) {
        this.sgf.add(f);
    }

    public ServiceDefinition getServiceDefinition(File f, String serviceId, DesignServiceManager serviceManager) {
        for (ServiceDefinitionFactory fac : this.sdf) {
            ServiceDefinition rtn = fac.getServiceDefinition(f, serviceId, serviceManager);
            if (rtn == null) continue;
            return rtn;
        }
        return null;
    }

    public ServiceGenerator getServiceGenerator(GenerationConfiguration cfg) {
        for (ServiceGeneratorFactory fac : this.sgf) {
            ServiceGenerator rtn = fac.getServiceGenerator(cfg);
            if (rtn == null) continue;
            return rtn;
        }
        return null;
    }
}

