/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.service;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceGeneratorConfig {
    private File destDir = null;
    private File service = null;
    private String destinationPackage = null;
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private List<File> serviceFiles = null;
    private final Task parent;

    public ServiceGeneratorConfig(Task parent) {
        this.parent = parent;
    }

    public void validate() {
        if (this.service != null) {
            if (this.service.exists()) {
                if (this.service.isDirectory()) {
                    throw new BuildException("Service cannot be a directory: " + this.service.getAbsolutePath() + ".  Use a nested fileset to load all files within a directory.");
                }
            } else {
                throw new BuildException(this.service.getAbsolutePath() + " doesn't exist");
            }
        }
        if (this.getServiceFiles().size() == 0) {
            throw new BuildException("Either \"service\" must be set, or use a nested fileset");
        }
        if (this.destDir == null) {
            throw new BuildException("\"destDir\" must be set");
        }
    }

    public void addServiceFile(File f) {
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public List<File> getServiceFiles() {
        if (this.serviceFiles != null) {
            return this.serviceFiles;
        }
        this.serviceFiles = new ArrayList<File>();
        for (FileSet fs : this.filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.parent.getProject());
            String[] includedFiles = ds.getIncludedFiles();
            for (int i = 0; i < includedFiles.length; ++i) {
                this.serviceFiles.add(new File(ds.getBasedir(), includedFiles[i]));
            }
        }
        if (this.service != null) {
            this.serviceFiles.add(this.service);
        }
        return this.serviceFiles;
    }

    public void setPackage(String s) {
        this.destinationPackage = s;
    }

    public String getPackage() {
        return this.destinationPackage;
    }

    public void setService(File f) {
        this.service = f;
    }

    public void setDestDir(File f) {
        this.destDir = f;
    }

    public File getOutputDirectory() {
        return this.destDir;
    }
}

