/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.service.codegen;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.common.util.ClassUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.common.util.TypeConversionUtils;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.service.codegen.GenerationUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanGenerator {
    private static final String EQUALS_METHOD = "equals";
    private static final String HASHCODE_METHOD = "hashCode";
    private static final String VALUEOF_METHOD = "valueOf";
    private static final String CLOB_TYPE = "java.sql.Clob";
    private static final String BLOB_TYPE = "java.sql.Blob";
    private final int CONSTANT_MODIFIERS = 25;
    private final JCodeModel codeModel = new JCodeModel();
    private final JDefinedClass cls;
    private final Map<JVar, Object> constants = new LinkedHashMap<JVar, Object>();
    private List<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
    private boolean addSimpleTypesOnlyCtor = false;
    private boolean addEqualsHashCode = false;
    private boolean initCollections = false;
    private boolean addCollectionsLast = true;

    public BeanGenerator(String className) {
        try {
            this.cls = this.codeModel._class(className);
        }
        catch (JClassAlreadyExistsException ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
    }

    public String getFullyQualifiedClassName() {
        return this.cls.fullName();
    }

    public String getClassName() {
        return this.cls.name();
    }

    public JDefinedClass getModelClass() {
        return this.cls;
    }

    public void addClassJavadoc(String comment) {
        this.cls.javadoc().add((Object)comment);
    }

    public void addSimpleTypesOnlyCtor() {
        this.addSimpleTypesOnlyCtor = true;
    }

    public void initCollections() {
        this.initCollections = true;
    }

    public void addStringConstant(String name, String value) {
        JFieldVar v = this.cls.field(25, String.class, name, JExpr.lit((String)value));
        this.constants.put((JVar)v, value);
    }

    public void implSerializable() {
        this.cls._implements(Serializable.class);
    }

    public PropertyDescriptor addProperty(String name, Class<?> type) {
        return this.addProperty(name, type.getName());
    }

    public PropertyDescriptor addProperty(String name, String type) {
        PropertyDescriptor pd = new PropertyDescriptor(name, type);
        this.properties.add(pd);
        return pd;
    }

    public void addEqualsHashCode() {
        this.addEqualsHashCode = true;
    }

    public void generate(OutputStream os) throws IOException {
        if (this.addCollectionsLast) {
            ArrayList<PropertyDescriptor> collections = new ArrayList<PropertyDescriptor>();
            ArrayList<PropertyDescriptor> l = new ArrayList<PropertyDescriptor>(this.properties.size());
            for (PropertyDescriptor pd : this.properties) {
                if (pd.isCollection()) {
                    collections.add(pd);
                    continue;
                }
                l.add(pd);
            }
            l.addAll(collections);
            this.properties = l;
        }
        ArrayList<JFieldVar> members = new ArrayList<JFieldVar>();
        for (PropertyDescriptor propertyDescriptor : this.properties) {
            JClass primitiveType;
            String name = propertyDescriptor.getName();
            JClass type = primitiveType = this.codeModel.ref(propertyDescriptor.getType());
            if (propertyDescriptor.isCollection()) {
                type = this.getGenericCollection((JType)primitiveType, propertyDescriptor.getCollectionType());
            }
            JInvocation rhs = null;
            if (this.initCollections && propertyDescriptor.isCollection()) {
                JType concreteType = this.getGenericCollection((JType)primitiveType, propertyDescriptor.getConcreteCollectionType());
                rhs = JExpr._new((JType)concreteType);
            }
            JFieldVar jfv = this.cls.field(4, (JType)type, name, rhs);
            members.add(jfv);
        }
        if (this.addEqualsHashCode) {
            this.addEquals();
            this.addHashCode();
        }
        for (JVar jVar : members) {
            this.addAccessors(jVar);
        }
        OutputStreamCodeWriter codeWriter = new OutputStreamCodeWriter(os);
        this.codeModel.build((CodeWriter)codeWriter, (CodeWriter)codeWriter);
    }

    public void generateAux(OutputStream os) throws IOException {
        if (this.addCollectionsLast) {
            ArrayList<PropertyDescriptor> collections = new ArrayList<PropertyDescriptor>();
            ArrayList<PropertyDescriptor> l = new ArrayList<PropertyDescriptor>(this.properties.size());
            for (PropertyDescriptor pd : this.properties) {
                if (pd.isCollection()) {
                    collections.add(pd);
                    continue;
                }
                l.add(pd);
            }
            l.addAll(collections);
            this.properties = l;
        }
        ArrayList<JVar> members = new ArrayList<JVar>();
        ArrayList<JVar> membersAux = new ArrayList<JVar>();
        for (PropertyDescriptor property : this.properties) {
            JFieldVar jfvAux;
            String auxName;
            JClass primitiveAuxType;
            JClass primitiveType;
            String name = property.getName();
            JClass type = primitiveType = this.codeModel.ref(property.getType());
            if (property.isCollection()) {
                type = this.getGenericCollection((JType)primitiveType, property.getCollectionType());
            }
            JInvocation rhs = null;
            if (this.initCollections && property.isCollection()) {
                JType concreteType = this.getGenericCollection((JType)primitiveType, property.getConcreteCollectionType());
                rhs = JExpr._new((JType)concreteType);
            }
            JFieldVar jfv = this.cls.field(4, (JType)type, name, rhs);
            members.add((JVar)jfv);
            if (property.getType().equals(BLOB_TYPE)) {
                primitiveAuxType = this.codeModel.ref("byte[]");
                auxName = name + "Aux";
                jfvAux = this.cls.field(4, (JType)primitiveAuxType, auxName, (JExpression)rhs);
                membersAux.add((JVar)jfvAux);
                continue;
            }
            if (!property.getType().equals(CLOB_TYPE)) continue;
            primitiveAuxType = this.codeModel.ref("java.lang.String");
            auxName = name + "Aux";
            jfvAux = this.cls.field(4, (JType)primitiveAuxType, auxName, (JExpression)rhs);
            membersAux.add((JVar)jfvAux);
        }
        for (JVar v : membersAux) {
            members.add(v);
        }
        this.addDefaultConstructor();
        if (this.addSimpleTypesOnlyCtor && !this.onlyHasSimpleTypes()) {
            this.addConstructor(members, true);
        }
        this.addConstructor(members, false);
        if (this.addEqualsHashCode) {
            this.addEquals();
            this.addHashCode();
        }
        for (JVar v : members) {
            this.addAccessorsAux(v, membersAux);
        }
        OutputStreamCodeWriter codeWriter = new OutputStreamCodeWriter(os);
        this.codeModel.build((CodeWriter)codeWriter, (CodeWriter)codeWriter);
    }

    private JType getGenericCollection(JType primitiveType, Class<?> collectionType) {
        try {
            return GenerationUtils.getGenericCollectionType(this.codeModel, collectionType.getName(), primitiveType);
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationException(ex);
        }
    }

    private void addDefaultConstructor() {
        if (this.isConstantsClass()) {
            JMethod ctor = this.cls.constructor(4);
            JBlock body = ctor.body();
            body._throw((JExpression)JExpr._new((JClass)this.codeModel.ref(UnsupportedOperationException.class)));
        } else {
            this.cls.constructor(1);
        }
    }

    private boolean onlyHasSimpleTypes() {
        for (PropertyDescriptor pd : this.properties) {
            if (this.isSimpleType(pd)) continue;
            return false;
        }
        return true;
    }

    private boolean isSimpleType(PropertyDescriptor pd) {
        try {
            Class c = ClassLoaderUtils.loadClass((String)pd.getType(), (boolean)false);
            return TypeConversionUtils.isPrimitiveOrWrapper((Class)c);
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    private void addConstructor(List<JVar> members, boolean onlyIncludeSimpleTypes) {
        List<PropertyDescriptor> props = this.properties;
        List<JVar> memberVars = members;
        if (onlyIncludeSimpleTypes) {
            props = new ArrayList<PropertyDescriptor>(this.properties.size());
            memberVars = new ArrayList<JVar>(this.properties.size());
            for (int i = 0; i < this.properties.size(); ++i) {
                PropertyDescriptor pd = this.properties.get(i);
                if (!this.isSimpleType(pd)) continue;
                props.add(pd);
                memberVars.add(members.get(i));
            }
        }
        if (props.isEmpty()) {
            return;
        }
        this.addConstructor(memberVars, props);
    }

    private void addConstructor(List<JVar> memberVars, List<PropertyDescriptor> props) {
        int i;
        JMethod ctor = this.cls.constructor(1);
        ArrayList<JVar> args = new ArrayList<JVar>(props.size());
        for (i = 0; i < props.size(); ++i) {
            PropertyDescriptor pd = props.get(i);
            JType type = memberVars.get(i).type();
            args.add(this.addParam(ctor, pd.getName(), type));
        }
        for (i = 0; i < props.size(); ++i) {
            JBlock block = ctor.body();
            JFieldRef ref = JExpr._this().ref(props.get(i).getName());
            this.assignToMember(block, ref, (JVar)args.get(i));
        }
    }

    private void assignToMember(JBlock block, JVar lhs, JVar rhs) {
        this.assignToMember(block, JExpr._this().ref(lhs), rhs);
    }

    private void assignToMember(JBlock block, JFieldRef lhs, JVar rhs) {
        block.assign((JAssignmentTarget)lhs, (JExpression)rhs);
    }

    private JVar addParam(JMethod method, JVar property) {
        return this.addParam(method, property.name(), property.type());
    }

    private JVar addParam(JMethod method, String name, JType type) {
        return method.param(type, name);
    }

    private void addAccessors(JVar property) {
        String name = property.name();
        JType type = property.type();
        this.cls.method(1, type, ClassUtils.getPropertyGetterName((String)name)).body()._return((JExpression)property);
        JMethod setter = this.cls.method(1, (JType)this.codeModel.VOID, ClassUtils.getPropertySetterName((String)name));
        JVar param = this.addParam(setter, property);
        this.assignToMember(setter.body(), property, param);
    }

    private void addAccessorsAux(JVar property, List<JVar> auxMembers) {
        String name = property.name();
        JType type = property.type();
        this.cls.method(1, type, ClassUtils.getPropertyGetterName((String)name)).body()._return((JExpression)property);
        JMethod setter = this.cls.method(1, (JType)this.codeModel.VOID, ClassUtils.getPropertySetterName((String)name));
        JVar param = this.addParam(setter, property);
        this.assignToMember(setter.body(), property, param);
        this.augmentSettersAux(setter, property, auxMembers);
    }

    private void augmentSettersAux(JMethod setter, JVar property, List<JVar> auxMembers) {
        String vName;
        String name = property.name();
        JType type = property.type();
        JBlock setterBlock = setter.body();
        boolean addExceptions = false;
        if (type.fullName().equals(CLOB_TYPE)) {
            for (JVar v : auxMembers) {
                vName = v.name();
                if (!vName.substring(0, name.length()).equals(name)) continue;
                setterBlock.directStatement("if (" + name + " != null) {");
                setterBlock.directStatement("    java.io.Reader r = " + name + ".getCharacterStream();");
                setterBlock.directStatement("    char[] arr = new char[((int) " + name + ".length() + 1)];");
                setterBlock.directStatement("    r.read(arr);");
                setterBlock.directStatement("    this." + vName + " = " + "new java.lang.String(arr);");
                setterBlock.directStatement("}");
                setterBlock.directStatement("else {");
                setterBlock.directStatement("    this." + vName + " = null;");
                setterBlock.directStatement("}");
            }
            addExceptions = true;
        }
        if (type.fullName().equals(BLOB_TYPE)) {
            for (JVar v : auxMembers) {
                vName = v.name();
                if (!vName.substring(0, name.length()).equals(name)) continue;
                setterBlock.directStatement("if (" + name + " != null) {");
                setterBlock.directStatement("    java.io.InputStream r = " + name + ".getBinaryStream();");
                setterBlock.directStatement("    byte[] arr = new byte[((int) " + name + ".length() + 1)];");
                setterBlock.directStatement("    r.read(arr);");
                setterBlock.directStatement("    this." + vName + " = arr;");
                setterBlock.directStatement("}");
                setterBlock.directStatement("else {");
                setterBlock.directStatement("    this." + vName + " = null;");
                setterBlock.directStatement("}");
            }
            addExceptions = true;
        }
        if (addExceptions) {
            setter._throws(IOException.class);
            setter._throws(SQLException.class);
        }
    }

    private boolean isConstantsClass() {
        return this.properties.isEmpty() && !this.constants.isEmpty();
    }

    private void addEquals() {
        JMethod m = this.cls.method(1, Boolean.TYPE, EQUALS_METHOD);
        JVar param = m.param(Object.class, "o");
        JBlock body = m.body();
        body._if(param.eq(JExpr._this()))._then()._return(JExpr.TRUE);
        body._if(param._instanceof((JType)this.cls).not())._then()._return(JExpr.FALSE);
        JVar other = body.decl((JType)this.cls, "other", (JExpression)JExpr.cast((JType)this.cls, (JExpression)param));
        for (PropertyDescriptor pd : this.properties) {
            JFieldRef _thisProp = JExpr._this().ref(pd.getName());
            JFieldRef otherProp = other.ref(pd.getName());
            if (pd.isPrimitive()) {
                body._if(_thisProp.ne((JExpression)otherProp))._then()._return(JExpr.FALSE);
                continue;
            }
            JConditional cond = body._if(_thisProp.eq(JExpr._null()));
            cond._then()._if(otherProp.ne(JExpr._null()))._then()._return(JExpr.FALSE);
            cond._else()._if(_thisProp.invoke(EQUALS_METHOD).arg((JExpression)otherProp).not())._then()._return(JExpr.FALSE);
        }
        body.block()._return(JExpr.TRUE);
    }

    private void addHashCode() {
        JMethod m = this.cls.method(1, Integer.TYPE, HASHCODE_METHOD);
        JBlock body = m.body();
        JVar rtn = body.decl((JType)this.codeModel.ref("int"), "rtn", JExpr.lit((int)17));
        for (PropertyDescriptor pd : this.properties) {
            JFieldRef _thisProp = JExpr._this().ref(pd.getName());
            body.assign((JAssignmentTarget)rtn, rtn.mul(JExpr.lit((int)37)));
            if (pd.isPrimitive()) {
                body.assign((JAssignmentTarget)rtn, rtn.plus((JExpression)this.codeModel.ref(String.class).staticInvoke(VALUEOF_METHOD).arg((JExpression)_thisProp).invoke(HASHCODE_METHOD)));
                continue;
            }
            body._if(_thisProp.ne(JExpr._null()))._then().assign((JAssignmentTarget)rtn, rtn.plus((JExpression)_thisProp.invoke(HASHCODE_METHOD)));
        }
        body._return((JExpression)rtn);
    }

    private class OutputStreamCodeWriter
    extends CodeWriter {
        private final OutputStream os;

        public OutputStreamCodeWriter(OutputStream os) {
            this.os = new PrintStream(os);
        }

        public OutputStream openBinary(JPackage pkg, String fileName) {
            return this.os;
        }

        public void close() throws IOException {
            this.os.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PropertyDescriptor {
        private final String name;
        private String type;
        private boolean isPrimitiveType;
        private boolean isCollection = false;
        private Class<?> collectionType = Collection.class;
        private Class<?> concreteCollectionType = HashSet.class;

        public PropertyDescriptor(String name, String type) {
            this.name = name;
            this.type = type;
            this.initIsPrimitive();
            this.initIsCollection();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isCollection() {
            return this.isCollection;
        }

        public void setCollection() {
            this.isCollection = true;
        }

        public Class<?> getConcreteCollectionType() {
            return this.concreteCollectionType;
        }

        public void setConcreteCollectionType(Class<?> concreteCollectionType) {
            this.concreteCollectionType = concreteCollectionType;
        }

        public Class<?> getCollectionType() {
            return this.collectionType;
        }

        public void setCollectionType(Class<?> collectionType) {
            this.collectionType = collectionType;
            this.isCollection = true;
        }

        public boolean isPrimitive() {
            return !this.isCollection && this.isPrimitiveType;
        }

        private void initIsPrimitive() {
            try {
                Class c = ClassLoaderUtils.loadClass((String)this.type, (boolean)false);
                this.isPrimitiveType = c.isPrimitive();
            }
            catch (RuntimeException ex) {
                this.isPrimitiveType = false;
            }
        }

        private void initIsCollection() {
            Tuple.Two<String, String> t = GenerationUtils.splitGenericType(this.type);
            if (t == null) {
                return;
            }
            this.collectionType = ClassLoaderUtils.loadClass((String)((String)t.v1), (boolean)false);
            this.concreteCollectionType = this.collectionType;
            this.type = (String)t.v2;
            this.isCollection = true;
        }
    }
}

