/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.service.codegen;

import com.wavemaker.common.util.StringUtils;
import com.wavemaker.tools.service.codegen.BeanGenerator;
import com.wavemaker.tools.service.definitions.DataObject;
import com.wavemaker.tools.service.definitions.Service;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDataObjectGenerator {
    private final Service service;
    private final Class<?> collectionType;
    private Collection<String> serializableTypes = Collections.emptySet();
    private Collection<String> equalsHashCodeTypes = Collections.emptySet();
    private int index = 0;

    public ServiceDataObjectGenerator(Service service) {
        this(service, Collection.class);
    }

    public ServiceDataObjectGenerator(Service service, Class<?> collectionType) {
        this.service = service;
        this.collectionType = collectionType;
    }

    public String getCurrentTypeName() {
        DataObject o = this.getCurrentDataObject();
        return o.getJavaType();
    }

    public boolean hasNext() {
        return this.index < this.service.getDataobjects().getDataobject().size();
    }

    public void generateNext(OutputStream os) throws IOException {
        DataObject o = this.getCurrentDataObject();
        this.setupGenerator(o).generate(os);
        ++this.index;
    }

    public void setSerializableTypes(Collection<String> serializableTypes) {
        this.serializableTypes = serializableTypes;
    }

    public void setEqualsHashCodeTypes(Collection<String> equalsHashCodeTypes) {
        this.equalsHashCodeTypes = equalsHashCodeTypes;
    }

    private DataObject getCurrentDataObject() {
        List<DataObject> l = this.service.getDataobjects().getDataobject();
        if (this.index == l.size()) {
            throw new IndexOutOfBoundsException();
        }
        return l.get(this.index);
    }

    private BeanGenerator setupGenerator(DataObject o) {
        BeanGenerator rtn = new BeanGenerator(o.getJavaType());
        rtn.addSimpleTypesOnlyCtor();
        rtn.initCollections();
        rtn.addClassJavadoc(" " + this.service.getId() + "." + o.getName() + "\n" + StringUtils.getFormattedDate());
        if (this.serializableTypes.contains(o.getJavaType())) {
            rtn.implSerializable();
        }
        if (this.equalsHashCodeTypes.contains(o.getJavaType())) {
            rtn.addEqualsHashCode();
        }
        for (DataObject.Element element : o.getElement()) {
            String name = element.getName();
            String type = element.getTypeRef();
            BeanGenerator.PropertyDescriptor pd = rtn.addProperty(name, type);
            if (!element.isIsList()) continue;
            pd.setCollectionType(this.collectionType);
        }
        return rtn;
    }
}

