/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.service.codegen;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.runtime.service.ElementType;
import com.wavemaker.runtime.service.definition.DeprecatedServiceDefinition;
import com.wavemaker.tools.service.codegen.GenerationConfiguration;
import com.wavemaker.tools.service.codegen.GenerationException;
import com.wavemaker.tools.service.codegen.GenerationUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.NDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceGenerator {
    protected static final String NDC_PUSH = "push";
    protected static final String NDC_POP = "pop";
    private Log logger = LogFactory.getLog((String)"com.wavemaker.runtime.service.codegen");
    protected GenerationConfiguration configuration;
    protected DeprecatedServiceDefinition serviceDefinition;
    protected JCodeModel codeModel;
    protected boolean useNDCLogging = false;

    public ServiceGenerator(GenerationConfiguration configuration) {
        this.configuration = configuration;
        this.serviceDefinition = configuration.getServiceDefinition();
        this.codeModel = new JCodeModel();
    }

    protected void preGeneration() throws GenerationException {
    }

    protected void postGeneration() throws GenerationException {
    }

    protected String getClassName() {
        return this.serviceDefinition.getServiceClass();
    }

    protected void generateClassJavadoc(JDocComment jdoc) {
        this.addJavadoc(jdoc);
    }

    protected void preGenerateClassBody(JDefinedClass cls) throws GenerationException {
    }

    protected void postGenerateClassBody(JDefinedClass cls) throws GenerationException {
    }

    protected void generateDefaultConstructorBody(JBlock body) throws GenerationException {
    }

    protected boolean hasDefaultConstructor() {
        return true;
    }

    protected void generateOperationMethodBody(JMethod method, JBlock body, String operationName, Map<String, JType> inputJTypeMap, JType outputJType, Integer overloadCount) throws GenerationException {
    }

    public boolean isUpToDate(long srcLastModified) {
        if (srcLastModified == 0L) {
            return false;
        }
        File f = new File(this.configuration.getOutputDirectory(), StringUtils.classNameToSrcFilePath((String)this.getClassName()));
        if (!f.exists()) {
            return false;
        }
        return srcLastModified <= f.lastModified();
    }

    protected List<List<ElementType>> getOverloadedVersions(String operationName) {
        return Collections.emptyList();
    }

    public void generate() throws GenerationException {
        this.preGeneration();
        JDefinedClass serviceCls = this.generateClass();
        this.preGenerateClassBody(serviceCls);
        this.generateClassJavadoc(serviceCls.javadoc());
        if (this.hasDefaultConstructor()) {
            JMethod defaultConst = this.generateDefaultConstructor(serviceCls);
            JBlock defaultConstBody = defaultConst.body();
            this.generateDefaultConstructorBody(defaultConstBody);
        }
        List<String> operationNames = this.serviceDefinition.getOperationNames();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generating service class with operations: " + operationNames));
        }
        for (int i = 0; i < operationNames.size(); ++i) {
            String operationName = operationNames.get(i);
            List<ElementType> inputTypes = this.serviceDefinition.getInputTypes(operationName);
            this.generateOperationMethod(serviceCls, operationName, inputTypes, null);
            int j = 0;
            List<List<ElementType>> overloadedVersions = this.getOverloadedVersions(operationName);
            for (List<ElementType> overloadedInputTypes : overloadedVersions) {
                this.generateOperationMethod(serviceCls, operationName, overloadedInputTypes, j++);
            }
        }
        this.postGenerateClassBody(serviceCls);
        try {
            this.configuration.getOutputDirectory().mkdirs();
            this.codeModel.build(this.configuration.getOutputDirectory(), this.configuration.getOutputDirectory(), null);
        }
        catch (IOException e) {
            throw new GenerationException("Unable to write service stub", e);
        }
        this.postGeneration();
    }

    protected JDefinedClass generateClass() throws GenerationException {
        String serviceClsName = this.getClassName();
        JDefinedClass serviceCls = null;
        try {
            serviceCls = this.codeModel._class(serviceClsName);
        }
        catch (JClassAlreadyExistsException e) {
            throw new GenerationException("Java class " + serviceClsName + " already exists", e);
        }
        return serviceCls;
    }

    protected JMethod generateDefaultConstructor(JDefinedClass serviceCls) throws GenerationException {
        JMethod constructor = serviceCls.constructor(1);
        return constructor;
    }

    protected void generateOperationMethod(JDefinedClass serviceCls, String operationName, List<ElementType> inputTypes, Integer overloadCount) throws GenerationException {
        ElementType outputType = this.serviceDefinition.getOutputType(operationName);
        JType outputJType = this.getJType(outputType);
        LinkedHashMap<String, JType> inputJTypeMap = new LinkedHashMap<String, JType>();
        JMethod method = serviceCls.method(1, outputJType, operationName);
        for (ElementType inputType : inputTypes) {
            JType paramJType = this.getJType(inputType);
            String paramName = inputType.getName();
            method.param(paramJType, paramName);
            inputJTypeMap.put(paramName, paramJType);
        }
        JBlock body = method.body();
        JTryBlock tryBlock = null;
        if (this.useNDCLogging) {
            tryBlock = body._try();
            body = tryBlock.body();
            body.staticInvoke(this.codeModel.ref(NDC.class), NDC_PUSH).arg(this.getClassName() + "." + operationName);
        }
        this.generateOperationMethodBody(method, body, operationName, inputJTypeMap, outputJType, overloadCount);
        if (this.useNDCLogging) {
            tryBlock._finally().block().staticInvoke(this.codeModel.ref(NDC.class), NDC_POP);
        }
    }

    protected JType getJType(ElementType elementType) throws GenerationException {
        try {
            if (elementType == null) {
                return this.codeModel.VOID;
            }
            if (elementType.isList()) {
                return this.getGenericListType(elementType.getJavaType());
            }
            return this.codeModel.parseType(elementType.getJavaType());
        }
        catch (ClassNotFoundException e) {
            throw new GenerationException(e);
        }
    }

    protected JType getGenericListType(String type) throws ClassNotFoundException {
        return GenerationUtils.getGenericCollectionType(this.codeModel, List.class.getName(), type);
    }

    private void addJavadoc(JDocComment jdoc) {
        jdoc.add((Object)(" Operations for service \"" + this.serviceDefinition.getServiceId() + "\"\n" + StringUtils.getFormattedDate()));
    }
}

