/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.spring;

import com.wavemaker.tools.service.FileService;
import com.wavemaker.tools.spring.BeansNamespaceMapper;
import com.wavemaker.tools.spring.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class SpringConfigSupport {
    public static final String SPRING_SCHEMA_LOCATION = "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd";
    public static final String SPRING_BEANS_PACKAGE = "com.wavemaker.tools.spring.beans";
    private static JAXBContext jaxbContext;

    public static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)SPRING_BEANS_PACKAGE);
        }
        return jaxbContext;
    }

    public static Beans readBeans(String configFile) throws JAXBException, IOException {
        StringReader reader = new StringReader(configFile);
        Beans ret = SpringConfigSupport.readBeans(new StringReader(configFile));
        ((Reader)reader).close();
        return ret;
    }

    public static Beans readBeans(File configFile, FileService fileService) throws JAXBException, IOException {
        Reader reader = fileService.getReader(configFile);
        Beans ret = SpringConfigSupport.readBeans(reader);
        reader.close();
        return ret;
    }

    public static Beans readBeans(Reader reader) throws JAXBException {
        Unmarshaller unmarshaller = SpringConfigSupport.getJAXBContext().createUnmarshaller();
        return (Beans)unmarshaller.unmarshal(reader);
    }

    public static void writeBeans(Beans beans, File configFile, FileService fileService) throws JAXBException, IOException {
        Writer writer = fileService.getWriter(configFile);
        SpringConfigSupport.writeBeans(beans, writer);
        writer.close();
    }

    public static void writeBeans(Beans beans, Writer writer) throws JAXBException, IOException {
        Marshaller marshaller = SpringConfigSupport.getJAXBContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.schemaLocation", (Object)SPRING_SCHEMA_LOCATION);
        marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new BeansNamespaceMapper());
        marshaller.marshal((Object)beans, writer);
    }
}

