/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.util;

import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.tools.common.Bootstrap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntUtils {
    public static void bootstrap(ClassLoader contextClassLoader) {
        ClassLoaderUtils.runInClassLoaderContext((ClassLoaderUtils.TaskType)new ClassLoaderUtils.TaskNoRtn(){

            public void run() {
                Bootstrap.main(null);
            }
        }, (ClassLoader)contextClassLoader);
    }

    public static void javac(String srcdir, File destdir) {
        AntUtils.javac(srcdir, destdir, null);
    }

    public static void javac(String srcdir, File destdir, String includes) {
        AntUtils.javac(srcdir, destdir, null, includes);
    }

    public static void javac(String srcdir, File destdir, String classpath, String includes) {
        Javac javac = new Javac();
        Project project = AntUtils.getProject();
        javac.setProject(project);
        javac.setSrcdir(new Path(project, srcdir));
        javac.setDestdir(destdir);
        javac.setFork(true);
        if (includes != null) {
            javac.setIncludes(includes);
        }
        if (classpath != null) {
            javac.setClasspath(new Path(project, classpath));
        }
        javac.perform();
    }

    public static void copyDir(File srcdir, File destdir) {
        AntUtils.copyDir(srcdir, destdir, (List<String>)null, (List<String>)null);
    }

    public static void copyDir(File srcdir, File destdir, String include, String exclude) {
        ArrayList<String> i = new ArrayList<String>(1);
        if (include != null) {
            i.add(include);
        }
        ArrayList<String> e = new ArrayList<String>(1);
        if (exclude != null) {
            e.add(exclude);
        }
        AntUtils.copyDir(srcdir, destdir, i, e);
    }

    public static void copyDir(File srcdir, File destdir, List<String> includes, List<String> excludes) {
        Copy cp = new Copy();
        cp.setProject(AntUtils.getProject());
        cp.setTodir(destdir);
        FileSet fs = new FileSet();
        cp.addFileset(fs);
        fs.setDir(srcdir);
        if (includes != null) {
            fs.setIncludes(ObjectUtils.toString(includes, (String)" "));
        }
        if (excludes != null) {
            fs.setExcludes(ObjectUtils.toString(excludes, (String)" "));
        }
        cp.perform();
    }

    public static void jar(File destfile, File basedir) {
        Jar jar = new Jar();
        jar.setProject(AntUtils.getProject());
        jar.setDestFile(destfile);
        jar.setBasedir(basedir);
        jar.perform();
    }

    public static void unjar(File jarfile, File destdir) {
        Expand unjar = new Expand();
        unjar.setProject(AntUtils.getProject());
        unjar.setSrc(jarfile);
        unjar.setDest(destdir);
        unjar.perform();
    }

    private static Project getProject() {
        Project rtn = new Project();
        rtn.addBuildListener(new SysoutLogger());
        return rtn;
    }

    private static class SysoutLogger
    extends DefaultLogger {
        public SysoutLogger() {
            this.setMessageOutputLevel(2);
            this.setOutputPrintStream(System.out);
            this.setEmacsMode(true);
        }
    }
}

