/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.util;

import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.project.DeploymentManager;
import com.wavemaker.tools.project.ProjectManager;
import com.wavemaker.tools.project.StudioConfiguration;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.DesignServiceType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DesignTimeUtils {
    private DesignTimeUtils() {
    }

    private static String getDefaultProjectHome() {
        String home = DesignTimeUtils.isRuntime() ? (String)RuntimeAccess.getInstance().getSession().getAttribute("wm.projectsDir") : System.getProperty("wm.projectsDir");
        return home;
    }

    private static void setDefaultProjectHome(String home) {
        if (DesignTimeUtils.isRuntime()) {
            RuntimeAccess.getInstance().getSession().setAttribute("wm.projectsDir", (Object)home);
        } else {
            System.setProperty("wm.projectsDir", home);
        }
    }

    private static void deleteDefaultProjectHomeProp() {
        if (DesignTimeUtils.isRuntime()) {
            RuntimeAccess.getInstance().getSession().removeAttribute("wm.projectsDir");
        } else {
            Properties props = System.getProperties();
            props.remove("wm.projectsDir");
            System.setProperties(props);
        }
    }

    private static boolean isRuntime() {
        try {
            if (RuntimeAccess.getInstance() != null && RuntimeAccess.getInstance().getRequest() != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DesignServiceManager getDSMForProjectRoot(File projectRoot) {
        DesignServiceManager designServiceManager;
        block10: {
            block9: {
                String oldProp = DesignTimeUtils.getDefaultProjectHome();
                try {
                    DesignTimeUtils.setDefaultProjectHome(projectRoot.getParentFile().getAbsolutePath());
                    DesignServiceManager dsm = new DesignServiceManager();
                    ClassPathXmlApplicationContext ac = new ClassPathXmlApplicationContext(new String[]{"springapp.xml", "designservicetypes.xml", "servicetypes.xml"});
                    Map dsts = ac.getBeansOfType(DesignServiceType.class);
                    dsm.setDesignServiceTypes(new ArrayList<DesignServiceType>());
                    for (Object o : dsts.values()) {
                        dsm.getDesignServiceTypes().add((DesignServiceType)o);
                    }
                    StudioConfiguration sc = new StudioConfiguration();
                    sc.setTestWaveMakerHome(projectRoot.getParentFile());
                    ProjectManager pm = new ProjectManager();
                    pm.setStudioConfiguration(sc);
                    pm.openProject(projectRoot.getName(), true);
                    dsm.setProjectManager(pm);
                    DeploymentManager dep = new DeploymentManager();
                    dep.setProjectManager(pm);
                    dep.setStudioConfiguration(sc);
                    dsm.setDeploymentManager(dep);
                    designServiceManager = dsm;
                    if (null == oldProp) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (null != oldProp) {
                            DesignTimeUtils.setDefaultProjectHome(oldProp);
                        } else {
                            DesignTimeUtils.deleteDefaultProjectHomeProp();
                        }
                        throw throwable;
                    }
                    catch (JAXBException ex) {
                        throw new ConfigurationException(ex);
                    }
                    catch (IOException ex) {
                        throw new ConfigurationException(ex);
                    }
                }
                DesignTimeUtils.setDefaultProjectHome(oldProp);
                break block10;
            }
            DesignTimeUtils.deleteDefaultProjectHomeProp();
        }
        return designServiceManager;
    }
}

