/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.util;

import com.wavemaker.tools.common.ConfigurationException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;

public class Server {
    private InetAddress ip = null;
    private int port = 8080;

    public Server() {
        try {
            this.ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public Server(String host, int port) {
        this.setHost(host);
        this.setPort(port);
    }

    public void setHost(String host) {
        try {
            this.ip = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public String getHostName() {
        return this.ip.getHostName();
    }

    public String getIP() {
        return this.ip.getHostAddress();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isListening() {
        try {
            new Socket(this.ip, this.port);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    protected HttpURLConnection getPutConnection(String uri) {
        HttpURLConnection rtn = this.getConnection(uri);
        try {
            rtn.setRequestMethod("PUT");
        }
        catch (ProtocolException ex) {
            throw new ConfigurationException(ex);
        }
        rtn.setDoOutput(true);
        return rtn;
    }

    protected HttpURLConnection getGetConnection(String uri) {
        HttpURLConnection rtn = this.getConnection(uri);
        try {
            rtn.setRequestMethod("GET");
        }
        catch (ProtocolException ex) {
            throw new ConfigurationException(ex);
        }
        rtn.setDoOutput(false);
        return rtn;
    }

    private HttpURLConnection getConnection(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        HttpURLConnection rtn = null;
        try {
            String url = "http://" + this.getHostName() + ":" + this.getPort() + "/" + uri;
            rtn = (HttpURLConnection)new URL(url).openConnection();
        }
        catch (MalformedURLException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        rtn.setAllowUserInteraction(false);
        rtn.setDoInput(true);
        rtn.setUseCaches(false);
        return rtn;
    }
}

