/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.util;

import com.wavemaker.common.util.IOUtils;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.util.Server;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatServer
extends Server {
    private static final String MANAGER_CHARSET = "utf-8";
    private static final String URL_ENCODE_CHARSET = "ISO-8859-1";
    private String username = "manager";
    private String password = "manager";
    private String managerUri = "manager";

    public TomcatServer() {
    }

    public TomcatServer(String host, int port) {
        super(host, port);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getManagerUri() {
        return this.managerUri;
    }

    public void setManagerUrl(String managerUri) {
        this.managerUri = managerUri;
    }

    public String deploy(File war) {
        return this.deploy(war, null);
    }

    public String deploy(File war, String contextRoot) {
        if (war == null) {
            throw new IllegalArgumentException("war cannot be null");
        }
        if (!war.exists()) {
            throw new IllegalArgumentException("war does not exist");
        }
        if (war.isDirectory()) {
            throw new IllegalArgumentException("war cannot be a directory");
        }
        if (contextRoot == null) {
            contextRoot = StringUtils.fromFirstOccurrence((String)war.getName(), (String)".", (int)-1);
        }
        contextRoot = this.checkContextRoot(contextRoot);
        String uri = this.getManagerUri() + "/deploy?" + this.getPathParam(contextRoot);
        HttpURLConnection con = super.getPutConnection(uri);
        con.setRequestProperty("Content-Type", "application/octet-stream");
        con.setRequestProperty("Content-Length", String.valueOf(war.length()));
        this.prepareConnection(con);
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(war));
            BufferedOutputStream bos = new BufferedOutputStream(con.getOutputStream());
            IOUtils.copy((InputStream)bis, (OutputStream)bos);
            bis.close();
            bos.close();
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        return ObjectUtils.toString(this.getResponse(con), (String)"");
    }

    public String undeploy(String contextRoot) {
        contextRoot = this.checkContextRoot(contextRoot);
        return ObjectUtils.toString(this.getResponse(this.getManagerGetConnection("undeploy?" + this.getPathParam(contextRoot))), (String)"");
    }

    public String redeploy(String contextRoot) {
        contextRoot = this.checkContextRoot(contextRoot);
        return ObjectUtils.toString(this.getResponse(this.getManagerGetConnection("reload?" + this.getPathParam(contextRoot))), (String)"");
    }

    public List<Tuple.Two<String, String>> listDeployments() {
        return this.listDeployments(true);
    }

    public List<Tuple.Two<String, String>> listDeployments(boolean excludeRootWebApp) {
        List<String> resp = this.getResponse(this.getManagerGetConnection("list"), false);
        ArrayList<Tuple.Two<String, String>> rtn = new ArrayList<Tuple.Two<String, String>>(resp.size());
        for (int i = 0; i < resp.size(); ++i) {
            String name = StringUtils.fromFirstOccurrence((String)resp.get(i), (String)":", (int)-1);
            String status = StringUtils.fromFirstOccurrence((String)resp.get(i), (String)":");
            status = StringUtils.fromFirstOccurrence((String)status, (String)":", (int)-1);
            if (name.equals("/") && excludeRootWebApp) continue;
            rtn.add((Tuple.Two<String, String>)Tuple.tuple((Object)name, (Object)status));
        }
        return rtn;
    }

    private String getPathParam(String contextRoot) {
        try {
            return "path=" + URLEncoder.encode(contextRoot, URL_ENCODE_CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private HttpURLConnection getManagerGetConnection(String command) {
        HttpURLConnection rtn = super.getGetConnection(this.getManagerUri() + "/" + command);
        return this.prepareConnection(rtn);
    }

    private HttpURLConnection prepareConnection(HttpURLConnection con) {
        con.setRequestProperty("User-Agent", "Catalina-Ant-Task/1.0");
        String input = this.username + ":" + this.password;
        String output = new String(Base64.encode((byte[])input.getBytes()));
        con.setRequestProperty("Authorization", "Basic " + output);
        try {
            con.connect();
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        return con;
    }

    private List<String> getResponse(HttpURLConnection con) {
        return this.getResponse(con, true);
    }

    private List<String> getResponse(HttpURLConnection con, boolean includeStatus) {
        ArrayList<String> rtn = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), MANAGER_CHARSET));
            String line = "";
            boolean isFirst = true;
            while ((line = br.readLine()) != null) {
                if (isFirst && !line.startsWith("OK")) {
                    throw new ConfigurationException(line);
                }
                if (!isFirst || includeStatus) {
                    rtn.add(line.trim());
                }
                isFirst = false;
            }
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        return rtn;
    }

    private String checkContextRoot(String contextRoot) {
        if (contextRoot == null) {
            throw new IllegalArgumentException("contextRoot cannot be null");
        }
        if (!contextRoot.startsWith("/")) {
            return "/" + contextRoot;
        }
        return contextRoot;
    }
}

