/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.webapp;

import com.wavemaker.tools.webapp.schema.ObjectFactory;
import com.wavemaker.tools.webapp.schema.WebAppType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class WebXmlSupport {
    public static final String WEBAPP_SCHEMA_LOCATION = "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd";
    public static final String WEBAPP_PACKAGE = "com.wavemaker.tools.webapp.schema";
    private static JAXBContext jaxbContext;

    public static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)WEBAPP_PACKAGE);
        }
        return jaxbContext;
    }

    public static WebAppType readWebXml(String webxmlFile) throws JAXBException, IOException {
        return WebXmlSupport.readWebXml(new File(webxmlFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebAppType readWebXml(File webxmlFile) throws JAXBException, IOException {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(webxmlFile));
            WebAppType webAppType = WebXmlSupport.readWebXml(bis);
            return webAppType;
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
    }

    public static WebAppType readWebXml(InputStream is) throws JAXBException {
        Unmarshaller unmarshaller = WebXmlSupport.getJAXBContext().createUnmarshaller();
        JAXBElement je = (JAXBElement)unmarshaller.unmarshal(is);
        WebAppType wat = (WebAppType)je.getValue();
        return wat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWebXml(WebAppType webapp, File configFile) throws JAXBException, IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(configFile));
        try {
            WebXmlSupport.writeWebXml(webapp, bos);
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void writeWebXml(WebAppType webapp, OutputStream os) throws JAXBException, IOException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement<WebAppType> je = of.createWebApp(webapp);
        Marshaller marshaller = WebXmlSupport.getJAXBContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.schemaLocation", (Object)WEBAPP_SCHEMA_LOCATION);
        marshaller.marshal(je, os);
    }
}

