/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws;

import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.service.codegen.GenerationConfiguration;
import com.wavemaker.tools.service.codegen.GenerationException;
import com.wavemaker.tools.service.codegen.ServiceGenerator;
import com.wavemaker.tools.ws.WebServiceFactory;
import com.wavemaker.tools.ws.wsdl.WSDL;
import com.wavemaker.tools.ws.wsdl.WSDLException;
import com.wavemaker.tools.ws.wsdl.WSDLManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportWS {
    private File destDir;
    private String packageName;
    private boolean noOverwriteCustomizationFiles;
    private boolean skipInternalCustomization;
    private List<File> jaxbCustomizationFiles = new ArrayList<File>();
    private List<File> jaxwsCustomizationFiles = new ArrayList<File>();
    private String wsdlUri;
    private String serviceId;

    public File getDestdir() {
        return this.destDir;
    }

    public void setDestdir(File destdir) {
        this.destDir = destdir;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public boolean isNoOverwriteCustomizationFiles() {
        return this.noOverwriteCustomizationFiles;
    }

    public void setNoOverwriteCustomizationFiles(boolean noOverwriteCustomizationFiles) {
        this.noOverwriteCustomizationFiles = noOverwriteCustomizationFiles;
    }

    public boolean isSkipInternalCustomization() {
        return this.skipInternalCustomization;
    }

    public void setSkipInternalCustomization(boolean skipInternalCustomization) {
        this.skipInternalCustomization = skipInternalCustomization;
    }

    public List<File> getJaxbCustomizationFiles() {
        return this.jaxbCustomizationFiles;
    }

    public void addJaxbCustomizationFile(File jaxbCustomizationFile) {
        this.jaxbCustomizationFiles.add(jaxbCustomizationFile);
    }

    public void setJaxbCustomizationFiles(List<File> jaxbCustomizationFiles) {
        this.jaxbCustomizationFiles = jaxbCustomizationFiles;
    }

    public List<File> getJaxwsCustomizationFiles() {
        return this.jaxwsCustomizationFiles;
    }

    public void addJaxwsCustomizationFile(File jaxwsCustomizationFile) {
        this.jaxwsCustomizationFiles.add(jaxwsCustomizationFile);
    }

    public void setJaxwsCustomizationFiles(List<File> jaxwsCustomizationFiles) {
        this.jaxwsCustomizationFiles = jaxwsCustomizationFiles;
    }

    public String getWsdlUri() {
        return this.wsdlUri;
    }

    public void setWsdlUri(String wsdlUri) {
        this.wsdlUri = wsdlUri;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void parseArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() == 0) {
                throw new ConfigurationException("Empty argument.");
            }
            if (args[i].charAt(0) == '-') {
                int j = this.parseArguments(args, i);
                if (j == 0) {
                    throw new ConfigurationException("Unrecognized argument " + args[i]);
                }
                i += j - 1;
                continue;
            }
            File wsdlFile = new File(args[i]);
            if (!wsdlFile.exists()) {
                throw new ConfigurationException("This file was not found: " + wsdlFile.toString());
            }
            this.setWsdlUri(wsdlFile.toURI().toString());
        }
    }

    protected int parseArguments(String[] args, int i) {
        if (args[i].equals("-d")) {
            this.destDir = new File(this.requireArgument("-d", args, ++i));
            return 2;
        }
        if (args[i].equals("-p")) {
            this.packageName = this.requireArgument("-p", args, ++i);
            return 2;
        }
        if (args[i].equals("-noOverwriteCustomization")) {
            this.noOverwriteCustomizationFiles = true;
            return 2;
        }
        if (args[i].equals("-skipInternalCustomization")) {
            this.skipInternalCustomization = true;
            return 2;
        }
        if (args[i].equals("-jaxb")) {
            this.addJaxbCustomizationFile(new File(this.requireArgument("-jaxb", args, ++i)));
            return 2;
        }
        if (args[i].equals("-jaxws")) {
            this.addJaxwsCustomizationFile(new File(this.requireArgument("-jaxws", args, ++i)));
            return 2;
        }
        if (this.destDir == null) {
            this.destDir = new File(".");
        }
        return 0;
    }

    public String requireArgument(String optionName, String[] args, int i) {
        if (args[i].startsWith("-")) {
            throw new ConfigurationException("Missing option argument " + args[i]);
        }
        return args[i];
    }

    public WSDL generateServiceClass() {
        WSDL wsdl = null;
        try {
            wsdl = WSDLManager.processWSDL(this.wsdlUri, this.serviceId);
            if (this.packageName != null) {
                wsdl.setPackageName(this.packageName);
            }
        }
        catch (WSDLException e) {
            throw new ConfigurationException((Throwable)((Object)e));
        }
        wsdl.setSkipInternalCustomization(this.skipInternalCustomization);
        wsdl.setJaxbCustomizationFiles(this.jaxbCustomizationFiles);
        wsdl.setJaxwsCustomizationFiles(this.jaxwsCustomizationFiles);
        GenerationConfiguration genConfig = new GenerationConfiguration(wsdl, this.destDir);
        ServiceGenerator generator = new WebServiceFactory().getServiceGenerator(genConfig);
        try {
            generator.generate();
            return wsdl;
        }
        catch (GenerationException e) {
            throw new ConfigurationException((Throwable)((Object)e));
        }
    }

    public void run(String[] args) {
        this.parseArguments(args);
        this.generateServiceClass();
    }

    public static void usage(Class<?> mainClazz) {
        System.out.println("");
        System.out.println("Usage: " + mainClazz.getSimpleName() + " [options] <WSDL URI>");
        System.out.println("where [options] include:");
        System.out.println("-d <directory>            Specify where to place generated output files. Default is the current directory.");
        System.out.println("-p <pkg>                  Specifies the target package. This will override the default package name algorithm based on the namesapce.");
    }
}

