/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws;

import com.ibm.wsdl.InputImpl;
import com.ibm.wsdl.MessageImpl;
import com.ibm.wsdl.OperationImpl;
import com.ibm.wsdl.OutputImpl;
import com.ibm.wsdl.PartImpl;
import com.ibm.wsdl.PortTypeImpl;
import com.ibm.wsdl.TypesImpl;
import com.ibm.wsdl.extensions.schema.SchemaImpl;
import com.sun.tools.ws.processor.util.IndentingWriter;
import com.wavemaker.tools.ws.CodeGenUtils;
import com.wavemaker.tools.ws.RESTInputParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTWsdlGenerator {
    private String serviceName;
    private String namespace;
    private String operationName;
    private String parameterizedUrl;
    private List<String> schemaStrings;
    private List<Element> schemaElements;
    private List<RESTInputParam> inputParts;
    private boolean isStringOutput;
    private QName outputElementType;
    private Set<QName> additionalNamespaces = new HashSet<QName>();
    private String httpMethod;
    private String contentType;

    public RESTWsdlGenerator(String serviceName, String namespace, String operationName, String parameterizedUrl) {
        this.serviceName = serviceName;
        this.namespace = namespace;
        this.operationName = operationName;
        this.parameterizedUrl = parameterizedUrl;
    }

    public void setSchemaStrings(List<String> schemas) {
        this.schemaStrings = schemas;
    }

    public void setSchemaElements(List<Element> schemas) {
        this.schemaElements = schemas;
    }

    public void setInputParts(List<RESTInputParam> inputParts) {
        this.inputParts = inputParts;
    }

    public void setOutputElementType(QName outputElementType) {
        this.outputElementType = outputElementType;
        this.additionalNamespaces.add(outputElementType);
    }

    public void setStringOutput(boolean isStringOutput) {
        this.isStringOutput = isStringOutput;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    private Definition generate() throws SAXException, IOException, ParserConfigurationException, WSDLException {
        Definition definition = WSDLFactory.newInstance().newDefinition();
        definition.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        definition.addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        definition.addNamespace("tns", this.namespace);
        definition.setTargetNamespace(this.namespace);
        this.fixInputParamNames();
        definition.setDocumentationElement(this.generateDocumentation("endpoint=" + this.parameterizedUrl));
        definition.setTypes(this.generateTypes());
        Message inputMessage = this.generateInputMessage();
        Message outputMessage = this.generateOutputMessage();
        for (QName q : this.additionalNamespaces) {
            if (q.getNamespaceURI() == null || q.getNamespaceURI().length() <= 0) continue;
            definition.addNamespace(q.getPrefix(), q.getNamespaceURI());
        }
        definition.addMessage(inputMessage);
        definition.addMessage(outputMessage);
        definition.addPortType(this.generatePortType(inputMessage, outputMessage));
        return definition;
    }

    private void fixInputParamNames() {
        if (this.inputParts != null) {
            for (RESTInputParam param : this.inputParts) {
                int i;
                String newParamName;
                String paramName = param.getName();
                if (paramName.equals(newParamName = CodeGenUtils.toPropertyName(paramName.replace(" ", ""))) || (i = this.parameterizedUrl.indexOf("{" + paramName + "}")) <= -1) continue;
                int j = i + paramName.length() + 2;
                this.parameterizedUrl = this.parameterizedUrl.substring(0, i) + "{" + newParamName + "}" + this.parameterizedUrl.substring(j);
                param.setName(newParamName);
            }
        }
    }

    private Element generateDocumentation(String content) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        Element element = document.createElementNS("http://schemas.xmlsoap.org/wsdl/", "documentation");
        element.setPrefix("wsdl");
        element.setTextContent(content);
        return element;
    }

    private Types generateTypes() throws SAXException, IOException, ParserConfigurationException {
        SchemaImpl schema;
        TypesImpl types = new TypesImpl();
        if (this.schemaStrings != null) {
            for (String schemaString : this.schemaStrings) {
                schema = new SchemaImpl();
                schema.setElementType(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                StringReader reader = new StringReader(schemaString);
                Document doc = db.parse(new InputSource(reader));
                schema.setElement(doc.getDocumentElement());
                types.addExtensibilityElement((ExtensibilityElement)schema);
            }
        }
        if (this.schemaElements != null) {
            for (Element schemaElement : this.schemaElements) {
                schema = new SchemaImpl();
                schema.setElementType(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
                schema.setElement(schemaElement);
                types.addExtensibilityElement((ExtensibilityElement)schema);
            }
        }
        return types;
    }

    private Message generateInputMessage() {
        MessageImpl message = new MessageImpl();
        message.setUndefined(false);
        message.setQName(new QName(this.namespace, "RequestMsg"));
        if (this.inputParts != null) {
            for (RESTInputParam entry : this.inputParts) {
                PartImpl part = new PartImpl();
                part.setName(entry.getName());
                RESTInputParam.InputType type = entry.toType();
                if (type == RESTInputParam.InputType.OTHER) {
                    String outputType = entry.getType();
                    int i = outputType.lastIndexOf(58);
                    QName outType = null;
                    outType = i > -1 ? new QName(outputType.substring(0, i), outputType.substring(i + 1)) : new QName(outputType);
                    part.setElementName(outType);
                    this.additionalNamespaces.add(outType);
                } else {
                    part.setTypeName(RESTWsdlGenerator.constructInputSimpleTypeQName(type));
                }
                message.addPart((Part)part);
            }
        }
        return message;
    }

    private Message generateOutputMessage() {
        MessageImpl message = new MessageImpl();
        message.setUndefined(false);
        message.setQName(new QName(this.namespace, "ResponseMsg"));
        PartImpl part = new PartImpl();
        part.setName("body");
        if (this.isStringOutput) {
            part.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "string"));
            message.addPart((Part)part);
        } else if (this.outputElementType != null) {
            part.setElementName(this.outputElementType);
            message.addPart((Part)part);
        }
        return message;
    }

    private static QName constructInputSimpleTypeQName(RESTInputParam.InputType type) {
        if (type == RESTInputParam.InputType.STRING) {
            return new QName("http://www.w3.org/2001/XMLSchema", "string");
        }
        if (type == RESTInputParam.InputType.INTEGER) {
            return new QName("http://www.w3.org/2001/XMLSchema", "int");
        }
        return null;
    }

    private PortType generatePortType(Message inputMessage, Message outputMessage) throws ParserConfigurationException {
        PortTypeImpl portType = new PortTypeImpl();
        portType.setUndefined(false);
        portType.setQName(new QName(this.serviceName));
        OperationImpl operation = new OperationImpl();
        operation.setUndefined(false);
        operation.setName(this.operationName);
        if (this.httpMethod != null && this.httpMethod.equals("POST")) {
            String content = "POST";
            if (this.contentType != null && this.contentType.length() > 0) {
                content = content + " " + this.contentType;
            }
            operation.setDocumentationElement(this.generateDocumentation(content));
        }
        InputImpl input = new InputImpl();
        input.setMessage(inputMessage);
        operation.setInput((Input)input);
        OutputImpl output = new OutputImpl();
        output.setMessage(outputMessage);
        operation.setOutput((Output)output);
        portType.addOperation((Operation)operation);
        return portType;
    }

    public void write(File wsdlFile) throws WSDLException, IOException, SAXException, ParserConfigurationException, TransformerException {
        WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
        Definition definition = this.generate();
        Document document = writer.getDocument(definition);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("encoding", "UTF-8");
        IndentingWriter p = new IndentingWriter((Writer)new OutputStreamWriter(new FileOutputStream(wsdlFile)));
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult((Writer)p);
        transformer.transform(source, result);
        p.close();
    }
}

