/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.wavemaker.runtime.service.ElementType;
import com.wavemaker.runtime.ws.jaxws.SOAPBindingResolver;
import com.wavemaker.tools.service.codegen.GenerationConfiguration;
import com.wavemaker.tools.service.codegen.GenerationException;
import com.wavemaker.tools.ws.CodeGenUtils;
import com.wavemaker.tools.ws.WebServiceGenerator;
import com.wavemaker.tools.ws.jaxws.JAXWSBuilder;
import com.wavemaker.tools.ws.jaxws.JAXWSPortTypeInfo;
import com.wavemaker.tools.ws.jaxws.JAXWSServiceInfo;
import com.wavemaker.tools.ws.wsdl.SchemaElementType;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPServiceGenerator
extends WebServiceGenerator {
    protected static final String SOAP_SERVICE_VAR_PROP_NAME = "soapServiceVar";
    private JAXWSBuilder jaxwsBuilder;
    private List<JAXWSServiceInfo> serviceInfoList;
    private Map<String, JFieldVar> opSoapServiceMap = new HashMap<String, JFieldVar>();

    public SOAPServiceGenerator(GenerationConfiguration configuration) {
        super(configuration);
        this.jaxwsBuilder = new JAXWSBuilder(this.wsdl, configuration.getOutputDirectory(), configuration.getOutputDirectory());
        this.serviceInfoList = this.jaxwsBuilder.getServiceInfoList();
    }

    @Override
    protected void preGeneration() throws GenerationException {
        super.preGeneration();
        this.jaxwsBuilder.generate(this.jaxbBindingFiles);
    }

    @Override
    protected void postGeneration() throws GenerationException {
        super.postGeneration();
        for (File file : this.getPackageDir().listFiles()) {
            if (!file.getName().endsWith(".class")) continue;
            file.delete();
        }
    }

    @Override
    protected void preGenerateClassBody(JDefinedClass cls) throws GenerationException {
        super.preGenerateClassBody(cls);
        for (JAXWSServiceInfo serviceInfo : this.serviceInfoList) {
            for (JAXWSPortTypeInfo portTypeInfo : serviceInfo.getPortTypeInfoList()) {
                String seiVarName = CodeGenUtils.toVariableName(portTypeInfo.getName()) + "Service";
                JClass jclass = this.codeModel.ref(portTypeInfo.getSeiFQClassName());
                JFieldVar soapServiceVar = cls.field(4, (JType)jclass, seiVarName);
                portTypeInfo.setProperty(SOAP_SERVICE_VAR_PROP_NAME, soapServiceVar);
            }
        }
        this.populateOpSoapServiceMap();
    }

    private void populateOpSoapServiceMap() {
        for (JAXWSServiceInfo serviceInfo : this.serviceInfoList) {
            for (JAXWSPortTypeInfo portTypeInfo : serviceInfo.getPortTypeInfoList()) {
                for (String opName : portTypeInfo.getOperationNames()) {
                    this.opSoapServiceMap.put(opName, portTypeInfo.getProperty(SOAP_SERVICE_VAR_PROP_NAME, JFieldVar.class));
                }
            }
        }
    }

    @Override
    protected void generateDefaultConstructorBody(JBlock body) throws GenerationException {
        for (JAXWSServiceInfo serviceInfo : this.serviceInfoList) {
            String serviceClientVarName = CodeGenUtils.toVariableName(serviceInfo.getServiceClientClassName());
            JClass jclass = this.codeModel.ref(serviceInfo.getServiceClientFQClassName());
            JVar serviceClientVar = body.decl((JType)jclass, serviceClientVarName);
            JTryBlock tryBlock = body._try();
            JBlock tryBody = tryBlock.body();
            JInvocation newClassPathResourceInvoke = JExpr._new((JClass)this.codeModel.ref(ClassPathResource.class)).arg(this.getRelativeWSDLPath()).invoke("getURL");
            JVar wsdlLocationVar = tryBody.decl((JType)this.codeModel.ref(URL.class), "wsdlLocation", (JExpression)newClassPathResourceInvoke);
            JInvocation newServiceClientInvoke = JExpr._new((JClass)jclass).arg((JExpression)wsdlLocationVar);
            newServiceClientInvoke.arg((JExpression)serviceInfo.getProperty("serviceQNameVar", JFieldVar.class));
            tryBody.assign((JAssignmentTarget)serviceClientVar, (JExpression)newServiceClientInvoke);
            JCatchBlock catchBlock = tryBlock._catch(this.codeModel.ref(IOException.class));
            catchBlock.param("e");
            catchBlock.body().assign((JAssignmentTarget)serviceClientVar, (JExpression)JExpr._new((JClass)jclass));
            for (JAXWSPortTypeInfo portTypeInfo : serviceInfo.getPortTypeInfoList()) {
                body.assign((JAssignmentTarget)portTypeInfo.getProperty(SOAP_SERVICE_VAR_PROP_NAME, JFieldVar.class), (JExpression)serviceClientVar.invoke("get" + JAXWSBuilder.getJaxwsGeneratedClassName(portTypeInfo.getPortName())));
            }
        }
    }

    @Override
    protected void generateOperationMethodBody(JMethod method, JBlock body, String operationName, Map<String, JType> inputJTypeMap, JType outputJType, Integer overloadCount) throws GenerationException {
        super.generateOperationMethodBody(method, body, operationName, inputJTypeMap, outputJType, overloadCount);
        JFieldVar soapServiceVar = this.opSoapServiceMap.get(operationName);
        List<SchemaElementType> exceptionTypes = this.wsdl.getExceptionTypes(operationName);
        if (exceptionTypes.size() > 0) {
            method._throws(this.codeModel.ref(Exception.class));
        }
        List<SchemaElementType> inputTypes = this.wsdl.getDefinedInputTypes(operationName);
        ElementType outputType = this.wsdl.getOutputType(operationName);
        JVar outputVar = null;
        if (outputType != null) {
            outputVar = body.decl(outputJType, "response");
        }
        JInvocation bindingInvoke = this.codeModel.ref(SOAPBindingResolver.class).staticInvoke("setBindingProperties");
        bindingInvoke.arg((JExpression)JExpr.cast((JType)this.parseType("javax.xml.ws.BindingProvider"), (JExpression)soapServiceVar));
        bindingInvoke.arg((JExpression)this.bindingPropertiesVar);
        body.add((JStatement)bindingInvoke);
        List<SchemaElementType> soapHeaderInputTypes = this.wsdl.getSOAPHeaderInputTypes(operationName);
        if (soapHeaderInputTypes != null && soapHeaderInputTypes.size() > 0) {
            JInvocation bindingHeadersInvoke = this.codeModel.ref(SOAPBindingResolver.class).staticInvoke("setHeaders");
            bindingHeadersInvoke.arg((JExpression)JExpr.cast((JType)this.parseType("com.sun.xml.ws.developer.WSBindingProvider"), (JExpression)soapServiceVar));
            for (SchemaElementType soapHeaderInputType : soapHeaderInputTypes) {
                bindingHeadersInvoke.arg((JExpression)JExpr.ref((String)soapHeaderInputType.getName()));
            }
            body.add((JStatement)bindingHeadersInvoke);
        }
        JInvocation soapServiceInvocation = soapServiceVar.invoke(JAXWSBuilder.getJavaMethodName(operationName));
        if (inputTypes != null) {
            for (SchemaElementType inputType : inputTypes) {
                soapServiceInvocation.arg((JExpression)JExpr.ref((String)inputType.getName()));
            }
        }
        if (outputVar != null) {
            body.assign((JAssignmentTarget)outputVar, (JExpression)soapServiceInvocation);
            body._return((JExpression)outputVar);
        }
    }
}

