/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.runtime.service.definition.DeprecatedServiceDefinition;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.ServiceDefinitionFactory;
import com.wavemaker.tools.service.ServiceGeneratorFactory;
import com.wavemaker.tools.service.codegen.GenerationConfiguration;
import com.wavemaker.tools.service.codegen.ServiceGenerator;
import com.wavemaker.tools.ws.RESTServiceGenerator;
import com.wavemaker.tools.ws.SOAPServiceGenerator;
import com.wavemaker.tools.ws.wsdl.WSDL;
import com.wavemaker.tools.ws.wsdl.WSDLException;
import com.wavemaker.tools.ws.wsdl.WSDLManager;
import java.io.File;

public class WebServiceFactory
implements ServiceDefinitionFactory,
ServiceGeneratorFactory {
    public DeprecatedServiceDefinition getServiceDefinition(File f) {
        return this.getServiceDefinition(f, null, null);
    }

    public DeprecatedServiceDefinition getServiceDefinition(File f, String serviceId, DesignServiceManager serviceMgr) {
        if (f.getName().endsWith(".wsdl")) {
            try {
                return WSDLManager.processWSDL(f.toURI().toString(), serviceId);
            }
            catch (WSDLException e) {
                throw new WMRuntimeException((Throwable)((Object)e));
            }
        }
        return null;
    }

    public ServiceGenerator getServiceGenerator(GenerationConfiguration cfg) {
        if (cfg.getServiceDefinition() instanceof WSDL) {
            WSDL wsdl = (WSDL)cfg.getServiceDefinition();
            WSDL.WebServiceType serviceType = wsdl.getWebServiceType();
            if (serviceType == WSDL.WebServiceType.SOAP) {
                return new SOAPServiceGenerator(cfg);
            }
            if (serviceType == WSDL.WebServiceType.REST) {
                return new RESTServiceGenerator(cfg);
            }
        }
        return null;
    }
}

