/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.runtime.ws.BindingProperties;
import com.wavemaker.tools.service.codegen.GenerationConfiguration;
import com.wavemaker.tools.service.codegen.GenerationException;
import com.wavemaker.tools.service.codegen.ServiceGenerator;
import com.wavemaker.tools.ws.CodeGenUtils;
import com.wavemaker.tools.ws.JAXBTypeMapper;
import com.wavemaker.tools.ws.XJBBuilder;
import com.wavemaker.tools.ws.wsdl.ServiceInfo;
import com.wavemaker.tools.ws.wsdl.WSDL;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebServiceGenerator
extends ServiceGenerator {
    protected static final String SERVICE_QNAME_VAR_PROP_NAME = "serviceQNameVar";
    protected WSDL wsdl;
    protected List<File> jaxbBindingFiles;
    protected JFieldVar serviceIdVar;
    protected JFieldVar bindingPropertiesVar;

    public WebServiceGenerator(GenerationConfiguration configuration) {
        super(configuration);
        if (!(this.serviceDefinition instanceof WSDL)) {
            throw new WMRuntimeException("Service Generator can be used with WSDL only!");
        }
        this.wsdl = (WSDL)this.serviceDefinition;
    }

    @Override
    protected void preGeneration() throws GenerationException {
        File packageDir = this.getPackageDir();
        if (!packageDir.exists()) {
            packageDir.mkdirs();
        }
        XJBBuilder builder = new XJBBuilder(this.wsdl);
        this.jaxbBindingFiles = builder.generate(this.configuration.getOutputDirectory(), false);
        JAXBTypeMapper typeMapper = null;
        try {
            typeMapper = new JAXBTypeMapper(this.wsdl, this.jaxbBindingFiles);
        }
        catch (GenerationException e) {
            this.jaxbBindingFiles = builder.generate(this.configuration.getOutputDirectory(), true);
            try {
                typeMapper = new JAXBTypeMapper(this.wsdl, this.jaxbBindingFiles);
            }
            catch (GenerationException ex) {
                this.removeGlobalBindingFile();
                typeMapper = new JAXBTypeMapper(this.wsdl, this.jaxbBindingFiles);
            }
        }
        this.wsdl.setTypeMapper(typeMapper);
    }

    private void removeGlobalBindingFile() {
        int index = 0;
        for (File jaxbBindingFile : this.jaxbBindingFiles) {
            if (jaxbBindingFile.getName().equals("global-binding.xjb")) {
                this.jaxbBindingFiles.remove(index);
                break;
            }
            ++index;
        }
    }

    @Override
    protected void postGeneration() throws GenerationException {
    }

    @Override
    protected void preGenerateClassBody(JDefinedClass cls) throws GenerationException {
        this.serviceIdVar = cls.field(1, (JType)this.codeModel.ref(String.class), "serviceId", JExpr.lit((String)this.wsdl.getServiceId()));
        for (ServiceInfo serviceInfo : this.wsdl.getServiceInfoList()) {
            String sname = serviceInfo.getName();
            JInvocation invocation = JExpr._new((JClass)this.codeModel.ref(QName.class));
            invocation.arg(JExpr.lit((String)serviceInfo.getQName().getNamespaceURI()));
            invocation.arg(JExpr.lit((String)sname));
            JFieldVar serviceQNameVar = cls.field(4, (JType)this.codeModel.ref(QName.class), CodeGenUtils.toVariableName(sname) + "QName", (JExpression)invocation);
            serviceInfo.setProperty(SERVICE_QNAME_VAR_PROP_NAME, serviceQNameVar);
        }
        this.bindingPropertiesVar = cls.field(4, (JType)this.codeModel.ref(BindingProperties.class), "bindingProperties");
    }

    @Override
    protected void postGenerateClassBody(JDefinedClass cls) throws GenerationException {
        JMethod getBindingPropsMethod = cls.method(1, (JType)this.codeModel.ref(BindingProperties.class), "getBindingProperties");
        JBlock getBlock = getBindingPropsMethod.body();
        getBlock._return((JExpression)this.bindingPropertiesVar);
        JMethod setBindingPropsMethod = cls.method(1, (JType)this.codeModel.VOID, "setBindingProperties");
        JVar var = setBindingPropsMethod.param((JType)this.codeModel.ref(BindingProperties.class), "bindingProperties");
        JBlock setBlock = setBindingPropsMethod.body();
        setBlock.assign((JAssignmentTarget)JExpr._this().ref((JVar)this.bindingPropertiesVar), (JExpression)var);
    }

    @Override
    protected void generateOperationMethodBody(JMethod method, JBlock body, String operationName, Map<String, JType> inputJTypeMap, JType outputJType, Integer overloadCount) throws GenerationException {
    }

    protected JType parseType(String type) throws GenerationException {
        try {
            return this.codeModel.parseType(type);
        }
        catch (ClassNotFoundException e) {
            throw new GenerationException(e);
        }
    }

    protected File getPackageDir() {
        return CodeGenUtils.getPackageDir(this.configuration.getOutputDirectory(), this.wsdl.getPackageName());
    }

    protected String getRelativeWSDLPath() {
        return this.wsdl.getPackageName().replace('.', '/') + "/" + new File(this.wsdl.getURI()).getName();
    }
}

