/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws;

import com.wavemaker.common.util.CastUtils;
import com.wavemaker.common.util.IOUtils;
import com.wavemaker.runtime.server.DownloadResponse;
import com.wavemaker.runtime.ws.BindingProperties;
import com.wavemaker.runtime.ws.HTTPBindingSupport;
import com.wavemaker.runtime.ws.WebServiceException;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.project.ProjectManager;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.ws.CodeGenUtils;
import com.wavemaker.tools.ws.FeedServiceDefinition;
import com.wavemaker.tools.ws.ImportWS;
import com.wavemaker.tools.ws.RESTInputParam;
import com.wavemaker.tools.ws.RESTWsdlGenerator;
import com.wavemaker.tools.ws.RESTWsdlSettings;
import com.wavemaker.tools.ws.WebServiceSpringSupport;
import com.wavemaker.tools.ws.XsdGenerator;
import com.wavemaker.tools.ws.wadl.Wadl2Wsdl;
import com.wavemaker.tools.ws.wsdl.WSDL;
import com.wavemaker.tools.ws.wsdl.WSDLException;
import com.wavemaker.tools.ws.wsdl.WSDLManager;
import com.wavemaker.tools.ws.wsdl.WSDLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceToolsManager {
    static final Logger logger = Logger.getLogger(WebServiceToolsManager.class);
    private static final String SERVICE_ID_ALREADY_EXISTS = "$already_exists$";
    private static final String XML_SCHEMA_TEXT_SEPERATOR = "\n--- schema end ---\n";
    private final ProjectManager projectMgr;
    private final DesignServiceManager designServiceMgr;

    public WebServiceToolsManager(ProjectManager projectMgr, DesignServiceManager designServiceMgr) {
        this.projectMgr = projectMgr;
        this.designServiceMgr = designServiceMgr;
    }

    public String importWSDL(String wsdlPath, String serviceId, boolean overwrite) throws WSDLException, IOException, JAXBException {
        File packageDir;
        logger.info((Object)("Importing " + wsdlPath));
        boolean isLocal = true;
        if (wsdlPath.startsWith("http")) {
            isLocal = false;
        }
        WSDL origWsdl = null;
        File origWsdlFile = null;
        if (isLocal) {
            origWsdlFile = new File(wsdlPath);
            if (origWsdlFile.isDirectory()) {
                File[] listFiles;
                String srvId = null;
                for (File f : listFiles = origWsdlFile.listFiles()) {
                    if (!f.getName().toLowerCase().endsWith(".wsdl")) continue;
                    srvId = this.importWSDL(f.getCanonicalPath(), null, true);
                }
                return srvId;
            }
            origWsdl = WSDLManager.processWSDL(origWsdlFile.toURI().toString(), serviceId);
        } else {
            origWsdl = WSDLManager.processWSDL(wsdlPath, serviceId);
        }
        if (!overwrite && this.designServiceMgr.serviceExists(origWsdl.getServiceId())) {
            return SERVICE_ID_ALREADY_EXISTS + origWsdl.getServiceId();
        }
        File runtimeDir = this.designServiceMgr.getServiceRuntimeDirectory(origWsdl.getServiceId());
        if (!runtimeDir.exists()) {
            runtimeDir.mkdirs();
        }
        if (!(packageDir = CodeGenUtils.getPackageDir(runtimeDir, origWsdl.getPackageName())).exists()) {
            packageDir.mkdirs();
        }
        String wsdlUri = null;
        if (isLocal) {
            Map<String, Element> schemas;
            File wsdlFile = new File(packageDir, origWsdlFile.getName());
            wsdlUri = wsdlFile.toURI().toString();
            if (!wsdlFile.getCanonicalFile().equals(origWsdlFile.getCanonicalFile())) {
                IOUtils.copy((File)origWsdlFile, (File)wsdlFile);
            }
            if ((schemas = origWsdl.getSchemas()) != null) {
                for (String systemId : schemas.keySet()) {
                    File xsdFile = WebServiceToolsManager.getLocalXsdFileFromSystemId(systemId);
                    if (xsdFile == null || !xsdFile.exists()) continue;
                    IOUtils.copy((File)xsdFile, (File)new File(packageDir, xsdFile.getName()));
                }
            }
        } else {
            wsdlUri = wsdlPath;
            WSDLUtils.writeDefinition(origWsdl.getDefinition(), new File(packageDir, origWsdl.getServiceId() + ".wsdl"));
        }
        ImportWS importWS = new ImportWS();
        importWS.setWsdlUri(wsdlUri);
        importWS.setServiceId(serviceId);
        importWS.setDestdir(runtimeDir);
        WSDL wsdl = importWS.generateServiceClass();
        this.designServiceMgr.defineService(wsdl);
        String srvId = wsdl.getServiceId();
        logger.info((Object)("Import successful: " + srvId));
        return srvId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importWADL(String wadlPath, String serviceId, boolean overwrite) throws WSDLException, IOException, JAXBException {
        File tempDir = IOUtils.createTempDirectory();
        try {
            File wsdlFile = WebServiceToolsManager.generateWsdlFromWadl(wadlPath, tempDir);
            String string = this.importWSDL(wsdlFile.getCanonicalPath(), serviceId, overwrite);
            return string;
        }
        finally {
            IOUtils.deleteRecursive((File)tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importUploadedFile(MultipartFile file, String serviceId, String overwrite) throws IOException, WSDLException, JAXBException {
        File tempDir = IOUtils.createTempDirectory();
        String fileName = file.getOriginalFilename();
        boolean isWSDL = true;
        if (fileName != null && fileName.length() > 0) {
            File f = new File(fileName);
            if ((fileName = f.getName()).toLowerCase().endsWith(".wadl")) {
                isWSDL = false;
            }
        } else {
            fileName = "temp.wsdl";
        }
        try {
            File wsdlFile = new File(tempDir, fileName);
            file.transferTo(wsdlFile);
            if (isWSDL) {
                String string = this.importWSDL(wsdlFile.getCanonicalPath(), serviceId, Boolean.valueOf(overwrite));
                return string;
            }
            String string = this.importWADL(wsdlFile.getCanonicalPath(), serviceId, Boolean.valueOf(overwrite));
            return string;
        }
        finally {
            IOUtils.deleteRecursive((File)tempDir);
        }
    }

    public String registerFeedService() throws JAXBException, IOException {
        FeedServiceDefinition definition = new FeedServiceDefinition();
        String serviceId = definition.getServiceId();
        this.designServiceMgr.validateServiceId(serviceId);
        this.designServiceMgr.defineService(definition);
        return serviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildRestService(String serviceName, String operationName, List<RESTInputParam> inputs, String parameterizedUrl, String method, String contentType, String outputType, String xmlSchemaText, String xmlSchemaPath, boolean overwrite) throws IOException, javax.wsdl.WSDLException, SAXException, ParserConfigurationException, WSDLException, JAXBException, TransformerException {
        RESTWsdlGenerator restWsdlGenerator = new RESTWsdlGenerator(serviceName, WebServiceToolsManager.constructNamespace(parameterizedUrl), operationName, parameterizedUrl);
        restWsdlGenerator.setHttpMethod(method);
        restWsdlGenerator.setContentType(contentType);
        restWsdlGenerator.setInputParts(inputs);
        if (outputType != null) {
            if (outputType.equals("string")) {
                restWsdlGenerator.setStringOutput(true);
            } else {
                int i = outputType.lastIndexOf(58);
                QName outType = null;
                outType = i > -1 ? new QName(outputType.substring(0, i), outputType.substring(i + 1)) : new QName(outputType);
                restWsdlGenerator.setOutputElementType(outType);
            }
        }
        if (xmlSchemaText != null && xmlSchemaText.length() > 0) {
            List<String> schemaStrings = WebServiceToolsManager.seperateXmlSchemaText(xmlSchemaText);
            restWsdlGenerator.setSchemaStrings(schemaStrings);
        }
        if (xmlSchemaPath != null && xmlSchemaPath.length() > 0) {
            XmlSchema xmlSchema = WebServiceToolsManager.constructXmlSchema(xmlSchemaPath);
            ArrayList<Element> schemaElements = new ArrayList<Element>();
            for (Document schemaDocument : xmlSchema.getAllSchemas()) {
                schemaElements.add(schemaDocument.getDocumentElement());
            }
            restWsdlGenerator.setSchemaElements(schemaElements);
        }
        File tempDir = IOUtils.createTempDirectory();
        try {
            File wsdlFile = new File(tempDir, serviceName + ".wsdl");
            restWsdlGenerator.write(wsdlFile);
            String string = this.importWSDL(wsdlFile.getCanonicalPath(), null, overwrite);
            return string;
        }
        finally {
            IOUtils.deleteRecursive((File)tempDir);
        }
    }

    public List<String> getSchemaElementTypes(String xmlSchemaPath, String xmlSchemaText) throws IOException, ParserConfigurationException, SAXException {
        if (xmlSchemaPath != null && xmlSchemaPath.length() > 0) {
            XmlSchema xmlSchema = WebServiceToolsManager.constructXmlSchema(xmlSchemaPath);
            return WebServiceToolsManager.getAllSchemaElements(xmlSchema);
        }
        if (xmlSchemaText != null && xmlSchemaText.length() > 0) {
            List<String> schemaStrings = WebServiceToolsManager.seperateXmlSchemaText(xmlSchemaText);
            ArrayList<String> allSchemaElements = new ArrayList<String>();
            for (String schemaString : schemaStrings) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                StringReader reader = new StringReader(schemaString);
                Document doc = db.parse(new InputSource(reader));
                XmlSchemaCollection xmlSchemaColl = new XmlSchemaCollection();
                XmlSchema xmlSchema = xmlSchemaColl.read(doc, null);
                allSchemaElements.addAll(WebServiceToolsManager.getAllSchemaElements(xmlSchema));
            }
            return allSchemaElements;
        }
        return Collections.emptyList();
    }

    public String convertXmlToSchema(String xml) throws IOException, XmlException {
        List<String> schemaStrings = XsdGenerator.generate(xml);
        if (schemaStrings.size() == 1) {
            return schemaStrings.get(0);
        }
        if (schemaStrings.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (String schemaString : schemaStrings) {
                sb.append(schemaString);
                sb.append(XML_SCHEMA_TEXT_SEPERATOR);
            }
            return sb.toString();
        }
        return null;
    }

    public List<String> invokeRestCall(String endpointAddress) {
        QName serviceQName = new QName(WebServiceToolsManager.constructNamespace(endpointAddress), "TestService");
        String responseString = null;
        String errorMessage = null;
        try {
            responseString = HTTPBindingSupport.getResponseString(serviceQName, serviceQName, endpointAddress, HTTPBindingSupport.HTTPRequestMethod.GET, null, null);
            try {
                XmlObject.Factory.parse((String)responseString);
            }
            catch (XmlException e) {
                errorMessage = "The response is not in a valid XML format.";
            }
        }
        catch (Throwable e) {
            errorMessage = e.toString();
        }
        ArrayList<String> rtn = new ArrayList<String>();
        rtn.add(responseString);
        if (errorMessage != null) {
            rtn.add(errorMessage);
        }
        return rtn;
    }

    public RESTWsdlSettings generateRESTWsdlSettings(String endpointAddress) throws WebServiceException, IOException, XmlException {
        RESTWsdlSettings settings = new RESTWsdlSettings();
        URL serviceUrl = new URL(endpointAddress);
        serviceUrl.getHost();
        String serviceName = WebServiceToolsManager.constructServiceName(serviceUrl);
        QName serviceQName = new QName(WebServiceToolsManager.constructNamespace(endpointAddress), serviceName);
        String responseString = HTTPBindingSupport.getResponseString(serviceQName, serviceQName, endpointAddress, HTTPBindingSupport.HTTPRequestMethod.GET, null, null);
        String outputType = null;
        String xmlSchemaText = null;
        try {
            xmlSchemaText = this.convertXmlToSchema(responseString);
            outputType = WebServiceToolsManager.getXmlRootElementType(responseString);
        }
        catch (Exception e) {
            outputType = "string";
        }
        String query = serviceUrl.getQuery();
        ArrayList<RESTInputParam> inputs = new ArrayList<RESTInputParam>();
        String parameterizedUrl = null;
        if (query != null) {
            String[] qparts;
            StringBuilder sb = new StringBuilder();
            sb.append(WebServiceToolsManager.getUrlOmitQuery(endpointAddress));
            sb.append("?");
            for (String qpart : qparts = query.split("&")) {
                int i = qpart.indexOf(61);
                if (i > -1) {
                    String name = qpart.substring(0, i);
                    sb.append(name);
                    sb.append("={");
                    sb.append(name);
                    sb.append("}&");
                    inputs.add(new RESTInputParam(name, "string"));
                    continue;
                }
                sb.append(qpart);
                sb.append("&");
            }
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '&') {
                sb.deleteCharAt(sb.length() - 1);
            }
            parameterizedUrl = sb.toString();
        } else {
            parameterizedUrl = endpointAddress;
        }
        settings.setServiceName(serviceName);
        settings.setOperationName("invoke");
        settings.setInputs(inputs);
        settings.setParameterizedUrl(parameterizedUrl);
        settings.setOutputType(outputType);
        settings.setXmlSchemaText(xmlSchemaText);
        return settings;
    }

    public String getWSDL(String serviceId) throws IOException {
        File file = this.getWSDLFile(serviceId);
        if (file != null) {
            if (file.length() < 1000000L) {
                return FileUtils.readFileToString((File)file, (String)"UTF-8");
            }
            return "services/webService.download?method=downloadWSDL&serviceId=" + serviceId;
        }
        return null;
    }

    public File getWSDLFile(String serviceId) {
        Service service = this.designServiceMgr.getService(serviceId);
        if (service != null) {
            File[] files;
            File serviceRuntimeDirectory = this.designServiceMgr.getServiceRuntimeDirectory(serviceId);
            String clazz = service.getClazz();
            String packagePath = clazz.replace('.', '/');
            File packageDir = new File(serviceRuntimeDirectory, packagePath = packagePath.substring(0, packagePath.lastIndexOf(47)));
            if (packageDir.exists() && (files = packageDir.listFiles()) != null) {
                for (File file : files) {
                    if (!file.getName().toLowerCase().endsWith(".wsdl")) continue;
                    return file;
                }
            }
        }
        return null;
    }

    public DownloadResponse downloadWSDL(String serviceId) throws IOException {
        DownloadResponse response = new DownloadResponse();
        File wsdlFile = this.getWSDLFile(serviceId);
        FileInputStream fis = new FileInputStream(wsdlFile);
        response.setContents(fis);
        response.setFileName(wsdlFile.getName());
        return response;
    }

    private static File getLocalXsdFileFromSystemId(String systemId) {
        if (!systemId.endsWith(".xsd")) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(systemId);
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (url.getProtocol().equals("file") && url.getFile() != null) {
            return new File(url.getFile());
        }
        return null;
    }

    private static File generateWsdlFromWadl(String wadlPath, File outDir) {
        String wadlUri = null;
        if (wadlPath.startsWith("http")) {
            wadlUri = wadlPath;
        } else {
            File file = new File(wadlPath);
            wadlUri = file.toURI().toString();
        }
        try {
            Wadl2Wsdl wadl2Wsdl = new Wadl2Wsdl(new URI(wadlUri));
            return wadl2Wsdl.generateWSDL(outDir);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private static List<String> seperateXmlSchemaText(String schemaText) {
        if (schemaText == null) {
            return Collections.emptyList();
        }
        String[] schemaStrings = schemaText.split(XML_SCHEMA_TEXT_SEPERATOR);
        ArrayList<String> schemas = new ArrayList<String>();
        for (String schemaString : schemaStrings) {
            if (schemaString.length() <= 0) continue;
            schemas.add(schemaString);
        }
        return schemas;
    }

    private static String getUrlOmitQuery(String url) {
        int index = url.indexOf(63);
        String namespace = null;
        namespace = index > -1 ? url.substring(0, index) : url;
        return namespace;
    }

    private static String constructNamespace(String url) {
        String namespace = WebServiceToolsManager.getUrlOmitQuery(url);
        namespace = namespace.replace('{', 'x');
        namespace = namespace.replace('}', 'x');
        return namespace;
    }

    private static String constructServiceName(URL url) {
        String host = url.getHost();
        int i = host.indexOf(46);
        if (i > -1) {
            String s1 = host.substring(i + 1, host.length());
            int j = s1.indexOf(46);
            String s2 = null;
            s2 = j > -1 ? s1.substring(0, j) : host.substring(0, i);
            return s2;
        }
        return host;
    }

    private static XmlSchema constructXmlSchema(String schemaPath) throws IOException {
        URL url = null;
        if (schemaPath.startsWith("http")) {
            url = new URL(schemaPath);
        } else {
            File f = new File(schemaPath);
            url = f.toURL();
        }
        InputSource input = new InputSource(url.openStream());
        XmlSchemaCollection xmlSchemaColl = new XmlSchemaCollection();
        XmlSchema xmlSchema = xmlSchemaColl.read(input, null);
        return xmlSchema;
    }

    public static String getXmlRootElementType(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        StringReader reader = new StringReader(xml);
        Document doc = db.parse(new InputSource(reader));
        Node node = doc.getFirstChild();
        if (node != null) {
            String namespaceURI = node.getNamespaceURI();
            String localName = node.getLocalName();
            if (localName != null) {
                return namespaceURI == null ? localName : namespaceURI + ":" + localName;
            }
        }
        return null;
    }

    private static List<String> getAllSchemaElements(XmlSchema xmlSchema) {
        ArrayList<String> types = new ArrayList<String>();
        XmlSchemaObjectTable elements = xmlSchema.getElements();
        Iterator iter = CastUtils.cast((Iterator)elements.getNames());
        while (iter.hasNext()) {
            QName next = (QName)iter.next();
            String namespaceURI = next.getNamespaceURI();
            types.add((namespaceURI == null || namespaceURI.length() == 0 ? "" : namespaceURI + ":") + next.getLocalPart());
        }
        return types;
    }

    public BindingProperties getBindingProperties(String serviceId) throws JAXBException, IOException {
        return WebServiceSpringSupport.getBindingProperties(this.projectMgr.getCurrentProject(), this.designServiceMgr, serviceId);
    }

    public void setBindingProperties(String serviceId, BindingProperties bindingProperties) throws JAXBException, IOException {
        WebServiceSpringSupport.setBindingProperties(this.projectMgr.getCurrentProject(), this.designServiceMgr, serviceId, bindingProperties);
    }
}

