/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws;

import com.wavemaker.common.util.IOUtils;
import com.wavemaker.common.util.XMLUtils;
import com.wavemaker.common.util.XMLWriter;
import com.wavemaker.tools.service.codegen.GenerationException;
import com.wavemaker.tools.ws.CodeGenUtils;
import com.wavemaker.tools.ws.wsdl.WSDL;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJBBuilder {
    private static final String[] XML_DATE_TYPES = new String[]{"xs:date", "xs:dateTime", "xs:time"};
    private static final String SOAPENC_FILE_CLASSPATH = "com/wavemaker/tools/ws/soapenc.xsd";
    private WSDL wsdl;

    public XJBBuilder(WSDL wsdl) {
        this.wsdl = wsdl;
    }

    public List<File> generate(File baseDir, boolean useDifferentPackage) throws GenerationException {
        ArrayList<File> jaxbBindingFiles = new ArrayList<File>();
        jaxbBindingFiles.add(this.generateGlobalBindingFile(baseDir));
        jaxbBindingFiles.addAll(this.generateSchemaBindingFiles(baseDir, useDifferentPackage));
        if (this.wsdl.getImportedNoRefSchemas().contains("http://schemas.xmlsoap.org/soap/encoding/")) {
            jaxbBindingFiles.add(this.getSoapEncSchemaFile(baseDir));
        }
        return jaxbBindingFiles;
    }

    private List<File> generateSchemaBindingFiles(File baseDir, boolean useDifferentPackage) {
        ArrayList<File> jaxbBindingFiles = new ArrayList<File>();
        int schemaCount = 1;
        for (String schemaLocation : this.wsdl.getSchemas().keySet()) {
            jaxbBindingFiles.add(this.generateSchemaBindingFile(schemaLocation, schemaCount++, baseDir, useDifferentPackage));
        }
        return jaxbBindingFiles;
    }

    private File generateSchemaBindingFile(String schemaLocation, int schemaCount, File baseDir, boolean useDifferentPackage) {
        File bindingFile = new File(CodeGenUtils.getPackageDir(baseDir, this.wsdl.getPackageName()), this.wsdl.getServiceId() + schemaCount + ".xjb");
        if (this.wsdl.isNoOverwriteCustomizationFiles() && bindingFile.exists()) {
            return bindingFile;
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(bindingFile));
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
        XMLWriter xw = XMLUtils.newXMLWriter((PrintWriter)pw);
        xw.addVersion();
        xw.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        xw.addNamespace("jaxb", "http://java.sun.com/xml/ns/jaxb");
        xw.setCurrentShortNS("jaxb");
        xw.addElement("bindings");
        xw.addAttribute("version", "2.0");
        xw.addElement("bindings");
        xw.addAttribute("schemaLocation", schemaLocation);
        xw.addAttribute("node", "//xsd:schema[1]");
        xw.addElement("schemaBindings");
        xw.addElement("package");
        String pkgName = this.wsdl.getPackageName();
        if (useDifferentPackage && schemaCount > 1) {
            pkgName = pkgName + "." + "schema" + schemaCount;
        }
        xw.addAttribute("name", pkgName);
        xw.closeElement();
        xw.addElement("nameXmlTransform");
        xw.addElement("typeName");
        xw.addAttribute("suffix", "Type");
        xw.finish();
        pw.close();
        return bindingFile;
    }

    private File generateGlobalBindingFile(File baseDir) {
        File globalBindingFile = new File(CodeGenUtils.getPackageDir(baseDir, this.wsdl.getPackageName()), "global-binding.xjb");
        if (this.wsdl.isNoOverwriteCustomizationFiles() && globalBindingFile.exists()) {
            return globalBindingFile;
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(globalBindingFile));
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
        XMLWriter xw = XMLUtils.newXMLWriter((PrintWriter)pw);
        xw.addVersion();
        xw.addNamespace("jaxb", "http://java.sun.com/xml/ns/jaxb");
        xw.addNamespace("xjc", "http://java.sun.com/xml/ns/jaxb/xjc");
        xw.addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        xw.setCurrentShortNS("jaxb");
        xw.addElement("bindings");
        xw.addAttribute("jaxb:version", "2.0");
        xw.addAttribute("jaxb:extensionBindingPrefixes", "xjc");
        xw.addElement("globalBindings");
        xw.addAttribute("generateElementProperty", "false");
        xw.setCurrentShortNS("xjc");
        xw.addElement("simple");
        xw.closeElement();
        xw.setCurrentShortNS("xjc");
        for (String xmlType : XML_DATE_TYPES) {
            xw.addElement("javaType");
            xw.addAttribute("name", "java.util.Date");
            xw.addAttribute("xmlType", xmlType);
            xw.addAttribute("adapter", "com.wavemaker.runtime.ws.jaxb.DateXmlAdapter");
            xw.closeElement();
        }
        xw.finish();
        pw.close();
        return globalBindingFile;
    }

    private File getSoapEncSchemaFile(File baseDir) throws GenerationException {
        try {
            File schemaFile = new File(CodeGenUtils.getPackageDir(baseDir, this.wsdl.getPackageName()), "soapenc.xsd");
            InputStream is = new ClassPathResource(SOAPENC_FILE_CLASSPATH).getInputStream();
            FileOutputStream os = new FileOutputStream(schemaFile);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            return schemaFile;
        }
        catch (IOException e) {
            throw new GenerationException(e);
        }
    }
}

