/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws;

import com.sun.codemodel.JCodeModel;
import com.sun.tools.ws.processor.modeler.wsdl.ClassNameAllocatorImpl;
import com.sun.tools.ws.processor.util.ClassNameCollector;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.api.ClassNameAllocator;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import com.wavemaker.tools.service.codegen.GenerationException;
import com.wavemaker.tools.ws.jaxb.boolean_getter.PluginImpl;
import com.wavemaker.tools.ws.jaxws.SimpleClassNameCollector;
import com.wavemaker.tools.ws.wsdl.WSDL;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJCCompiler {
    private static Log log = LogFactory.getLog(XJCCompiler.class);

    public static void generate(S2JJAXBModel model, File outputDir) throws GenerationException {
        JAXBCompilerErrorListener listener = new JAXBCompilerErrorListener();
        JCodeModel generateCode = model.generateCode(null, (ErrorListener)listener);
        if (listener.hasError) {
            throw listener.getException();
        }
        try {
            generateCode.build(outputDir, outputDir, null);
        }
        catch (IOException e) {
            throw new GenerationException(e);
        }
        if (listener.hasError) {
            throw listener.getException();
        }
    }

    public static S2JJAXBModel createSchemaModel(Map<String, Element> schemas, List<File> bindingFiles, String packageName, Set<String> auxiliaryClasses, WSDL.WebServiceType type) throws GenerationException {
        if (schemas == null || schemas.isEmpty()) {
            return null;
        }
        SchemaCompiler sc = XJC.createSchemaCompiler();
        if (type == WSDL.WebServiceType.SOAP) {
            ClassNameAllocatorImpl allocator = new ClassNameAllocatorImpl((ClassNameCollector)new SimpleClassNameCollector(auxiliaryClasses));
            sc.setClassNameAllocator((ClassNameAllocator)allocator);
        }
        JAXBCompilerErrorListener listener = new JAXBCompilerErrorListener();
        sc.setErrorListener((ErrorListener)listener);
        try {
            Field ncc = sc.getClass().getDeclaredField("NO_CORRECTNESS_CHECK");
            ncc.setAccessible(true);
            ncc.set(sc, true);
        }
        catch (Exception e) {
            throw new GenerationException(e);
        }
        if (packageName != null) {
            sc.setDefaultPackageName(packageName);
        }
        for (Map.Entry<String, Element> entry : schemas.entrySet()) {
            Element schema = entry.getValue();
            Element updatedSchema = XJCCompiler.removeImportElement(schema);
            sc.parseSchema(entry.getKey(), updatedSchema);
        }
        if (bindingFiles != null) {
            for (File file : bindingFiles) {
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(file));
                    inputSource.setSystemId("file:" + file.getAbsolutePath());
                    sc.parseSchema(inputSource);
                }
                catch (FileNotFoundException e) {
                    throw new GenerationException(e);
                }
            }
        }
        Options options = sc.getOptions();
        options.packageLevelAnnotations = false;
        options.activePlugins.add(new com.sun.tools.xjc.addon.collection_setter_injector.PluginImpl());
        options.activePlugins.add(new PluginImpl());
        S2JJAXBModel model = sc.bind();
        if (listener.hasError) {
            throw listener.getException();
        }
        return model;
    }

    private static Element removeImportElement(Element element) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        if (nodeList.getLength() == 0) {
            return element;
        }
        Element elementClone = (Element)element.cloneNode(true);
        nodeList = elementClone.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        ArrayList<Node> ns = new ArrayList<Node>();
        for (int tmp = 0; tmp < nodeList.getLength(); ++tmp) {
            Node importNode = nodeList.item(tmp);
            ns.add(importNode);
        }
        for (Node item : ns) {
            Node schemaNode = item.getParentNode();
            schemaNode.removeChild(item);
        }
        return elementClone;
    }

    static class JAXBCompilerErrorListener
    implements ErrorListener {
        private boolean hasError;
        private List<SAXParseException> saxParseExceptions = new ArrayList<SAXParseException>();

        JAXBCompilerErrorListener() {
        }

        public boolean hasError() {
            return this.hasError;
        }

        public GenerationException getException() {
            if (this.saxParseExceptions == null || this.saxParseExceptions.isEmpty()) {
                return null;
            }
            if (this.saxParseExceptions.size() == 1) {
                return new GenerationException(this.getErrorMessage(this.saxParseExceptions.get(0)), this.saxParseExceptions.get(0));
            }
            StringBuilder sb = new StringBuilder();
            for (SAXParseException saxEx : this.saxParseExceptions) {
                sb.append(this.getErrorMessage(saxEx));
                sb.append('\n');
            }
            return new GenerationException(sb.toString());
        }

        public void resetError() {
            this.hasError = false;
            this.saxParseExceptions.clear();
        }

        public void error(SAXParseException exception) {
            this.hasError = true;
            this.saxParseExceptions.add(exception);
            log.warn((Object)this.getErrorMessage(exception), (Throwable)exception);
        }

        public void fatalError(SAXParseException exception) {
            this.error(exception);
        }

        public void info(SAXParseException exception) {
            log.info((Object)this.getErrorMessage(exception), (Throwable)exception);
        }

        public void warning(SAXParseException exception) {
            this.info(exception);
        }

        private String getErrorMessage(SAXParseException exception) {
            return exception.getLocalizedMessage();
        }
    }
}

