/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws;

import com.wavemaker.common.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.inst2xsd.Inst2Xsd;
import org.apache.xmlbeans.impl.inst2xsd.Inst2XsdOptions;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsdGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> generate(String xml) throws IOException, XmlException {
        File tempDir = IOUtils.createTempDirectory();
        try {
            File xmlFile = new File(tempDir, "instance.xml");
            FileUtils.writeStringToFile((File)xmlFile, (String)xml, (String)"UTF-8");
            List<File> schemaFiles = XsdGenerator.generate(xmlFile, tempDir);
            ArrayList<String> schemas = new ArrayList<String>();
            for (File schemaFile : schemaFiles) {
                schemas.add(FileUtils.readFileToString((File)schemaFile, (String)"UTF-8"));
            }
            ArrayList<String> arrayList = schemas;
            return arrayList;
        }
        finally {
            IOUtils.deleteRecursive((File)tempDir);
        }
    }

    public static List<File> generate(File xmlFile, File outputDir) throws IOException, XmlException {
        Inst2XsdOptions inst2XsdOptions = new Inst2XsdOptions();
        inst2XsdOptions.setSimpleContentTypes(2);
        inst2XsdOptions.setUseEnumerations(1);
        XmlObject[] xmlInstances = new XmlObject[]{XmlObject.Factory.parse((File)xmlFile)};
        SchemaDocument[] schemaDocs = Inst2Xsd.inst2xsd((XmlObject[])xmlInstances, (Inst2XsdOptions)inst2XsdOptions);
        ArrayList<File> schemaFiles = new ArrayList<File>();
        for (int i = 0; i < schemaDocs.length; ++i) {
            SchemaDocument schema = schemaDocs[i];
            File schemaFile = new File(outputDir, "schema" + i + ".xsd");
            schema.save(schemaFile, new XmlOptions().setSavePrettyPrint());
            schemaFiles.add(schemaFile);
        }
        return schemaFiles;
    }
}

