/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws.jaxws;

import com.sun.tools.ws.ant.WsImport2;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.bind.api.impl.NameConverter;
import com.wavemaker.common.util.XMLUtils;
import com.wavemaker.common.util.XMLWriter;
import com.wavemaker.tools.service.codegen.GenerationException;
import com.wavemaker.tools.ws.CodeGenUtils;
import com.wavemaker.tools.ws.jaxws.JAXWSPortTypeInfo;
import com.wavemaker.tools.ws.jaxws.JAXWSServiceInfo;
import com.wavemaker.tools.ws.wsdl.PortTypeInfo;
import com.wavemaker.tools.ws.wsdl.ServiceInfo;
import com.wavemaker.tools.ws.wsdl.WSDL;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSBuilder {
    private static final String SEI_CLASS_NAME_SUFFIX = "Soap";
    private WSDL wsdl;
    private File outputSrcDir;
    private File outputClassDir;
    private List<JAXWSServiceInfo> serviceInfoList = new ArrayList<JAXWSServiceInfo>();

    public JAXWSBuilder(WSDL wsdl, File outputSrcDir, File outputClassDir) {
        this.wsdl = wsdl;
        this.outputSrcDir = outputSrcDir;
        this.outputClassDir = outputClassDir;
        for (ServiceInfo sInfo : wsdl.getServiceInfoList()) {
            this.serviceInfoList.add(JAXWSBuilder.generateJAXWSServiceInfo(sInfo, wsdl));
        }
    }

    public List<JAXWSServiceInfo> getServiceInfoList() {
        return this.serviceInfoList;
    }

    public void generate(List<File> jaxbBindingFiles) throws GenerationException {
        File jaxwsBindingFile = this.generateJAXWSBindingFile();
        this.generate(jaxwsBindingFile, jaxbBindingFiles);
    }

    private void generate(File jaxwsBindingFile, List<File> jaxbBindingFiles) throws GenerationException {
        File f;
        String wsdlUri = this.wsdl.getURI();
        WsImport2 wsImport = new WsImport2();
        wsImport.setProject(new Project());
        wsImport.setSourcedestdir(this.outputSrcDir);
        wsImport.setDestdir(this.outputClassDir);
        wsImport.createXjcarg().setValue("-Xcollection-setter-injector");
        wsImport.createXjcarg().setValue("-Xboolean-getter");
        wsImport.createXjcarg().setValue("-npa");
        wsImport.setKeep(true);
        wsImport.setQuiet(true);
        wsImport.setXnocompile(true);
        String wsdlFileName = this.getFileNameFromURI(wsdlUri);
        if (wsdlFileName != null && (f = new File(CodeGenUtils.getPackageDir(this.outputSrcDir, this.wsdl.getPackageName()), wsdlFileName)).exists()) {
            wsImport.setWsdllocation(wsdlFileName);
        }
        FileSet fs = new FileSet();
        fs.setFile(jaxwsBindingFile);
        wsImport.addConfiguredBinding(fs);
        for (File jaxbBindingFile : jaxbBindingFiles) {
            fs = new FileSet();
            fs.setFile(jaxbBindingFile);
            wsImport.addConfiguredBinding(fs);
        }
        wsImport.setWsdl(wsdlUri);
        try {
            wsImport.execute();
        }
        catch (Exception e) {
            throw new GenerationException(e);
        }
    }

    private File generateJAXWSBindingFile() {
        File bindingFile = new File(CodeGenUtils.getPackageDir(this.outputSrcDir, this.wsdl.getPackageName()), this.wsdl.getServiceId() + ".xml");
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(bindingFile));
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
        XMLWriter xw = XMLUtils.newXMLWriter((PrintWriter)pw);
        xw.addVersion();
        xw.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        xw.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        xw.addNamespace("jws", "http://java.sun.com/xml/ns/javaee");
        xw.addNamespace("jaxws", "http://java.sun.com/xml/ns/jaxws");
        xw.setCurrentShortNS("jaxws");
        xw.addElement("bindings");
        xw.addAttribute("wsdlLocation", this.wsdl.getURI());
        xw.addElement("package");
        xw.addAttribute("name", this.wsdl.getPackageName());
        xw.closeElement();
        xw.addElement("enableWrapperStyle", "false");
        for (JAXWSServiceInfo serviceInfo : this.serviceInfoList) {
            xw.addElement("bindings");
            xw.addAttribute("node", "wsdl:definitions/wsdl:service[@name='" + serviceInfo.getName() + "']");
            xw.addElement("class");
            xw.addAttribute("name", serviceInfo.getServiceClientClassName());
            xw.closeElement();
            xw.closeElement();
            for (JAXWSPortTypeInfo portTypeInfo : serviceInfo.getPortTypeInfoList()) {
                if (!portTypeInfo.isSeiClassNameModified()) continue;
                xw.addElement("bindings");
                xw.addAttribute("node", "wsdl:definitions/wsdl:portType[@name='" + portTypeInfo.getName() + "']");
                xw.addElement("class");
                xw.addAttribute("name", portTypeInfo.getSeiClassName());
                xw.closeElement();
                xw.closeElement();
            }
        }
        List<String> handlerClassNames = this.wsdl.getInterceptorClassNames();
        if (handlerClassNames != null && !handlerClassNames.isEmpty()) {
            xw.addElement("bindings");
            xw.addAttribute("node", "wsdl:definitions");
            xw.setCurrentShortNS("jws");
            xw.addElement("handler-chains");
            xw.addElement("handler-chain");
            for (String handlerClassName : handlerClassNames) {
                xw.addElement("handler");
                xw.addElement("handler-class", handlerClassName);
                xw.closeElement();
                xw.closeElement();
            }
        }
        xw.finish();
        pw.close();
        return bindingFile;
    }

    public static String getJavaMethodName(String operationName) {
        return NameConverter.standard.toVariableName(operationName);
    }

    public static String getJaxwsGeneratedClassName(String localName) {
        return JAXBRIContext.mangleNameToClassName((String)localName);
    }

    private String getFileNameFromURI(String uriString) {
        try {
            URI uri = new URI(uriString);
            if (uri.getScheme().equals("file")) {
                File f = new File(uri);
                return f.getName();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    private static JAXWSServiceInfo generateJAXWSServiceInfo(ServiceInfo serviceInfo, WSDL wsdl) {
        ArrayList<JAXWSPortTypeInfo> portTypeInfoList = new ArrayList<JAXWSPortTypeInfo>();
        for (PortTypeInfo portTypeInfo : serviceInfo.getPortTypeInfoList()) {
            portTypeInfoList.add(JAXWSBuilder.generateJAXWSPortTypeInfo(portTypeInfo, wsdl));
        }
        return new JAXWSServiceInfo(serviceInfo, wsdl.getPackageName(), portTypeInfoList);
    }

    private static JAXWSPortTypeInfo generateJAXWSPortTypeInfo(PortTypeInfo portTypeInfo, WSDL wsdl) {
        String seiClassName = JAXWSBuilder.getJaxwsGeneratedClassName(portTypeInfo.getName());
        boolean isSeiClassNameModified = false;
        if (wsdl.getServiceClassName().equals(seiClassName)) {
            isSeiClassNameModified = true;
            seiClassName = seiClassName + SEI_CLASS_NAME_SUFFIX;
        }
        return new JAXWSPortTypeInfo(portTypeInfo, seiClassName, wsdl.getPackageName(), isSeiClassNameModified);
    }

    public static Set<String> getGeneratedSeiClasses(WSDL wsdl) {
        HashSet<String> seiClasses = new HashSet<String>();
        for (ServiceInfo sInfo : wsdl.getServiceInfoList()) {
            JAXWSServiceInfo serviceInfo = JAXWSBuilder.generateJAXWSServiceInfo(sInfo, wsdl);
            for (JAXWSPortTypeInfo portTypeInfo : serviceInfo.getPortTypeInfoList()) {
                seiClasses.add(portTypeInfo.getSeiFQClassName());
            }
        }
        return seiClasses;
    }
}

