/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws.wadl;

import com.wavemaker.common.util.CastUtils;
import com.wavemaker.tools.ws.RESTInputParam;
import com.wavemaker.tools.ws.RESTWsdlGenerator;
import com.wavemaker.tools.ws.wadl.WADLException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.jvnet.ws.wadl.Application;
import org.jvnet.ws.wadl.Grammars;
import org.jvnet.ws.wadl.Include;
import org.jvnet.ws.wadl.Method;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.RepresentationType;
import org.jvnet.ws.wadl.Request;
import org.jvnet.ws.wadl.Resource;
import org.jvnet.ws.wadl.Resources;
import org.jvnet.ws.wadl.Response;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Wadl2Wsdl {
    private static final String WADL_PACKAGE = "org.jvnet.ws.wadl";
    private static final String DEFAULT_OPERATION_NAME = "invoke";
    private static JAXBContext jaxbContext;
    private URI wadlUri;
    private Application application;

    private static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)WADL_PACKAGE);
        }
        return jaxbContext;
    }

    public Wadl2Wsdl(URI wadlUri) throws JAXBException, MalformedURLException, URISyntaxException {
        Unmarshaller unmarshaller = Wadl2Wsdl.getJAXBContext().createUnmarshaller();
        this.wadlUri = wadlUri;
        this.application = (Application)unmarshaller.unmarshal(wadlUri.toURL());
    }

    private Resource getResource() {
        Resource r = (Resource)this.application.getResources().getResource().get(0);
        Resource res = null;
        while ((res = Wadl2Wsdl.getChildResource(r)) != null) {
            r = res;
        }
        return r;
    }

    private static Resource getChildResource(Resource r) {
        List methodOrResource = r.getMethodOrResource();
        for (Object o : methodOrResource) {
            if (!(o instanceof Resource)) continue;
            return (Resource)o;
        }
        return null;
    }

    private String getServiceURLPath() {
        Resources resources = this.application.getResources();
        StringBuilder sb = new StringBuilder();
        sb.append(resources.getBase());
        Resource res = (Resource)resources.getResource().get(0);
        sb.append(res.getPath());
        while ((res = Wadl2Wsdl.getChildResource(res)) != null) {
            sb.append("/");
            sb.append(res.getPath());
        }
        return sb.toString();
    }

    private String getServiceName() {
        String path = this.getResource().getPath();
        if (path.indexOf(46) > -1) {
            return path.substring(0, path.indexOf(46));
        }
        return path;
    }

    private Method getMethod() throws WADLException {
        List list1 = this.application.getResourceTypeOrMethodOrRepresentation();
        ArrayList<Method> allMethods = new ArrayList<Method>();
        for (Object o : list1) {
            if (!(o instanceof Method)) continue;
            allMethods.add((Method)o);
        }
        List list2 = this.getResource().getMethodOrResource();
        for (Object o : list2) {
            if (!(o instanceof Method)) continue;
            Method m = (Method)o;
            if (m.getHref() != null) {
                for (Method method : allMethods) {
                    if (!method.getId().equals(m.getHref().substring(1))) continue;
                    return method;
                }
                continue;
            }
            return m;
        }
        throw new WADLException(com.wavemaker.common.Resource.WS_WADL_METHOD_NOT_FOUND);
    }

    public File generateWSDL(File outDir) throws WSDLException, SAXException, IOException, ParserConfigurationException, WADLException, TransformerException {
        File wsdlFile = new File(outDir, this.getServiceName() + ".wsdl");
        String serviceName = this.getServiceName();
        String namespace = this.getServiceURLPath();
        String operationName = DEFAULT_OPERATION_NAME;
        QName outputElement = null;
        LinkedHashMap<String, RESTInputParam.InputType> tempInputParts = new LinkedHashMap<String, RESTInputParam.InputType>();
        List initParamList = this.getResource().getParam();
        for (Param param : initParamList) {
            tempInputParts.put(param.getName(), RESTInputParam.InputType.STRING);
        }
        Method method = this.getMethod();
        Request request = method.getRequest();
        List paramList = request.getParam();
        for (Param param : paramList) {
            tempInputParts.put(param.getName(), RESTInputParam.InputType.STRING);
        }
        Response response = method.getResponse();
        for (JAXBElement representationOrFault : response.getRepresentationOrFault()) {
            if (!representationOrFault.getName().getLocalPart().equals("representation")) continue;
            outputElement = ((RepresentationType)representationOrFault.getValue()).getElement();
            break;
        }
        ArrayList<RESTInputParam> inputParts = new ArrayList<RESTInputParam>();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry inputPart : tempInputParts.entrySet()) {
            String paramName = (String)inputPart.getKey();
            sb.append(URLEncoder.encode(paramName, "UTF-8"));
            sb.append("={");
            sb.append(paramName);
            sb.append("}&");
            inputParts.add(new RESTInputParam(paramName, (RESTInputParam.InputType)((Object)inputPart.getValue())));
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '&') {
            sb.deleteCharAt(sb.length() - 1);
        }
        String parameterizedURL = this.getServiceURLPath() + "?" + sb.toString();
        Grammars grammars = this.application.getGrammars();
        ArrayList<Element> schemaElements = new ArrayList<Element>();
        if (grammars != null) {
            for (Object any : grammars.getAny()) {
                if (!(any instanceof Element)) continue;
                schemaElements.add(Wadl2Wsdl.checkAndFixUnboundedSequence((Element)any));
            }
            for (Include include : grammars.getInclude()) {
                URI includeUri = this.wadlUri.resolve(include.getHref());
                InputSource input = new InputSource(includeUri.toURL().openStream());
                XmlSchemaCollection xmlSchemaColl = new XmlSchemaCollection();
                XmlSchema xmlSchema = xmlSchemaColl.read(input, null);
                for (Document schemaDocument : xmlSchema.getAllSchemas()) {
                    schemaElements.add(schemaDocument.getDocumentElement());
                }
            }
        }
        RESTWsdlGenerator generator = new RESTWsdlGenerator(serviceName, namespace, operationName, parameterizedURL);
        generator.setSchemaElements(schemaElements);
        generator.setInputParts(inputParts);
        if (outputElement != null) {
            generator.setOutputElementType(outputElement);
        }
        generator.write(wsdlFile);
        return wsdlFile;
    }

    private static Element checkAndFixUnboundedSequence(Element schema) {
        Document[] allSchemas;
        XmlSchemaCollection xmlSchemaColl = new XmlSchemaCollection();
        XmlSchema xmlSchema = xmlSchemaColl.read(schema);
        boolean isModified = false;
        XmlSchemaObjectTable elements = xmlSchema.getElements();
        Iterator elementsIter = CastUtils.cast((Iterator)elements.getValues());
        while (elementsIter.hasNext()) {
            XmlSchemaObject element = (XmlSchemaObject)elementsIter.next();
            if (!(element instanceof XmlSchemaElement)) continue;
            XmlSchemaType schemaType = ((XmlSchemaElement)element).getSchemaType();
            isModified = Wadl2Wsdl.fixIt(schemaType);
        }
        XmlSchemaObjectTable schemaTypes = xmlSchema.getSchemaTypes();
        Iterator schemaTypesIter = CastUtils.cast((Iterator)schemaTypes.getValues());
        while (schemaTypesIter.hasNext()) {
            XmlSchemaObject schemaType = (XmlSchemaObject)schemaTypesIter.next();
            if (!(schemaType instanceof XmlSchemaType)) continue;
            isModified = Wadl2Wsdl.fixIt((XmlSchemaType)schemaType);
        }
        if (isModified && (allSchemas = xmlSchema.getAllSchemas()).length > 0) {
            return allSchemas[0].getDocumentElement();
        }
        return schema;
    }

    private static boolean fixIt(XmlSchemaType schemaType) {
        XmlSchemaSequence sequence;
        XmlSchemaObjectCollection items;
        XmlSchemaParticle particle;
        if (schemaType != null && schemaType instanceof XmlSchemaComplexType && (particle = ((XmlSchemaComplexType)schemaType).getParticle()) != null && particle instanceof XmlSchemaSequence && (items = (sequence = (XmlSchemaSequence)particle).getItems()).getCount() > 1 && sequence.getMaxOccurs() > 1L) {
            sequence.setMaxOccurs(1L);
            return true;
        }
        return false;
    }
}

