/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws.wsdl;

import com.wavemaker.common.util.CastUtils;
import com.wavemaker.tools.ws.CodeGenUtils;
import com.wavemaker.tools.ws.wsdl.GenericInfo;
import com.wavemaker.tools.ws.wsdl.WSDLUtils;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortTypeInfo
extends GenericInfo {
    private PortType portType;
    private Port port;
    private Service service;
    private String targetNamespace;
    private Map<String, Operation> operationMap = new TreeMap<String, Operation>();

    protected PortTypeInfo(PortType portType) {
        this.portType = portType;
        for (Operation op : CastUtils.cast((List)portType.getOperations(), Operation.class)) {
            this.operationMap.put(CodeGenUtils.toJavaMethodName(op.getName()), op);
        }
    }

    public QName getQName() {
        return this.portType.getQName();
    }

    public String getName() {
        return this.getQName().getLocalPart();
    }

    public String getClassName() {
        return CodeGenUtils.toClassName(this.getName());
    }

    public String getPortName() {
        return this.port.getName();
    }

    public Map<String, Operation> getOperationMap() {
        return this.operationMap;
    }

    public String getSoapAddress() {
        WSDLUtils.SoapAddress soapAddress;
        if (this.port != null && (soapAddress = WSDLUtils.getSoapAddress(this.port)) != null) {
            return soapAddress.getLocationURI();
        }
        return null;
    }

    protected String getTargetNamespace() {
        return this.targetNamespace;
    }

    protected void setTargetNamespace(String ns) {
        this.targetNamespace = ns;
    }

    protected void setPort(Port port) {
        this.port = port;
    }

    protected Service getService() {
        return this.service;
    }

    protected void setService(Service service) {
        this.service = service;
    }
}

