/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws.wsdl;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.CastUtils;
import com.wavemaker.runtime.service.ElementType;
import com.wavemaker.runtime.service.ServiceType;
import com.wavemaker.runtime.service.definition.AbstractDeprecatedServiceDefinition;
import com.wavemaker.runtime.service.definition.ReflectServiceDefinition;
import com.wavemaker.runtime.ws.HTTPBindingSupport;
import com.wavemaker.tools.ws.wsdl.SchemaElementType;
import com.wavemaker.tools.ws.wsdl.SchemaException;
import com.wavemaker.tools.ws.wsdl.SchemaUtils;
import com.wavemaker.tools.ws.wsdl.ServiceInfo;
import com.wavemaker.tools.ws.wsdl.TypeMapper;
import com.wavemaker.tools.ws.wsdl.WSDLUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL
extends AbstractDeprecatedServiceDefinition
implements ReflectServiceDefinition {
    private static final int MAX_NESTED_CHILD_LEVEL = 10;
    private String serviceId;
    private String serviceClassName;
    private List<ServiceInfo> serviceInfoList;
    private Set<String> auxiliaryClasses;
    private WebServiceType webServiceType;
    private String packageName;
    private Definition definition;
    private String wsdlURI;
    private Map<String, Element> schemas;
    private List<XmlSchema> xmlSchemas;
    private List<String> importedNoRefSchemas;
    private boolean isRPC;
    private boolean isSOAPEncoded;
    private String endpointLocation;
    private HTTPBindingSupport.HTTPRequestMethod httpRequestMethod;
    private boolean noOverwriteCustomizationFiles;
    private boolean skipInternalCustomization;
    private List<File> jaxbCustomizationFiles;
    private List<File> jaxwsCustomizationFiles;
    private List<String> interceptorClassNames = new ArrayList<String>();
    private Map<String, Operation> operationMap;
    private TypeMapper typeMapper;
    private String runtimeConfiguration;

    private WSDL() {
    }

    public WSDL(String serviceId, String serviceClassName, List<ServiceInfo> serviceInfoList, Definition definition, String wsdlURI, WebServiceType webServiceType, Map<String, Element> schemas, List<XmlSchema> xmlSchemas) throws SchemaException {
        this.serviceId = serviceId;
        this.serviceClassName = serviceClassName;
        this.serviceInfoList = serviceInfoList;
        this.definition = definition;
        this.wsdlURI = wsdlURI;
        this.webServiceType = webServiceType;
        this.schemas = schemas;
        this.xmlSchemas = xmlSchemas;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    public List<ServiceInfo> getServiceInfoList() {
        return this.serviceInfoList;
    }

    @Override
    public ServiceType getServiceType() {
        return new com.wavemaker.runtime.ws.WebServiceType();
    }

    public WebServiceType getWebServiceType() {
        return this.webServiceType;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String pkg) {
        this.packageName = pkg;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public String getURI() {
        return this.wsdlURI;
    }

    public String getTargetNamespace() {
        return this.definition.getTargetNamespace();
    }

    public Map<String, Element> getSchemas() {
        return this.schemas;
    }

    public List<XmlSchema> getXmlSchemas() {
        return this.xmlSchemas;
    }

    public List<String> getImportedNoRefSchemas() {
        return this.importedNoRefSchemas;
    }

    public void setImportedNoRefSchemas(List<String> importedNoRefSchemas) {
        this.importedNoRefSchemas = importedNoRefSchemas;
    }

    public boolean isRPC() {
        return this.isRPC;
    }

    public void setRPC(boolean isRPC) {
        this.isRPC = isRPC;
    }

    public boolean isSOAPEncoded() {
        return this.isSOAPEncoded;
    }

    public void setSOAPEncoded(boolean isSOAPEncoded) {
        this.isSOAPEncoded = isSOAPEncoded;
    }

    public String getEndpointLocation() {
        return this.endpointLocation;
    }

    public void setEndpointLocation(String endpointLocation) {
        this.endpointLocation = endpointLocation;
    }

    public HTTPBindingSupport.HTTPRequestMethod getHttpRequestMethod() {
        return this.httpRequestMethod;
    }

    public void setHttpRequestMethod(HTTPBindingSupport.HTTPRequestMethod httpRequestMethod) {
        this.httpRequestMethod = httpRequestMethod;
    }

    public boolean isNoOverwriteCustomizationFiles() {
        return this.noOverwriteCustomizationFiles;
    }

    public void setNoOverwriteCustomizationFiles(boolean noOverwriteCustomizationFiles) {
        this.noOverwriteCustomizationFiles = noOverwriteCustomizationFiles;
    }

    public boolean isSkipInternalCustomization() {
        return this.skipInternalCustomization;
    }

    public void setSkipInternalCustomization(boolean skipInternalCustomization) {
        this.skipInternalCustomization = skipInternalCustomization;
    }

    public List<File> getJaxbCustomizationFiles() {
        return this.jaxbCustomizationFiles;
    }

    public void setJaxbCustomizationFiles(List<File> jaxbCustomizationFiles) {
        this.jaxbCustomizationFiles = jaxbCustomizationFiles;
    }

    public List<File> getJaxwsCustomizationFiles() {
        return this.jaxwsCustomizationFiles;
    }

    public void setJaxwsCustomizationFiles(List<File> jaxwsCustomizationFiles) {
        this.jaxwsCustomizationFiles = jaxwsCustomizationFiles;
    }

    public List<String> getInterceptorClassNames() {
        return this.interceptorClassNames;
    }

    public void setInterceptorClassNames(List<String> classNames) {
        this.interceptorClassNames = classNames;
    }

    public void addInterceptorClassName(String className) {
        this.interceptorClassNames.add(className);
    }

    @Override
    public List<String> getOperationNames() {
        return new ArrayList<String>(this.operationMap.keySet());
    }

    public Operation getOperation(String name) {
        return this.operationMap.get(name);
    }

    public void setOperationsMap(Map<String, Operation> operationMap) {
        this.operationMap = operationMap;
    }

    @Override
    public List<ElementType> getInputTypes(String operationName) {
        return this.getInputTypes(operationName, false);
    }

    @Override
    public ElementType getOutputType(String operationName) {
        return this.getOutputType(operationName, false);
    }

    public List<ElementType> getInputTypes(String operationName, boolean unWrapped) {
        List<SchemaElementType> types = null;
        types = unWrapped ? this.getUnWrappedInputTypes(operationName) : this.getDefinedInputTypes(operationName);
        if (this.webServiceType == WebServiceType.SOAP) {
            types.addAll(this.getSOAPHeaderInputTypes(operationName));
        }
        return CastUtils.cast(types, ElementType.class);
    }

    public ElementType getOutputType(String operationName, boolean unWrapped) {
        if (unWrapped) {
            return this.getUnWrappedOutputType(operationName);
        }
        return this.getDefinedOutputType(operationName);
    }

    public List<SchemaElementType> getExceptionTypes(String operationName) {
        ArrayList<SchemaElementType> elementTypes = new ArrayList<SchemaElementType>();
        if (this.webServiceType == WebServiceType.SOAP) {
            Operation operation = this.getOperation(operationName);
            List<Part> faultParts = WSDLUtils.getFaults(this.definition, operation);
            for (Part faultPart : faultParts) {
                SchemaElementType elementType = this.constructSchemaElementType(faultPart);
                elementTypes.add(elementType);
            }
        }
        return elementTypes;
    }

    public List<SchemaElementType> getSOAPHeaderInputTypes(String operationName) {
        ArrayList<SchemaElementType> elementTypes = new ArrayList<SchemaElementType>();
        if (this.webServiceType == WebServiceType.SOAP) {
            Operation operation = this.getOperation(operationName);
            List<WSDLUtils.SoapHeader> inputSoapHeaders = WSDLUtils.getInputSoapHeaders(this.definition, operation);
            for (WSDLUtils.SoapHeader soapHeader : inputSoapHeaders) {
                Message soapHeaderMessage = this.definition.getMessage(soapHeader.getMessage());
                String partName = soapHeader.getPart();
                if (partName != null && partName.length() > 0) {
                    Part part = soapHeaderMessage.getPart(partName);
                    elementTypes.add(this.constructSchemaElementType(part));
                    continue;
                }
                elementTypes.addAll(this.parseMessageParts(soapHeaderMessage));
            }
        }
        return elementTypes;
    }

    private List<SchemaElementType> parseMessageParts(Message message) {
        ArrayList<SchemaElementType> elementTypes = new ArrayList<SchemaElementType>();
        List parts = CastUtils.cast((List)message.getOrderedParts(null));
        for (Part part : parts) {
            elementTypes.add(this.constructSchemaElementType(part));
        }
        return elementTypes;
    }

    private SchemaElementType constructSchemaElementType(Part part) {
        boolean isElement = false;
        QName schemaType = part.getTypeName();
        if (schemaType == null) {
            schemaType = part.getElementName();
            isElement = true;
        }
        SchemaElementType type = new SchemaElementType(this.getTypeMapper().toPropertyName(part.getName()), schemaType, this.getJavaType(schemaType, isElement));
        type.setProperties(CastUtils.cast(this.getChildTypes(type, 10), ElementType.class));
        return type;
    }

    public List<SchemaElementType> getDefinedInputTypes(String operationName) {
        Message message;
        ArrayList<SchemaElementType> elementTypes = new ArrayList<SchemaElementType>();
        Operation operation = this.getOperation(operationName);
        Input input = operation.getInput();
        if (input != null && (message = input.getMessage()) != null) {
            elementTypes.addAll(this.parseMessageParts(message));
        }
        return elementTypes;
    }

    public SchemaElementType getDefinedOutputType(String operationName) {
        List<SchemaElementType> elementTypes;
        Message message;
        Operation operation = this.getOperation(operationName);
        Output output = operation.getOutput();
        if (output != null && (message = output.getMessage()) != null && (elementTypes = this.parseMessageParts(message)).size() == 1) {
            return elementTypes.get(0);
        }
        return null;
    }

    public List<SchemaElementType> getUnWrappedInputTypes(String operationName) {
        List<SchemaElementType> elementTypes = this.getDefinedInputTypes(operationName);
        if (!this.isRPC() && elementTypes.size() == 1) {
            List<SchemaElementType> childTypes = this.getChildTypes(elementTypes.iterator().next(), 10);
            return childTypes.isEmpty() ? elementTypes : childTypes;
        }
        return elementTypes;
    }

    public SchemaElementType getUnWrappedOutputType(String operationName) {
        SchemaElementType elementType = this.getDefinedOutputType(operationName);
        if (!this.isRPC() && elementType != null) {
            List<SchemaElementType> childTypes = this.getChildTypes(elementType, 10);
            return childTypes.size() == 1 ? childTypes.get(0) : elementType;
        }
        return elementType;
    }

    private List<SchemaElementType> getChildTypes(SchemaElementType rootType, int maxLevel) {
        List<XmlSchemaElement> childElements = this.getChildElements(rootType.getSchemaType());
        if (childElements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SchemaElementType> childTypes = new ArrayList<SchemaElementType>();
        for (XmlSchemaElement childElement : childElements) {
            boolean isElement = false;
            QName t = childElement.getSchemaTypeName();
            if (t == null) {
                t = childElement.getRefName();
                isElement = true;
            }
            if (t == null) continue;
            SchemaElementType ctype = new SchemaElementType(this.getTypeMapper().toPropertyName(childElement.getName()), t, this.getJavaType(t, isElement), childElement.getMinOccurs(), childElement.getMaxOccurs());
            if (maxLevel > 1 && !rootType.getName().equals(ctype.getName())) {
                ctype.setProperties(CastUtils.cast(this.getChildTypes(ctype, maxLevel--), ElementType.class));
            }
            childTypes.add(ctype);
        }
        return childTypes;
    }

    private List<XmlSchemaElement> getChildElements(QName qname) {
        for (XmlSchema schema : this.xmlSchemas) {
            XmlSchemaElement element;
            XmlSchemaType schemaType = schema.getTypeByName(qname);
            if (schemaType == null && (element = schema.getElementByName(qname)) != null) {
                schemaType = element.getSchemaType();
            }
            if (schemaType == null) continue;
            return SchemaUtils.getChildElements(schemaType);
        }
        return Collections.emptyList();
    }

    public TypeMapper getTypeMapper() {
        if (this.typeMapper == null) {
            throw new WMRuntimeException(Resource.WS_MISSING_TYPEMAPPER);
        }
        return this.typeMapper;
    }

    public void setTypeMapper(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    private String getJavaType(QName qname, boolean isElement) {
        return this.getTypeMapper().getJavaType(qname, isElement);
    }

    @Override
    public String getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    public void setRuntimeConfiguration(String runtimeConfiguration) {
        this.runtimeConfiguration = runtimeConfiguration;
    }

    @Override
    public void dispose() {
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    @Override
    public String getServiceClass() {
        return this.getPackageName() + "." + this.getServiceClassName();
    }

    public Set<String> getAuxiliaryClasses() {
        return this.auxiliaryClasses;
    }

    public void setAuxiliaryClasses(Set<String> auxiliaryClasses) {
        this.auxiliaryClasses = auxiliaryClasses;
    }

    @Override
    public List<ElementType> getTypes() {
        return this.getTypeMapper().getAllTypes();
    }

    @Override
    public List<String> getEventNotifiers() {
        return new ArrayList<String>();
    }

    @Override
    public boolean isLiveDataService() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebServiceType {
        SOAP,
        REST;

    }
}

