/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws.wsdl;

import com.wavemaker.common.Resource;
import com.wavemaker.common.util.CastUtils;
import com.wavemaker.runtime.ws.HTTPBindingSupport;
import com.wavemaker.tools.ws.CodeGenUtils;
import com.wavemaker.tools.ws.jaxws.JAXWSBuilder;
import com.wavemaker.tools.ws.wsdl.MessageInterceptorManager;
import com.wavemaker.tools.ws.wsdl.PortTypeInfo;
import com.wavemaker.tools.ws.wsdl.SchemaException;
import com.wavemaker.tools.ws.wsdl.ServiceInfo;
import com.wavemaker.tools.ws.wsdl.WSDL;
import com.wavemaker.tools.ws.wsdl.WSDLException;
import com.wavemaker.tools.ws.wsdl.WSDLUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLBuilder {
    private List<XmlSchema> xmlSchemas = new ArrayList<XmlSchema>();
    private Map<String, Element> schemaMap = new LinkedHashMap<String, Element>();
    private List<String> importedSchemas = new ArrayList<String>();
    private List<String> importedNoRefSchemas = new ArrayList<String>();
    private String wsdlURI;
    private Definition definition;
    private WSDL.WebServiceType serviceType;

    public WSDLBuilder(String wsdlURI) throws WSDLException {
        this.wsdlURI = wsdlURI;
        this.definition = WSDLUtils.readDefinition(wsdlURI);
        this.serviceType = this.getWebServiceType();
    }

    public WSDL buildWSDL(String serviceId) throws WSDLException {
        List<PortTypeInfo> portTypeInfoList = this.buildServices();
        this.processSchemas(this.definition);
        Map<String, Element> schemas = this.buildSchemas();
        String name = WSDLUtils.generateServiceName(this.definition);
        String serviceClassName = CodeGenUtils.toClassName(name);
        if (serviceId == null || serviceId.length() == 0) {
            serviceId = WSDLBuilder.toValidServiceId(name);
        }
        List<ServiceInfo> serviceInfoList = this.buildServiceInfoList(serviceId, portTypeInfoList);
        try {
            WSDL wsdl = new WSDL(serviceId, serviceClassName, serviceInfoList, this.definition, this.wsdlURI, this.serviceType, schemas, this.xmlSchemas);
            this.populateWSDL(wsdl);
            return wsdl;
        }
        catch (SchemaException e) {
            throw new WSDLException((Throwable)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateWSDL(WSDL wsdl) throws WSDLException {
        String packageName = CodeGenUtils.constructPackageName(wsdl.getTargetNamespace(), wsdl.getServiceId());
        wsdl.setPackageName(packageName);
        wsdl.setImportedNoRefSchemas(this.importedNoRefSchemas);
        if (wsdl.getWebServiceType() == WSDL.WebServiceType.REST) {
            String restParameterizedURL = null;
            Element element = this.definition.getDocumentationElement();
            if (element != null && element.getFirstChild() != null) {
                String s = element.getFirstChild().getTextContent();
                int i = (s = s.trim()).indexOf("endpoint=");
                if (i > -1 && (restParameterizedURL = s.substring("endpoint=".length())).charAt(0) == '[') {
                    int j = restParameterizedURL.indexOf(93);
                    String httpMethod = restParameterizedURL.substring(1, j);
                    HTTPBindingSupport.HTTPRequestMethod v = HTTPBindingSupport.HTTPRequestMethod.valueOf(httpMethod);
                    if (v != null) {
                        wsdl.setHttpRequestMethod(v);
                    }
                    restParameterizedURL = restParameterizedURL.substring(j + 1);
                }
            }
            if (restParameterizedURL == null) throw new WSDLException(Resource.WS_REST_WSDL_MISSING_URL, new Object[0]);
            wsdl.setEndpointLocation(restParameterizedURL);
        } else {
            String style = WSDLUtils.getStyle(this.definition);
            boolean isRPC = style != null && style.equals("rpc");
            wsdl.setRPC(isRPC);
            wsdl.setSOAPEncoded(WSDLUtils.isSOAPEncoded(this.definition));
            wsdl.setAuxiliaryClasses(JAXWSBuilder.getGeneratedSeiClasses(wsdl));
        }
        TreeMap<String, Operation> operationMap = new TreeMap<String, Operation>();
        for (ServiceInfo serviceInfo : wsdl.getServiceInfoList()) {
            for (PortTypeInfo portTypeInfo : serviceInfo.getPortTypeInfoList()) {
                operationMap.putAll(portTypeInfo.getOperationMap());
            }
        }
        wsdl.setOperationsMap(operationMap);
        List<String> interceptorClassNames = MessageInterceptorManager.getInstance().getInterceptorClassNames(wsdl.getServiceId());
        if (interceptorClassNames == null) return;
        wsdl.setInterceptorClassNames(interceptorClassNames);
    }

    private WSDL.WebServiceType getWebServiceType() {
        WSDL.WebServiceType serviceType = WSDL.WebServiceType.SOAP;
        if (WSDLUtils.getBindingForSOAP(this.definition, null) == null) {
            serviceType = WSDL.WebServiceType.REST;
        }
        return serviceType;
    }

    private List<ServiceInfo> buildServiceInfoList(String serviceId, List<PortTypeInfo> portTypeInfoList) {
        ArrayList<ServiceInfo> serviceInfoList = new ArrayList<ServiceInfo>();
        if (this.serviceType == WSDL.WebServiceType.REST) {
            ServiceInfo serviceInfo = new ServiceInfo(new QName(this.definition.getTargetNamespace(), serviceId));
            serviceInfo.setPortTypeInfoList(portTypeInfoList);
            serviceInfoList.add(serviceInfo);
        } else {
            for (PortTypeInfo portTypeInfo : portTypeInfoList) {
                Service serv = portTypeInfo.getService();
                if (serv == null) continue;
                ServiceInfo serviceInfo = WSDLBuilder.getOrCreateServiceInfo(serv.getQName(), serviceInfoList);
                serviceInfo.addPortTypeInfo(portTypeInfo);
            }
        }
        return serviceInfoList;
    }

    private Map<String, Element> buildSchemas() {
        HashMap<String, Element> schemas = new HashMap<String, Element>();
        int schemaElementCount = 1;
        for (String id : this.schemaMap.keySet()) {
            String systemId;
            Element schema = this.schemaMap.get(id);
            String location = schema.getOwnerDocument().getDocumentURI();
            if (this.serviceType == WSDL.WebServiceType.REST) {
                systemId = location;
                if (schemas.containsKey(systemId)) {
                    systemId = location + "#types?schema" + schemaElementCount++;
                }
            } else {
                systemId = this.importedSchemas.contains(location) ? location : location + "#types?schema" + schemaElementCount++;
            }
            schemas.put(systemId, schema);
        }
        return schemas;
    }

    private List<PortTypeInfo> buildServices() {
        ArrayList<PortTypeInfo> portTypeInfoList = new ArrayList<PortTypeInfo>();
        if (this.definition.getServices().isEmpty()) {
            Collection portTypes = CastUtils.cast(this.definition.getAllPortTypes().values());
            for (PortType portType : portTypes) {
                portTypeInfoList.addAll(this.buildServices(this.definition, portType));
            }
        } else {
            Iterator ite = CastUtils.cast(this.definition.getServices().keySet().iterator());
            while (ite.hasNext()) {
                QName qn = (QName)ite.next();
                portTypeInfoList.addAll(this.buildServices(this.definition, qn));
            }
        }
        return portTypeInfoList;
    }

    private List<PortTypeInfo> buildServices(Definition d, QName name) {
        Service serv = d.getService(name);
        return this.buildServices(d, serv);
    }

    private List<PortTypeInfo> buildServices(Definition def, Service serv) {
        LinkedHashMap<QName, PortTypeInfo> services = new LinkedHashMap<QName, PortTypeInfo>();
        for (Port port : WSDLBuilder.getSoapPorts(serv)) {
            Binding binding = port.getBinding();
            PortType pt = binding.getPortType();
            this.buildServices(services, def, pt, port, serv);
        }
        return new ArrayList<PortTypeInfo>(services.values());
    }

    private List<PortTypeInfo> buildServices(Definition def, PortType pt) {
        LinkedHashMap<QName, PortTypeInfo> services = new LinkedHashMap<QName, PortTypeInfo>();
        this.buildServices(services, def, pt, null, null);
        return new ArrayList<PortTypeInfo>(services.values());
    }

    private void buildServices(Map<QName, PortTypeInfo> services, Definition def, PortType pt, Port p, Service serv) {
        PortTypeInfo portTypeInfo = services.get(pt.getQName());
        if (portTypeInfo == null) {
            portTypeInfo = new PortTypeInfo(pt);
            portTypeInfo.setTargetNamespace(def.getTargetNamespace());
            if (p != null) {
                portTypeInfo.setPort(p);
            }
            if (serv != null) {
                portTypeInfo.setService(serv);
            }
            services.put(pt.getQName(), portTypeInfo);
        }
    }

    private XmlSchemaCollection processSchemas(Definition def) {
        XmlSchemaCollection schemaCol = new XmlSchemaCollection();
        ArrayList<Definition> defList = new ArrayList<Definition>();
        this.parseImports(def, defList);
        this.extractSchema(def, schemaCol);
        this.processSchemaList(def);
        for (Definition def2 : defList) {
            this.extractSchema(def2, schemaCol);
            this.processSchemaList(def2);
        }
        return schemaCol;
    }

    private void parseImports(Definition def, List<Definition> defList) {
        ArrayList importList = new ArrayList();
        Collection ilist = CastUtils.cast(def.getImports().values());
        for (List list : ilist) {
            importList.addAll(list);
        }
        for (Import impt : importList) {
            this.parseImports(impt.getDefinition(), defList);
            defList.add(impt.getDefinition());
        }
    }

    private void extractSchema(Definition def, XmlSchemaCollection schemaCol) {
        Types typesElement = def.getTypes();
        if (typesElement != null) {
            int schemaCount = 1;
            for (Object obj : typesElement.getExtensibilityElements()) {
                Element elem;
                Element schemaElem = null;
                if (obj instanceof Schema) {
                    Schema schema = (Schema)obj;
                    schemaElem = schema.getElement();
                } else if (obj instanceof UnknownExtensibilityElement && (elem = ((UnknownExtensibilityElement)obj).getElement()).getLocalName().equals("schema")) {
                    schemaElem = elem;
                }
                if (schemaElem == null) continue;
                for (Object prefix : def.getNamespaces().keySet()) {
                    String ns = (String)def.getNamespaces().get(prefix);
                    if ("".equals(prefix) || schemaElem.hasAttribute("xmlns:" + prefix)) continue;
                    schemaElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, ns);
                }
                String systemId = def.getDocumentBaseURI() + "#types?schema" + schemaCount;
                schemaCol.setBaseUri(def.getDocumentBaseURI());
                XmlSchema xmlSchema = schemaCol.read(schemaElem, systemId);
                this.xmlSchemas.add(xmlSchema);
                ++schemaCount;
            }
        }
    }

    private void processSchemaList(Definition def) {
        Types typesElement = def.getTypes();
        if (typesElement != null) {
            Iterator ite = CastUtils.cast(typesElement.getExtensibilityElements().iterator());
            while (ite.hasNext()) {
                Object obj = ite.next();
                if (!(obj instanceof Schema)) continue;
                Schema schema = (Schema)obj;
                this.addSchema(schema, false);
            }
        }
    }

    private void addSchema(Schema schema, boolean isImport) {
        Map imports;
        String tns;
        String docBaseURI = schema.getDocumentBaseURI();
        Element schemaEle = schema.getElement();
        if (this.schemaMap.get(docBaseURI) == null) {
            this.schemaMap.put(docBaseURI, schemaEle);
            if (isImport) {
                this.importedSchemas.add(docBaseURI);
            }
        } else if (!(this.schemaMap.get(docBaseURI) != null && this.schemaMap.containsValue(schemaEle) || this.schemaMap.get(tns = schema.getDocumentBaseURI() + "#" + schema.getElement().getAttribute("targetNamespace")) != null)) {
            this.schemaMap.put(tns, schema.getElement());
        }
        if ((imports = CastUtils.cast((Map)schema.getImports())) != null && imports.size() > 0) {
            Set importKeys = imports.keySet();
            for (String importNamespace : importKeys) {
                if (this.isSchemaParsed(schema.getDocumentBaseURI(), importNamespace)) continue;
                List schemaImports = CastUtils.cast((List)((List)imports.get(importNamespace)));
                for (SchemaImport schemaImport : schemaImports) {
                    Schema tempImport = schemaImport.getReferencedSchema();
                    if (tempImport != null && !this.schemaMap.containsValue(tempImport.getElement())) {
                        this.addSchema(tempImport, true);
                        continue;
                    }
                    this.importedNoRefSchemas.add(schemaImport.getNamespaceURI());
                }
            }
        }
    }

    private boolean isSchemaParsed(String baseUri, String ns) {
        Element ele;
        String tns;
        return this.schemaMap.get(baseUri) != null && ns.equals(tns = (ele = this.schemaMap.get(baseUri)).getAttribute("targetNamespace"));
    }

    private static ServiceInfo getOrCreateServiceInfo(QName servQName, List<ServiceInfo> serviceInfoList) {
        for (ServiceInfo serviceInfo : serviceInfoList) {
            if (!serviceInfo.getQName().equals(servQName)) continue;
            return serviceInfo;
        }
        ServiceInfo serviceInfo = new ServiceInfo(servQName);
        serviceInfoList.add(serviceInfo);
        return serviceInfo;
    }

    private static List<Port> getSoapPorts(Service serv) {
        ArrayList<Port> ports = new ArrayList<Port>();
        for (Port p : CastUtils.cast(serv.getPorts().values(), Port.class)) {
            WSDLUtils.SoapAddress soapAddress = WSDLUtils.getSoapAddress(p);
            if (soapAddress == null) continue;
            Port duplPort = WSDLBuilder.findPortWithSamePortType(ports, p);
            if (duplPort == null) {
                ports.add(p);
                continue;
            }
            if (!(soapAddress instanceof WSDLUtils.Soap11Address)) continue;
            ports.remove(duplPort);
            ports.add(p);
        }
        return ports;
    }

    private static Port findPortWithSamePortType(List<Port> ports, Port p) {
        for (Port port : ports) {
            if (!p.getBinding().getPortType().getQName().equals(port.getBinding().getPortType().getQName())) continue;
            return port;
        }
        return null;
    }

    private static String toValidServiceId(String name) {
        return name.replace("-", "");
    }
}

