/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws.wsdl;

import com.wavemaker.common.Resource;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.ws.wsdl.WSDL;
import com.wavemaker.tools.ws.wsdl.WSDLBuilder;
import com.wavemaker.tools.ws.wsdl.WSDLException;
import com.wavemaker.tools.ws.wsdl.WSDLUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class WSDLManager {
    private static WSDLManager instance;
    private Map<String, WSDL> wsdlMap = new HashMap<String, WSDL>();

    private WSDLManager() {
    }

    public static synchronized WSDLManager getInstance() {
        if (instance == null) {
            instance = new WSDLManager();
        }
        return instance;
    }

    public WSDL registerWSDL(String wsdlURI, String serviceId) throws WSDLException {
        WSDL wsdl = WSDLManager.processWSDL(wsdlURI, serviceId);
        this.wsdlMap.put(wsdl.getServiceId(), wsdl);
        return wsdl;
    }

    public static WSDL processWSDL(String wsdlURI, String serviceId) throws WSDLException {
        if (wsdlURI == null) {
            throw new IllegalArgumentException(Resource.WS_NULL_WSDL_URI.getMessage());
        }
        WSDL wsdl = new WSDLBuilder(wsdlURI).buildWSDL(serviceId);
        if (wsdl.isRPC() && wsdl.isSOAPEncoded()) {
            throw new ConfigurationException(Resource.WS_RPC_ENCODED_NOT_SUPPORTED);
        }
        return wsdl;
    }

    public WSDL getWSDL(String serviceId) {
        return this.wsdlMap.get(serviceId);
    }

    public void removeWSDL(String serviceId) {
        this.wsdlMap.remove(serviceId);
    }

    public static void writeWSDL(WSDL wsdl, File file) throws WSDLException {
        WSDLUtils.writeDefinition(wsdl.getDefinition(), file);
    }

    public String[] getAllServiceIds() {
        return this.wsdlMap.keySet().toArray(new String[this.wsdlMap.size()]);
    }
}

