/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ws.wsdl;

import com.wavemaker.common.util.CastUtils;
import com.wavemaker.tools.ws.wsdl.WSDLException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLUtils {
    public static Definition readDefinition(String wsdlURI) throws WSDLException {
        try {
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.importDocuments", true);
            reader.setFeature("javax.wsdl.verbose", false);
            return reader.readWSDL(wsdlURI);
        }
        catch (javax.wsdl.WSDLException e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public static void writeDefinition(Definition definition, File wsdlFile) throws WSDLException {
        try {
            FileWriter out = new FileWriter(wsdlFile);
            WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
            writer.writeWSDL(definition, (Writer)out);
        }
        catch (javax.wsdl.WSDLException e) {
            throw new WSDLException(e);
        }
        catch (IOException e) {
            throw new WSDLException(e);
        }
    }

    public static String generateServiceName(Definition definition) {
        Set qnames = CastUtils.cast(definition.getServices().keySet());
        if (qnames.size() == 0) {
            qnames = CastUtils.cast(definition.getPortTypes().keySet());
        }
        if (qnames.size() > 0) {
            QName qname = (QName)qnames.iterator().next();
            return qname.getLocalPart();
        }
        return null;
    }

    private static <T extends ExtensibilityElement> T getExtensiblityElement(List<?> list, Class<T> clazz) {
        List<T> elements = WSDLUtils.getExtensiblityElements(list, clazz);
        return (T)(elements.isEmpty() ? null : (ExtensibilityElement)elements.get(0));
    }

    private static <T extends ExtensibilityElement> List<T> getExtensiblityElements(List<?> list, Class<T> clazz) {
        ArrayList<ExtensibilityElement> result = new ArrayList<ExtensibilityElement>();
        Iterator i = CastUtils.cast(list.iterator());
        while (i.hasNext()) {
            ExtensibilityElement elm = (ExtensibilityElement)i.next();
            if (!clazz.isAssignableFrom(elm.getClass())) continue;
            result.add(elm);
        }
        return result;
    }

    public static String getStyle(Binding binding) {
        SOAPBinding soapBinding = WSDLUtils.getExtensiblityElement(binding.getExtensibilityElements(), SOAPBinding.class);
        if (soapBinding != null) {
            return soapBinding.getStyle();
        }
        SOAP12Binding soap12Binding = WSDLUtils.getExtensiblityElement(binding.getExtensibilityElements(), SOAP12Binding.class);
        if (soap12Binding != null) {
            return soap12Binding.getStyle();
        }
        return null;
    }

    public static String getStyle(Definition definition) {
        Set bindings = CastUtils.cast(definition.getAllBindings().keySet());
        Iterator names = bindings.iterator();
        while (names.hasNext()) {
            Binding binding = definition.getBinding((QName)names.next());
            String style = WSDLUtils.getStyle(binding);
            if (style == null) continue;
            return style;
        }
        return null;
    }

    public static boolean isInputSOAPEncoded(BindingOperation bindingOperation) {
        SOAPBody soapBody = WSDLUtils.getExtensiblityElement(bindingOperation.getBindingInput().getExtensibilityElements(), SOAPBody.class);
        if (soapBody != null) {
            return soapBody.getUse() != null && soapBody.getUse().equalsIgnoreCase("encoded") && (soapBody.getEncodingStyles() == null || soapBody.getEncodingStyles().contains("http://schemas.xmlsoap.org/soap/encoding/"));
        }
        SOAP12Body soap12Body = WSDLUtils.getExtensiblityElement(bindingOperation.getBindingInput().getExtensibilityElements(), SOAP12Body.class);
        if (soap12Body != null) {
            return soap12Body.getUse() != null && soap12Body.getUse().equalsIgnoreCase("encoded") && (soap12Body.getEncodingStyle() == null || soap12Body.getEncodingStyle().equals("http://schemas.xmlsoap.org/soap/encoding/"));
        }
        return false;
    }

    public static boolean isSOAPEncoded(Definition definition) {
        Binding binding = WSDLUtils.getBindingForSOAP(definition, null);
        if (binding != null) {
            List bindingOperations = CastUtils.cast((List)binding.getBindingOperations(), BindingOperation.class);
            for (BindingOperation bindingOperation : bindingOperations) {
                if (!WSDLUtils.isInputSOAPEncoded(bindingOperation)) continue;
                return true;
            }
        }
        return false;
    }

    public static Binding getBindingForSOAP(Definition definition, Operation operation) {
        Set bindings = CastUtils.cast(definition.getAllBindings().keySet());
        Iterator names = bindings.iterator();
        while (names.hasNext()) {
            Binding binding = definition.getBinding((QName)names.next());
            PortType portType = binding.getPortType();
            if (operation != null && !WSDLUtils.contains(CastUtils.cast((List)portType.getOperations(), Operation.class), operation)) continue;
            SOAPBinding soapBinding = WSDLUtils.getExtensiblityElement(binding.getExtensibilityElements(), SOAPBinding.class);
            if (soapBinding != null) {
                return binding;
            }
            SOAP12Binding soap12Binding = WSDLUtils.getExtensiblityElement(binding.getExtensibilityElements(), SOAP12Binding.class);
            if (soap12Binding == null) continue;
            return binding;
        }
        return null;
    }

    private static boolean contains(List<Operation> operationList, Operation operation) {
        for (Operation op : operationList) {
            if (!op.getName().equals(operation.getName())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Element> getSchemaMap(Types types) {
        HashMap<String, Element> schemaMap = new HashMap<String, Element>();
        if (types != null) {
            Iterator iterator = CastUtils.cast(types.getExtensibilityElements().iterator());
            while (iterator.hasNext()) {
                Object extensibilityElement = iterator.next();
                if (!(extensibilityElement instanceof Schema)) continue;
                Element schemaElement = ((Schema)extensibilityElement).getElement();
                schemaMap.put(schemaElement.getAttribute("targetNamespace"), schemaElement);
            }
        }
        return schemaMap;
    }

    private static List<SoapHeader> getSoapHeaders(List<?> list) {
        ArrayList<SoapHeader> result;
        block3: {
            block2: {
                result = new ArrayList<SoapHeader>();
                List<SOAPHeader> soapHeaders = WSDLUtils.getExtensiblityElements(list, SOAPHeader.class);
                if (soapHeaders == null || soapHeaders.isEmpty()) break block2;
                for (SOAPHeader header : soapHeaders) {
                    result.add(new Soap11Header(header));
                }
                break block3;
            }
            List<SOAP12Header> soap12Headers = WSDLUtils.getExtensiblityElements(list, SOAP12Header.class);
            if (soap12Headers == null || soap12Headers.isEmpty()) break block3;
            for (SOAP12Header header : soap12Headers) {
                result.add(new Soap12Header(header));
            }
        }
        return result;
    }

    public static List<SoapHeader> getInputSoapHeaders(Definition definition, Operation operation) {
        Binding binding = WSDLUtils.getBindingForSOAP(definition, operation);
        BindingOperation bindingOperation = operation.getStyle().equals(OperationType.ONE_WAY) ? binding.getBindingOperation(operation.getName(), operation.getInput().getName(), null) : binding.getBindingOperation(operation.getName(), operation.getInput().getName(), operation.getOutput().getName());
        if (bindingOperation == null) {
            bindingOperation = binding.getBindingOperation(operation.getName(), null, null);
        }
        return WSDLUtils.getSoapHeaders(bindingOperation.getBindingInput().getExtensibilityElements());
    }

    private static List<Part> getFaultParts(BindingOperation bindingOperation, String faultName) {
        ArrayList<Part> result = new ArrayList<Part>();
        BindingFault bindingFault = bindingOperation.getBindingFault(faultName);
        SOAPFault soapFault = WSDLUtils.getExtensiblityElement(bindingFault.getExtensibilityElements(), SOAPFault.class);
        if (soapFault != null && soapFault.getName() != null) {
            List plist = CastUtils.cast((List)bindingOperation.getOperation().getFault(soapFault.getName()).getMessage().getOrderedParts(null));
            result.addAll(plist);
        } else {
            SOAP12Fault soap12Fault = WSDLUtils.getExtensiblityElement(bindingFault.getExtensibilityElements(), SOAP12Fault.class);
            if (soap12Fault != null && soap12Fault.getName() != null) {
                List plist = CastUtils.cast((List)bindingOperation.getOperation().getFault(soap12Fault.getName()).getMessage().getOrderedParts(null));
                result.addAll(plist);
            } else {
                List plist = CastUtils.cast((List)bindingOperation.getOperation().getFault(faultName).getMessage().getOrderedParts(null));
                result.addAll(plist);
            }
        }
        return result;
    }

    public static List<Part> getFaults(Definition definition, Operation operation) {
        Binding binding = WSDLUtils.getBindingForSOAP(definition, operation);
        BindingOperation bindingOperation = operation.getStyle().equals(OperationType.ONE_WAY) ? binding.getBindingOperation(operation.getName(), operation.getInput().getName(), null) : binding.getBindingOperation(operation.getName(), operation.getInput().getName(), operation.getOutput().getName());
        if (bindingOperation == null) {
            bindingOperation = binding.getBindingOperation(operation.getName(), null, null);
        }
        Iterator iter = CastUtils.cast(bindingOperation.getBindingFaults().keySet().iterator());
        ArrayList<Part> results = new ArrayList<Part>();
        while (iter.hasNext()) {
            List<Part> faultParts = WSDLUtils.getFaultParts(bindingOperation, (String)iter.next());
            results.addAll(faultParts);
        }
        return results;
    }

    public static SoapAddress getSoapAddress(Port port) {
        SOAPAddress soapAddress = WSDLUtils.getExtensiblityElement(port.getExtensibilityElements(), SOAPAddress.class);
        if (soapAddress != null) {
            return new Soap11Address(soapAddress);
        }
        SOAP12Address soap12Address = WSDLUtils.getExtensiblityElement(port.getExtensibilityElements(), SOAP12Address.class);
        if (soap12Address != null) {
            return new Soap12Address(soap12Address);
        }
        return null;
    }

    public static class Soap12Address
    implements SoapAddress {
        private final SOAP12Address soap12Address;

        public Soap12Address(SOAP12Address soap12Address) {
            this.soap12Address = soap12Address;
        }

        public String getLocationURI() {
            return this.soap12Address.getLocationURI();
        }
    }

    public static class Soap11Address
    implements SoapAddress {
        private final SOAPAddress soapAddress;

        public Soap11Address(SOAPAddress soapAddress) {
            this.soapAddress = soapAddress;
        }

        public String getLocationURI() {
            return this.soapAddress.getLocationURI();
        }
    }

    public static interface SoapAddress {
        public String getLocationURI();
    }

    public static class Soap12Header
    implements SoapHeader {
        private final SOAP12Header soapHeader;

        public Soap12Header(SOAP12Header soapHeader) {
            this.soapHeader = soapHeader;
        }

        public QName getMessage() {
            return this.soapHeader.getMessage();
        }

        public String getPart() {
            return this.soapHeader.getPart();
        }
    }

    public static class Soap11Header
    implements SoapHeader {
        private final SOAPHeader soapHeader;

        public Soap11Header(SOAPHeader soapHeader) {
            this.soapHeader = soapHeader;
        }

        public QName getMessage() {
            return this.soapHeader.getMessage();
        }

        public String getPart() {
            return this.soapHeader.getPart();
        }
    }

    public static interface SoapHeader {
        public QName getMessage();

        public String getPart();
    }
}

