/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ec2;

import com.amazonaws.ec2.AmazonEC2;
import com.amazonaws.ec2.AmazonEC2Config;
import com.amazonaws.ec2.AmazonEC2Exception;
import com.amazonaws.ec2.model.AllocateAddressRequest;
import com.amazonaws.ec2.model.AllocateAddressResponse;
import com.amazonaws.ec2.model.AssociateAddressRequest;
import com.amazonaws.ec2.model.AssociateAddressResponse;
import com.amazonaws.ec2.model.AttachVolumeRequest;
import com.amazonaws.ec2.model.AttachVolumeResponse;
import com.amazonaws.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.ec2.model.AuthorizeSecurityGroupIngressResponse;
import com.amazonaws.ec2.model.BlockDeviceMapping;
import com.amazonaws.ec2.model.BundleInstanceRequest;
import com.amazonaws.ec2.model.BundleInstanceResponse;
import com.amazonaws.ec2.model.CancelBundleTaskRequest;
import com.amazonaws.ec2.model.CancelBundleTaskResponse;
import com.amazonaws.ec2.model.ConfirmProductInstanceRequest;
import com.amazonaws.ec2.model.ConfirmProductInstanceResponse;
import com.amazonaws.ec2.model.CreateKeyPairRequest;
import com.amazonaws.ec2.model.CreateKeyPairResponse;
import com.amazonaws.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.ec2.model.CreateSecurityGroupResponse;
import com.amazonaws.ec2.model.CreateSnapshotRequest;
import com.amazonaws.ec2.model.CreateSnapshotResponse;
import com.amazonaws.ec2.model.CreateVolumeRequest;
import com.amazonaws.ec2.model.CreateVolumeResponse;
import com.amazonaws.ec2.model.DeleteKeyPairRequest;
import com.amazonaws.ec2.model.DeleteKeyPairResponse;
import com.amazonaws.ec2.model.DeleteSecurityGroupRequest;
import com.amazonaws.ec2.model.DeleteSecurityGroupResponse;
import com.amazonaws.ec2.model.DeleteSnapshotRequest;
import com.amazonaws.ec2.model.DeleteSnapshotResponse;
import com.amazonaws.ec2.model.DeleteVolumeRequest;
import com.amazonaws.ec2.model.DeleteVolumeResponse;
import com.amazonaws.ec2.model.DeregisterImageRequest;
import com.amazonaws.ec2.model.DeregisterImageResponse;
import com.amazonaws.ec2.model.DescribeAddressesRequest;
import com.amazonaws.ec2.model.DescribeAddressesResponse;
import com.amazonaws.ec2.model.DescribeAvailabilityZonesRequest;
import com.amazonaws.ec2.model.DescribeAvailabilityZonesResponse;
import com.amazonaws.ec2.model.DescribeBundleTasksRequest;
import com.amazonaws.ec2.model.DescribeBundleTasksResponse;
import com.amazonaws.ec2.model.DescribeImageAttributeRequest;
import com.amazonaws.ec2.model.DescribeImageAttributeResponse;
import com.amazonaws.ec2.model.DescribeImagesRequest;
import com.amazonaws.ec2.model.DescribeImagesResponse;
import com.amazonaws.ec2.model.DescribeInstancesRequest;
import com.amazonaws.ec2.model.DescribeInstancesResponse;
import com.amazonaws.ec2.model.DescribeKeyPairsRequest;
import com.amazonaws.ec2.model.DescribeKeyPairsResponse;
import com.amazonaws.ec2.model.DescribeRegionsRequest;
import com.amazonaws.ec2.model.DescribeRegionsResponse;
import com.amazonaws.ec2.model.DescribeReservedInstancesOfferingsRequest;
import com.amazonaws.ec2.model.DescribeReservedInstancesOfferingsResponse;
import com.amazonaws.ec2.model.DescribeReservedInstancesRequest;
import com.amazonaws.ec2.model.DescribeReservedInstancesResponse;
import com.amazonaws.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.ec2.model.DescribeSecurityGroupsResponse;
import com.amazonaws.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.ec2.model.DescribeSnapshotsResponse;
import com.amazonaws.ec2.model.DescribeVolumesRequest;
import com.amazonaws.ec2.model.DescribeVolumesResponse;
import com.amazonaws.ec2.model.DetachVolumeRequest;
import com.amazonaws.ec2.model.DetachVolumeResponse;
import com.amazonaws.ec2.model.DisassociateAddressRequest;
import com.amazonaws.ec2.model.DisassociateAddressResponse;
import com.amazonaws.ec2.model.Error;
import com.amazonaws.ec2.model.ErrorResponse;
import com.amazonaws.ec2.model.GetConsoleOutputRequest;
import com.amazonaws.ec2.model.GetConsoleOutputResponse;
import com.amazonaws.ec2.model.ModifyImageAttributeRequest;
import com.amazonaws.ec2.model.ModifyImageAttributeResponse;
import com.amazonaws.ec2.model.MonitorInstancesRequest;
import com.amazonaws.ec2.model.MonitorInstancesResponse;
import com.amazonaws.ec2.model.Placement;
import com.amazonaws.ec2.model.PurchaseReservedInstancesOfferingRequest;
import com.amazonaws.ec2.model.PurchaseReservedInstancesOfferingResponse;
import com.amazonaws.ec2.model.RebootInstancesRequest;
import com.amazonaws.ec2.model.RebootInstancesResponse;
import com.amazonaws.ec2.model.RegisterImageRequest;
import com.amazonaws.ec2.model.RegisterImageResponse;
import com.amazonaws.ec2.model.ReleaseAddressRequest;
import com.amazonaws.ec2.model.ReleaseAddressResponse;
import com.amazonaws.ec2.model.ResetImageAttributeRequest;
import com.amazonaws.ec2.model.ResetImageAttributeResponse;
import com.amazonaws.ec2.model.RevokeSecurityGroupIngressRequest;
import com.amazonaws.ec2.model.RevokeSecurityGroupIngressResponse;
import com.amazonaws.ec2.model.RunInstancesRequest;
import com.amazonaws.ec2.model.RunInstancesResponse;
import com.amazonaws.ec2.model.S3Storage;
import com.amazonaws.ec2.model.Storage;
import com.amazonaws.ec2.model.TerminateInstancesRequest;
import com.amazonaws.ec2.model.TerminateInstancesResponse;
import com.amazonaws.ec2.model.UnmonitorInstancesRequest;
import com.amazonaws.ec2.model.UnmonitorInstancesResponse;
import com.amazonaws.ec2.util.S3UploadPolicy;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonEC2Client
implements AmazonEC2 {
    private final Log log = LogFactory.getLog(AmazonEC2Client.class);
    private String awsAccessKeyId = null;
    private String awsSecretAccessKey = null;
    private AmazonEC2Config config = null;
    private HttpClient httpClient = null;
    private static JAXBContext jaxbContext;
    private static ThreadLocal<Unmarshaller> unmarshaller;
    private static Pattern ERROR_PATTERN_ONE;
    private static Pattern ERROR_PATTERN_TWO;
    private static String DEFAULT_ENCODING;

    public AmazonEC2Client(String string, String string2) {
        this(string, string2, new AmazonEC2Config());
    }

    public AmazonEC2Client(String string, String string2, AmazonEC2Config amazonEC2Config) {
        this.awsAccessKeyId = string;
        this.awsSecretAccessKey = string2;
        this.config = amazonEC2Config;
        this.httpClient = this.configureHttpClient();
    }

    @Override
    public AllocateAddressResponse allocateAddress(AllocateAddressRequest allocateAddressRequest) throws AmazonEC2Exception {
        return this.invoke(AllocateAddressResponse.class, this.convertAllocateAddress(allocateAddressRequest));
    }

    @Override
    public AssociateAddressResponse associateAddress(AssociateAddressRequest associateAddressRequest) throws AmazonEC2Exception {
        return this.invoke(AssociateAddressResponse.class, this.convertAssociateAddress(associateAddressRequest));
    }

    @Override
    public AttachVolumeResponse attachVolume(AttachVolumeRequest attachVolumeRequest) throws AmazonEC2Exception {
        return this.invoke(AttachVolumeResponse.class, this.convertAttachVolume(attachVolumeRequest));
    }

    @Override
    public AuthorizeSecurityGroupIngressResponse authorizeSecurityGroupIngress(AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) throws AmazonEC2Exception {
        return this.invoke(AuthorizeSecurityGroupIngressResponse.class, this.convertAuthorizeSecurityGroupIngress(authorizeSecurityGroupIngressRequest));
    }

    @Override
    public BundleInstanceResponse bundleInstance(BundleInstanceRequest bundleInstanceRequest) throws AmazonEC2Exception {
        S3Storage s3Storage;
        Storage storage = bundleInstanceRequest.getStorage();
        if (storage != null && !(s3Storage = storage.getS3()).isSetUploadPolicy()) {
            s3Storage.setAWSAccessKeyId(this.awsAccessKeyId);
            S3UploadPolicy s3UploadPolicy = new S3UploadPolicy(this.awsAccessKeyId, this.awsSecretAccessKey, s3Storage.getBucket(), s3Storage.getPrefix(), 1440);
            s3Storage.setUploadPolicy(s3UploadPolicy.getPolicyString());
            s3Storage.setUploadPolicySignature(s3UploadPolicy.getPolicySignature());
        }
        return this.invoke(BundleInstanceResponse.class, this.convertBundleInstance(bundleInstanceRequest));
    }

    @Override
    public CancelBundleTaskResponse cancelBundleTask(CancelBundleTaskRequest cancelBundleTaskRequest) throws AmazonEC2Exception {
        return this.invoke(CancelBundleTaskResponse.class, this.convertCancelBundleTask(cancelBundleTaskRequest));
    }

    @Override
    public ConfirmProductInstanceResponse confirmProductInstance(ConfirmProductInstanceRequest confirmProductInstanceRequest) throws AmazonEC2Exception {
        return this.invoke(ConfirmProductInstanceResponse.class, this.convertConfirmProductInstance(confirmProductInstanceRequest));
    }

    @Override
    public CreateKeyPairResponse createKeyPair(CreateKeyPairRequest createKeyPairRequest) throws AmazonEC2Exception {
        return this.invoke(CreateKeyPairResponse.class, this.convertCreateKeyPair(createKeyPairRequest));
    }

    @Override
    public CreateSecurityGroupResponse createSecurityGroup(CreateSecurityGroupRequest createSecurityGroupRequest) throws AmazonEC2Exception {
        return this.invoke(CreateSecurityGroupResponse.class, this.convertCreateSecurityGroup(createSecurityGroupRequest));
    }

    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws AmazonEC2Exception {
        return this.invoke(CreateSnapshotResponse.class, this.convertCreateSnapshot(createSnapshotRequest));
    }

    @Override
    public CreateVolumeResponse createVolume(CreateVolumeRequest createVolumeRequest) throws AmazonEC2Exception {
        return this.invoke(CreateVolumeResponse.class, this.convertCreateVolume(createVolumeRequest));
    }

    @Override
    public DeleteKeyPairResponse deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) throws AmazonEC2Exception {
        return this.invoke(DeleteKeyPairResponse.class, this.convertDeleteKeyPair(deleteKeyPairRequest));
    }

    @Override
    public DeleteSecurityGroupResponse deleteSecurityGroup(DeleteSecurityGroupRequest deleteSecurityGroupRequest) throws AmazonEC2Exception {
        return this.invoke(DeleteSecurityGroupResponse.class, this.convertDeleteSecurityGroup(deleteSecurityGroupRequest));
    }

    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws AmazonEC2Exception {
        return this.invoke(DeleteSnapshotResponse.class, this.convertDeleteSnapshot(deleteSnapshotRequest));
    }

    @Override
    public DeleteVolumeResponse deleteVolume(DeleteVolumeRequest deleteVolumeRequest) throws AmazonEC2Exception {
        return this.invoke(DeleteVolumeResponse.class, this.convertDeleteVolume(deleteVolumeRequest));
    }

    @Override
    public DeregisterImageResponse deregisterImage(DeregisterImageRequest deregisterImageRequest) throws AmazonEC2Exception {
        return this.invoke(DeregisterImageResponse.class, this.convertDeregisterImage(deregisterImageRequest));
    }

    @Override
    public DescribeAddressesResponse describeAddresses(DescribeAddressesRequest describeAddressesRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeAddressesResponse.class, this.convertDescribeAddresses(describeAddressesRequest));
    }

    @Override
    public DescribeAvailabilityZonesResponse describeAvailabilityZones(DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeAvailabilityZonesResponse.class, this.convertDescribeAvailabilityZones(describeAvailabilityZonesRequest));
    }

    @Override
    public DescribeBundleTasksResponse describeBundleTasks(DescribeBundleTasksRequest describeBundleTasksRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeBundleTasksResponse.class, this.convertDescribeBundleTasks(describeBundleTasksRequest));
    }

    @Override
    public DescribeImageAttributeResponse describeImageAttribute(DescribeImageAttributeRequest describeImageAttributeRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeImageAttributeResponse.class, this.convertDescribeImageAttribute(describeImageAttributeRequest));
    }

    @Override
    public DescribeImagesResponse describeImages(DescribeImagesRequest describeImagesRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeImagesResponse.class, this.convertDescribeImages(describeImagesRequest));
    }

    @Override
    public DescribeInstancesResponse describeInstances(DescribeInstancesRequest describeInstancesRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeInstancesResponse.class, this.convertDescribeInstances(describeInstancesRequest));
    }

    @Override
    public DescribeRegionsResponse describeRegions(DescribeRegionsRequest describeRegionsRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeRegionsResponse.class, this.convertDescribeRegions(describeRegionsRequest));
    }

    @Override
    public DescribeReservedInstancesResponse describeReservedInstances(DescribeReservedInstancesRequest describeReservedInstancesRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeReservedInstancesResponse.class, this.convertDescribeReservedInstances(describeReservedInstancesRequest));
    }

    @Override
    public DescribeReservedInstancesOfferingsResponse describeReservedInstancesOfferings(DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeReservedInstancesOfferingsResponse.class, this.convertDescribeReservedInstancesOfferings(describeReservedInstancesOfferingsRequest));
    }

    @Override
    public DescribeKeyPairsResponse describeKeyPairs(DescribeKeyPairsRequest describeKeyPairsRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeKeyPairsResponse.class, this.convertDescribeKeyPairs(describeKeyPairsRequest));
    }

    @Override
    public DescribeSecurityGroupsResponse describeSecurityGroups(DescribeSecurityGroupsRequest describeSecurityGroupsRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeSecurityGroupsResponse.class, this.convertDescribeSecurityGroups(describeSecurityGroupsRequest));
    }

    @Override
    public DescribeSnapshotsResponse describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeSnapshotsResponse.class, this.convertDescribeSnapshots(describeSnapshotsRequest));
    }

    @Override
    public DescribeVolumesResponse describeVolumes(DescribeVolumesRequest describeVolumesRequest) throws AmazonEC2Exception {
        return this.invoke(DescribeVolumesResponse.class, this.convertDescribeVolumes(describeVolumesRequest));
    }

    @Override
    public DetachVolumeResponse detachVolume(DetachVolumeRequest detachVolumeRequest) throws AmazonEC2Exception {
        return this.invoke(DetachVolumeResponse.class, this.convertDetachVolume(detachVolumeRequest));
    }

    @Override
    public DisassociateAddressResponse disassociateAddress(DisassociateAddressRequest disassociateAddressRequest) throws AmazonEC2Exception {
        return this.invoke(DisassociateAddressResponse.class, this.convertDisassociateAddress(disassociateAddressRequest));
    }

    @Override
    public GetConsoleOutputResponse getConsoleOutput(GetConsoleOutputRequest getConsoleOutputRequest) throws AmazonEC2Exception {
        return this.invoke(GetConsoleOutputResponse.class, this.convertGetConsoleOutput(getConsoleOutputRequest));
    }

    @Override
    public ModifyImageAttributeResponse modifyImageAttribute(ModifyImageAttributeRequest modifyImageAttributeRequest) throws AmazonEC2Exception {
        return this.invoke(ModifyImageAttributeResponse.class, this.convertModifyImageAttribute(modifyImageAttributeRequest));
    }

    @Override
    public PurchaseReservedInstancesOfferingResponse purchaseReservedInstancesOffering(PurchaseReservedInstancesOfferingRequest purchaseReservedInstancesOfferingRequest) throws AmazonEC2Exception {
        return this.invoke(PurchaseReservedInstancesOfferingResponse.class, this.convertPurchaseReservedInstancesOffering(purchaseReservedInstancesOfferingRequest));
    }

    @Override
    public RebootInstancesResponse rebootInstances(RebootInstancesRequest rebootInstancesRequest) throws AmazonEC2Exception {
        return this.invoke(RebootInstancesResponse.class, this.convertRebootInstances(rebootInstancesRequest));
    }

    @Override
    public RegisterImageResponse registerImage(RegisterImageRequest registerImageRequest) throws AmazonEC2Exception {
        return this.invoke(RegisterImageResponse.class, this.convertRegisterImage(registerImageRequest));
    }

    @Override
    public ReleaseAddressResponse releaseAddress(ReleaseAddressRequest releaseAddressRequest) throws AmazonEC2Exception {
        return this.invoke(ReleaseAddressResponse.class, this.convertReleaseAddress(releaseAddressRequest));
    }

    @Override
    public ResetImageAttributeResponse resetImageAttribute(ResetImageAttributeRequest resetImageAttributeRequest) throws AmazonEC2Exception {
        return this.invoke(ResetImageAttributeResponse.class, this.convertResetImageAttribute(resetImageAttributeRequest));
    }

    @Override
    public RevokeSecurityGroupIngressResponse revokeSecurityGroupIngress(RevokeSecurityGroupIngressRequest revokeSecurityGroupIngressRequest) throws AmazonEC2Exception {
        return this.invoke(RevokeSecurityGroupIngressResponse.class, this.convertRevokeSecurityGroupIngress(revokeSecurityGroupIngressRequest));
    }

    @Override
    public RunInstancesResponse runInstances(RunInstancesRequest runInstancesRequest) throws AmazonEC2Exception {
        return this.invoke(RunInstancesResponse.class, this.convertRunInstances(runInstancesRequest));
    }

    @Override
    public TerminateInstancesResponse terminateInstances(TerminateInstancesRequest terminateInstancesRequest) throws AmazonEC2Exception {
        return this.invoke(TerminateInstancesResponse.class, this.convertTerminateInstances(terminateInstancesRequest));
    }

    @Override
    public MonitorInstancesResponse monitorInstances(MonitorInstancesRequest monitorInstancesRequest) throws AmazonEC2Exception {
        return this.invoke(MonitorInstancesResponse.class, this.convertMonitorInstances(monitorInstancesRequest));
    }

    @Override
    public UnmonitorInstancesResponse unmonitorInstances(UnmonitorInstancesRequest unmonitorInstancesRequest) throws AmazonEC2Exception {
        return this.invoke(UnmonitorInstancesResponse.class, this.convertUnmonitorInstances(unmonitorInstancesRequest));
    }

    private HttpClient configureHttpClient() {
        HttpClientParams httpClientParams = new HttpClientParams();
        httpClientParams.setParameter("http.useragent", (Object)this.config.getUserAgent());
        httpClientParams.setParameter("http.method.retry-handler", (Object)new HttpMethodRetryHandler(){

            public boolean retryMethod(HttpMethod httpMethod, IOException iOException, int n) {
                if (n > 3) {
                    AmazonEC2Client.this.log.debug((Object)"Maximum Number of Retry attempts reached, will not retry");
                    return false;
                }
                AmazonEC2Client.this.log.debug((Object)("Retrying request. Attempt " + n));
                if (iOException instanceof NoHttpResponseException) {
                    AmazonEC2Client.this.log.debug((Object)"Retrying on NoHttpResponseException");
                    return true;
                }
                if (iOException instanceof InterruptedIOException) {
                    AmazonEC2Client.this.log.debug((Object)"Will not retry on InterruptedIOException", (Throwable)iOException);
                    return false;
                }
                if (iOException instanceof UnknownHostException) {
                    AmazonEC2Client.this.log.debug((Object)"Will not retry on UnknownHostException", (Throwable)iOException);
                    return false;
                }
                if (!httpMethod.isRequestSent()) {
                    AmazonEC2Client.this.log.debug((Object)"Retrying on failed sent request");
                    return true;
                }
                return false;
            }
        });
        HostConfiguration hostConfiguration = new HostConfiguration();
        HttpConnectionManagerParams httpConnectionManagerParams = new HttpConnectionManagerParams();
        httpConnectionManagerParams.setConnectionTimeout(50000);
        httpConnectionManagerParams.setSoTimeout(50000);
        httpConnectionManagerParams.setStaleCheckingEnabled(true);
        httpConnectionManagerParams.setTcpNoDelay(true);
        httpConnectionManagerParams.setMaxTotalConnections(this.config.getMaxConnections());
        httpConnectionManagerParams.setMaxConnectionsPerHost(hostConfiguration, this.config.getMaxConnections());
        MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        multiThreadedHttpConnectionManager.setParams(httpConnectionManagerParams);
        this.httpClient = new HttpClient(httpClientParams, (HttpConnectionManager)multiThreadedHttpConnectionManager);
        if (this.config.isSetProxyHost() && this.config.isSetProxyPort()) {
            this.log.info((Object)("Configuring Proxy. Proxy Host: " + this.config.getProxyHost() + "Proxy Port: " + this.config.getProxyPort()));
            hostConfiguration.setProxy(this.config.getProxyHost(), this.config.getProxyPort());
            if (this.config.isSetProxyUsername() && this.config.isSetProxyPassword()) {
                this.httpClient.getState().setProxyCredentials(new AuthScope(this.config.getProxyHost(), this.config.getProxyPort()), (Credentials)new UsernamePasswordCredentials(this.config.getProxyUsername(), this.config.getProxyPassword()));
            }
        }
        this.httpClient.setHostConfiguration(hostConfiguration);
        return this.httpClient;
    }

    private <T> T invoke(Class<T> clazz, Map<String, String> map) throws AmazonEC2Exception {
        String string = map.get("Action");
        T t = null;
        String string2 = null;
        PostMethod postMethod = new PostMethod(this.config.getServiceURL());
        int n = -1;
        this.log.debug((Object)("Invoking" + string + " request. Current parameters: " + map));
        try {
            this.log.debug((Object)("Setting content-type to application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase()));
            postMethod.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase());
            this.log.debug((Object)"Adding required parameters...");
            this.addRequiredParametersToRequest(postMethod, map);
            this.log.debug((Object)("Done adding additional required parameteres. Parameters now: " + map));
            boolean bl = true;
            int n2 = 0;
            do {
                this.log.debug((Object)("Sending Request to host:  " + this.config.getServiceURL()));
                try {
                    n = this.httpClient.executeMethod((HttpMethod)postMethod);
                    string2 = this.getResponsBodyAsString(postMethod.getResponseBodyAsStream());
                    if (n == 200) {
                        bl = false;
                        this.log.debug((Object)("Received Response. Status: " + n + ". " + "Response Body: " + string2));
                        if (string2.endsWith(string + "Response>")) {
                            string2.replace("<?xml version=\"1.0\"?>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                            this.log.debug((Object)("Attempting to transform " + string + "Response type..."));
                            string2 = ResponseTransformer.transform(string2, string);
                            this.log.debug((Object)("Transformed response to: " + string2));
                        }
                        this.log.debug((Object)("Attempting to unmarshal into the " + string + "Response type..."));
                        t = clazz.cast(this.getUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(string2))));
                        this.log.debug((Object)("Unmarshalled response into " + string + "Response type."));
                        continue;
                    }
                    this.log.debug((Object)("Received Response. Status: " + n + ". " + "Response Body: " + string2));
                    if ((n == 500 || n == 503) && this.pauseIfRetryNeeded(++n2)) {
                        bl = true;
                        continue;
                    }
                    this.log.debug((Object)"Attempting to unmarshal into the ErrorResponse type...");
                    ErrorResponse errorResponse = (ErrorResponse)this.getUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(string2)));
                    this.log.debug((Object)"Unmarshalled response into the ErrorResponse type.");
                    Error error = errorResponse.getError().get(0);
                    throw new AmazonEC2Exception(error.getMessage(), n, error.getCode(), error.getType(), errorResponse.getRequestId(), errorResponse.toXML());
                }
                catch (JAXBException jAXBException) {
                    this.log.debug((Object)"Caught JAXBException", (Throwable)jAXBException);
                    this.log.debug((Object)("Response cannot be unmarshalled neither as " + string + "Response or ErrorResponse types." + "Checking for other possible errors."));
                    AmazonEC2Exception amazonEC2Exception = this.processErrors(string2, n);
                    throw amazonEC2Exception;
                }
                catch (IOException iOException) {
                    this.log.error((Object)"Caught IOException exception", (Throwable)iOException);
                    throw new AmazonEC2Exception("Internal Error", iOException);
                }
                catch (Exception exception) {
                    this.log.error((Object)"Caught Exception", (Throwable)exception);
                    throw new AmazonEC2Exception(exception);
                }
                finally {
                    postMethod.releaseConnection();
                }
            } while (bl);
        }
        catch (AmazonEC2Exception amazonEC2Exception) {
            this.log.error((Object)"Caught AmazonEC2Exception", (Throwable)amazonEC2Exception);
            throw amazonEC2Exception;
        }
        catch (Throwable throwable) {
            this.log.error((Object)"Caught Exception", throwable);
            throw new AmazonEC2Exception(throwable);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponsBodyAsString(InputStream inputStream) throws IOException {
        String string = null;
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, DEFAULT_ENCODING);
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[1024];
            while (0 < (n = inputStreamReader.read(cArray))) {
                stringBuilder.append(cArray, 0, n);
            }
            string = stringBuilder.toString();
        }
        finally {
            inputStream.close();
        }
        return string;
    }

    private boolean pauseIfRetryNeeded(int n) throws InterruptedException {
        if (n <= this.config.getMaxErrorRetry()) {
            long l = (long)(Math.pow(4.0, n) * 100.0);
            this.log.debug((Object)("Retriable error detected, will retry in " + l + "ms, attempt numer: " + n));
            Thread.sleep(l);
            return true;
        }
        return false;
    }

    private void addRequiredParametersToRequest(PostMethod postMethod, Map<String, String> map) throws SignatureException {
        map.put("Version", this.config.getServiceVersion());
        map.put("SignatureVersion", this.config.getSignatureVersion());
        map.put("Timestamp", this.getFormattedTimestamp());
        map.put("AWSAccessKeyId", this.awsAccessKeyId);
        map.put("Signature", this.signParameters(map, this.awsSecretAccessKey));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            postMethod.addParameter(entry.getKey(), entry.getValue());
        }
    }

    private AmazonEC2Exception processErrors(String string, int n) {
        AmazonEC2Exception amazonEC2Exception = null;
        Matcher matcher = null;
        if (string != null && string.startsWith("<")) {
            matcher = ERROR_PATTERN_ONE.matcher(string);
            if (matcher.matches()) {
                amazonEC2Exception = new AmazonEC2Exception(matcher.group(3), n, matcher.group(2), "Unknown", matcher.group(1), string);
            } else {
                matcher = ERROR_PATTERN_TWO.matcher(string);
                if (matcher.matches()) {
                    amazonEC2Exception = new AmazonEC2Exception(matcher.group(2), n, matcher.group(1), "Unknown", matcher.group(4), string);
                } else {
                    amazonEC2Exception = new AmazonEC2Exception("Internal Error", n);
                    this.log.error((Object)("Service Error. Response Status: " + n));
                }
            }
        } else {
            amazonEC2Exception = new AmazonEC2Exception("Internal Error", n);
            this.log.error((Object)("Service Error. Response Status: " + n));
        }
        return amazonEC2Exception;
    }

    private String getFormattedTimestamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(new Date());
    }

    private String signParameters(Map<String, String> map, String string) throws SignatureException {
        String string2 = map.get("SignatureVersion");
        String string3 = "HmacSHA1";
        String string4 = null;
        if ("0".equals(string2)) {
            string4 = this.calculateStringToSignV0(map);
        } else if ("1".equals(string2)) {
            string4 = this.calculateStringToSignV1(map);
        } else if ("2".equals(string2)) {
            string3 = this.config.getSignatureMethod();
            map.put("SignatureMethod", string3);
            string4 = this.calculateStringToSignV2(map);
        } else {
            throw new SignatureException("Invalid Signature Version specified");
        }
        this.log.debug((Object)("Calculated string to sign: " + string4));
        return this.sign(string4, string, string3);
    }

    private String calculateStringToSignV0(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(map.get("Action")).append(map.get("Timestamp"));
        return stringBuilder.toString();
    }

    private String calculateStringToSignV1(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        treeMap.putAll(map);
        for (Map.Entry entry : treeMap.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    private String calculateStringToSignV2(Map<String, String> map) throws SignatureException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("POST");
        stringBuilder.append("\n");
        URI uRI = null;
        try {
            uRI = new URI(this.config.getServiceURL().toLowerCase());
        }
        catch (URISyntaxException uRISyntaxException) {
            this.log.error((Object)"URI Syntax Exception", (Throwable)uRISyntaxException);
            throw new SignatureException("URI Syntax Exception thrown while constructing string to sign", uRISyntaxException);
        }
        stringBuilder.append(uRI.getHost());
        stringBuilder.append("\n");
        String string = uRI.getPath();
        if (string == null || string.length() == 0) {
            string = "/";
        }
        stringBuilder.append(this.urlEncode(string, true));
        stringBuilder.append("\n");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.putAll(map);
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            stringBuilder.append(this.urlEncode(string2, false));
            stringBuilder.append("=");
            String string3 = (String)entry.getValue();
            stringBuilder.append(this.urlEncode(string3, false));
            if (!iterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    private String urlEncode(String string, boolean bl) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, DEFAULT_ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            if (bl) {
                string2 = string2.replace("%2F", "/");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.log.error((Object)"Unsupported Encoding Exception", (Throwable)unsupportedEncodingException);
            throw new RuntimeException(unsupportedEncodingException);
        }
        return string2;
    }

    private String sign(String string, String string2, String string3) throws SignatureException {
        byte[] byArray;
        try {
            Mac mac = Mac.getInstance(string3);
            mac.init(new SecretKeySpec(string2.getBytes(), string3));
            byArray = Base64.encodeBase64((byte[])mac.doFinal(string.getBytes(DEFAULT_ENCODING)));
        }
        catch (Exception exception) {
            throw new SignatureException("Failed to generate signature: " + exception.getMessage(), exception);
        }
        return new String(byArray);
    }

    private Unmarshaller getUnmarshaller() {
        return unmarshaller.get();
    }

    private Map<String, String> convertAllocateAddress(AllocateAddressRequest allocateAddressRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "AllocateAddress");
        return hashMap;
    }

    private Map<String, String> convertAssociateAddress(AssociateAddressRequest associateAddressRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "AssociateAddress");
        if (associateAddressRequest.isSetInstanceId()) {
            hashMap.put("InstanceId", associateAddressRequest.getInstanceId());
        }
        if (associateAddressRequest.isSetPublicIp()) {
            hashMap.put("PublicIp", associateAddressRequest.getPublicIp());
        }
        return hashMap;
    }

    private Map<String, String> convertAuthorizeSecurityGroupIngress(AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "AuthorizeSecurityGroupIngress");
        if (authorizeSecurityGroupIngressRequest.isSetGroupName()) {
            hashMap.put("GroupName", authorizeSecurityGroupIngressRequest.getGroupName());
        }
        if (authorizeSecurityGroupIngressRequest.isSetSourceSecurityGroupName()) {
            hashMap.put("SourceSecurityGroupName", authorizeSecurityGroupIngressRequest.getSourceSecurityGroupName());
        }
        if (authorizeSecurityGroupIngressRequest.isSetSourceSecurityGroupOwnerId()) {
            hashMap.put("SourceSecurityGroupOwnerId", authorizeSecurityGroupIngressRequest.getSourceSecurityGroupOwnerId());
        }
        if (authorizeSecurityGroupIngressRequest.isSetIpProtocol()) {
            hashMap.put("IpProtocol", authorizeSecurityGroupIngressRequest.getIpProtocol());
        }
        if (authorizeSecurityGroupIngressRequest.isSetFromPort()) {
            hashMap.put("FromPort", authorizeSecurityGroupIngressRequest.getFromPort() + "");
        }
        if (authorizeSecurityGroupIngressRequest.isSetToPort()) {
            hashMap.put("ToPort", authorizeSecurityGroupIngressRequest.getToPort() + "");
        }
        if (authorizeSecurityGroupIngressRequest.isSetCidrIp()) {
            hashMap.put("CidrIp", authorizeSecurityGroupIngressRequest.getCidrIp());
        }
        return hashMap;
    }

    private Map<String, String> convertBundleInstance(BundleInstanceRequest bundleInstanceRequest) {
        Storage storage;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "BundleInstance");
        if (bundleInstanceRequest.isSetInstanceId()) {
            hashMap.put("InstanceId", bundleInstanceRequest.getInstanceId());
        }
        if (bundleInstanceRequest.isSetStorage() && (storage = bundleInstanceRequest.getStorage()).isSetS3()) {
            S3Storage s3Storage = storage.getS3();
            if (s3Storage.isSetBucket()) {
                hashMap.put("Storage.S3.Bucket", s3Storage.getBucket());
            }
            if (s3Storage.isSetPrefix()) {
                hashMap.put("Storage.S3.Prefix", s3Storage.getPrefix());
            }
            if (s3Storage.isSetAWSAccessKeyId()) {
                hashMap.put("Storage.S3.AWSAccessKeyId", s3Storage.getAWSAccessKeyId());
            }
            if (s3Storage.isSetUploadPolicy()) {
                hashMap.put("Storage.S3.UploadPolicy", s3Storage.getUploadPolicy());
            }
            if (s3Storage.isSetUploadPolicySignature()) {
                hashMap.put("Storage.S3.UploadPolicySignature", s3Storage.getUploadPolicySignature());
            }
        }
        return hashMap;
    }

    private Map<String, String> convertConfirmProductInstance(ConfirmProductInstanceRequest confirmProductInstanceRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "ConfirmProductInstance");
        if (confirmProductInstanceRequest.isSetProductCode()) {
            hashMap.put("ProductCode", confirmProductInstanceRequest.getProductCode());
        }
        if (confirmProductInstanceRequest.isSetInstanceId()) {
            hashMap.put("InstanceId", confirmProductInstanceRequest.getInstanceId());
        }
        return hashMap;
    }

    private Map<String, String> convertCancelBundleTask(CancelBundleTaskRequest cancelBundleTaskRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "CancelBundleTask");
        if (cancelBundleTaskRequest.isSetBundleId()) {
            hashMap.put("BundleId", cancelBundleTaskRequest.getBundleId());
        }
        return hashMap;
    }

    private Map<String, String> convertCreateKeyPair(CreateKeyPairRequest createKeyPairRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "CreateKeyPair");
        if (createKeyPairRequest.isSetKeyName()) {
            hashMap.put("KeyName", createKeyPairRequest.getKeyName());
        }
        return hashMap;
    }

    private Map<String, String> convertCreateSecurityGroup(CreateSecurityGroupRequest createSecurityGroupRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "CreateSecurityGroup");
        if (createSecurityGroupRequest.isSetGroupName()) {
            hashMap.put("GroupName", createSecurityGroupRequest.getGroupName());
        }
        if (createSecurityGroupRequest.isSetGroupDescription()) {
            hashMap.put("GroupDescription", createSecurityGroupRequest.getGroupDescription());
        }
        return hashMap;
    }

    private Map<String, String> convertDeleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DeleteKeyPair");
        if (deleteKeyPairRequest.isSetKeyName()) {
            hashMap.put("KeyName", deleteKeyPairRequest.getKeyName());
        }
        return hashMap;
    }

    private Map<String, String> convertDeleteSecurityGroup(DeleteSecurityGroupRequest deleteSecurityGroupRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DeleteSecurityGroup");
        if (deleteSecurityGroupRequest.isSetGroupName()) {
            hashMap.put("GroupName", deleteSecurityGroupRequest.getGroupName());
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeReservedInstancesOfferings(DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeReservedInstancesOfferings");
        List<String> list = describeReservedInstancesOfferingsRequest.getReservedInstancesId();
        int n = 1;
        for (String string : list) {
            hashMap.put("ReservedInstancesId." + n, string);
            ++n;
        }
        if (describeReservedInstancesOfferingsRequest.isSetInstanceType()) {
            hashMap.put("InstanceType", describeReservedInstancesOfferingsRequest.getInstanceType());
        }
        if (describeReservedInstancesOfferingsRequest.isSetAvailabilityZone()) {
            hashMap.put("AvailabilityZone", describeReservedInstancesOfferingsRequest.getAvailabilityZone());
        }
        if (describeReservedInstancesOfferingsRequest.isSetProductDescription()) {
            hashMap.put("ProductDescription", describeReservedInstancesOfferingsRequest.getProductDescription());
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeReservedInstances(DescribeReservedInstancesRequest describeReservedInstancesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeReservedInstances");
        List<String> list = describeReservedInstancesRequest.getReservedInstancesId();
        int n = 1;
        for (String string : list) {
            hashMap.put("ReservedInstancesId." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertPurchaseReservedInstancesOffering(PurchaseReservedInstancesOfferingRequest purchaseReservedInstancesOfferingRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "PurchaseReservedInstancesOffering");
        if (purchaseReservedInstancesOfferingRequest.isSetReservedInstancesOfferingId()) {
            hashMap.put("ReservedInstancesOfferingId", purchaseReservedInstancesOfferingRequest.getReservedInstancesOfferingId());
        }
        if (purchaseReservedInstancesOfferingRequest.isSetInstanceCount()) {
            hashMap.put("InstanceCount", purchaseReservedInstancesOfferingRequest.getInstanceCount());
        }
        return hashMap;
    }

    private Map<String, String> convertDeregisterImage(DeregisterImageRequest deregisterImageRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DeregisterImage");
        if (deregisterImageRequest.isSetImageId()) {
            hashMap.put("ImageId", deregisterImageRequest.getImageId());
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeAddresses(DescribeAddressesRequest describeAddressesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeAddresses");
        List<String> list = describeAddressesRequest.getPublicIp();
        int n = 1;
        for (String string : list) {
            hashMap.put("PublicIp." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeAvailabilityZones(DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeAvailabilityZones");
        List<String> list = describeAvailabilityZonesRequest.getZoneName();
        int n = 1;
        for (String string : list) {
            hashMap.put("ZoneName." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeBundleTasks(DescribeBundleTasksRequest describeBundleTasksRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeBundleTasks");
        List<String> list = describeBundleTasksRequest.getBundleId();
        int n = 1;
        for (String string : list) {
            hashMap.put("BundleId." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeImageAttribute(DescribeImageAttributeRequest describeImageAttributeRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeImageAttribute");
        if (describeImageAttributeRequest.isSetImageId()) {
            hashMap.put("ImageId", describeImageAttributeRequest.getImageId());
        }
        if (describeImageAttributeRequest.isSetAttribute()) {
            hashMap.put("Attribute", describeImageAttributeRequest.getAttribute());
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeImages(DescribeImagesRequest describeImagesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeImages");
        List<String> list = describeImagesRequest.getImageId();
        int n = 1;
        for (String string : list) {
            hashMap.put("ImageId." + n, string);
            ++n;
        }
        List<String> list2 = describeImagesRequest.getOwner();
        int n2 = 1;
        Object object = list2.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            hashMap.put("Owner." + n2, string);
            ++n2;
        }
        object = describeImagesRequest.getExecutableBy();
        int n3 = 1;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            hashMap.put("ExecutableBy." + n3, string);
            ++n3;
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeInstances(DescribeInstancesRequest describeInstancesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeInstances");
        List<String> list = describeInstancesRequest.getInstanceId();
        int n = 1;
        for (String string : list) {
            hashMap.put("InstanceId." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeKeyPairs(DescribeKeyPairsRequest describeKeyPairsRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeKeyPairs");
        List<String> list = describeKeyPairsRequest.getKeyName();
        int n = 1;
        for (String string : list) {
            hashMap.put("KeyName." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeSecurityGroups(DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeSecurityGroups");
        List<String> list = describeSecurityGroupsRequest.getGroupName();
        int n = 1;
        for (String string : list) {
            hashMap.put("GroupName." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertDisassociateAddress(DisassociateAddressRequest disassociateAddressRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DisassociateAddress");
        if (disassociateAddressRequest.isSetPublicIp()) {
            hashMap.put("PublicIp", disassociateAddressRequest.getPublicIp());
        }
        return hashMap;
    }

    private Map<String, String> convertGetConsoleOutput(GetConsoleOutputRequest getConsoleOutputRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "GetConsoleOutput");
        if (getConsoleOutputRequest.isSetInstanceId()) {
            hashMap.put("InstanceId", getConsoleOutputRequest.getInstanceId());
        }
        return hashMap;
    }

    private Map<String, String> convertModifyImageAttribute(ModifyImageAttributeRequest modifyImageAttributeRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "ModifyImageAttribute");
        if (modifyImageAttributeRequest.isSetImageId()) {
            hashMap.put("ImageId", modifyImageAttributeRequest.getImageId());
        }
        if (modifyImageAttributeRequest.isSetAttribute()) {
            hashMap.put("Attribute", modifyImageAttributeRequest.getAttribute());
        }
        if (modifyImageAttributeRequest.isSetOperationType()) {
            hashMap.put("OperationType", modifyImageAttributeRequest.getOperationType());
        }
        List<String> list = modifyImageAttributeRequest.getUserId();
        int n = 1;
        for (String string : list) {
            hashMap.put("UserId." + n, string);
            ++n;
        }
        List<String> list2 = modifyImageAttributeRequest.getUserGroup();
        int n2 = 1;
        Object object = list2.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            hashMap.put("UserGroup." + n2, string);
            ++n2;
        }
        object = modifyImageAttributeRequest.getProductCode();
        int n3 = 1;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            hashMap.put("ProductCode." + n3, string);
            ++n3;
        }
        return hashMap;
    }

    private Map<String, String> convertMonitorInstances(MonitorInstancesRequest monitorInstancesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "MonitorInstances");
        List<String> list = monitorInstancesRequest.getInstanceId();
        int n = 1;
        for (String string : list) {
            hashMap.put("InstanceId." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertUnmonitorInstances(UnmonitorInstancesRequest unmonitorInstancesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "UnmonitorInstances");
        List<String> list = unmonitorInstancesRequest.getInstanceId();
        int n = 1;
        for (String string : list) {
            hashMap.put("InstanceId." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertRebootInstances(RebootInstancesRequest rebootInstancesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "RebootInstances");
        List<String> list = rebootInstancesRequest.getInstanceId();
        int n = 1;
        for (String string : list) {
            hashMap.put("InstanceId." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertRegisterImage(RegisterImageRequest registerImageRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "RegisterImage");
        if (registerImageRequest.isSetImageLocation()) {
            hashMap.put("ImageLocation", registerImageRequest.getImageLocation());
        }
        return hashMap;
    }

    private Map<String, String> convertReleaseAddress(ReleaseAddressRequest releaseAddressRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "ReleaseAddress");
        if (releaseAddressRequest.isSetPublicIp()) {
            hashMap.put("PublicIp", releaseAddressRequest.getPublicIp());
        }
        return hashMap;
    }

    private Map<String, String> convertResetImageAttribute(ResetImageAttributeRequest resetImageAttributeRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "ResetImageAttribute");
        if (resetImageAttributeRequest.isSetImageId()) {
            hashMap.put("ImageId", resetImageAttributeRequest.getImageId());
        }
        if (resetImageAttributeRequest.isSetAttribute()) {
            hashMap.put("Attribute", resetImageAttributeRequest.getAttribute());
        }
        return hashMap;
    }

    private Map<String, String> convertRevokeSecurityGroupIngress(RevokeSecurityGroupIngressRequest revokeSecurityGroupIngressRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "RevokeSecurityGroupIngress");
        if (revokeSecurityGroupIngressRequest.isSetGroupName()) {
            hashMap.put("GroupName", revokeSecurityGroupIngressRequest.getGroupName());
        }
        if (revokeSecurityGroupIngressRequest.isSetSourceSecurityGroupName()) {
            hashMap.put("SourceSecurityGroupName", revokeSecurityGroupIngressRequest.getSourceSecurityGroupName());
        }
        if (revokeSecurityGroupIngressRequest.isSetSourceSecurityGroupOwnerId()) {
            hashMap.put("SourceSecurityGroupOwnerId", revokeSecurityGroupIngressRequest.getSourceSecurityGroupOwnerId());
        }
        if (revokeSecurityGroupIngressRequest.isSetIpProtocol()) {
            hashMap.put("IpProtocol", revokeSecurityGroupIngressRequest.getIpProtocol());
        }
        if (revokeSecurityGroupIngressRequest.isSetFromPort()) {
            hashMap.put("FromPort", revokeSecurityGroupIngressRequest.getFromPort() + "");
        }
        if (revokeSecurityGroupIngressRequest.isSetToPort()) {
            hashMap.put("ToPort", revokeSecurityGroupIngressRequest.getToPort() + "");
        }
        if (revokeSecurityGroupIngressRequest.isSetCidrIp()) {
            hashMap.put("CidrIp", revokeSecurityGroupIngressRequest.getCidrIp());
        }
        return hashMap;
    }

    private Map<String, String> convertRunInstances(RunInstancesRequest runInstancesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "RunInstances");
        if (runInstancesRequest.isSetImageId()) {
            hashMap.put("ImageId", runInstancesRequest.getImageId());
        }
        if (runInstancesRequest.isSetMinCount()) {
            hashMap.put("MinCount", runInstancesRequest.getMinCount() + "");
        }
        if (runInstancesRequest.isSetMaxCount()) {
            hashMap.put("MaxCount", runInstancesRequest.getMaxCount() + "");
        }
        if (runInstancesRequest.isSetKeyName()) {
            hashMap.put("KeyName", runInstancesRequest.getKeyName());
        }
        List<String> list = runInstancesRequest.getSecurityGroup();
        int n = 1;
        List<BlockDeviceMapping> list2 = list.iterator();
        while (list2.hasNext()) {
            String string = list2.next();
            hashMap.put("SecurityGroup." + n, string);
            ++n;
        }
        if (runInstancesRequest.isSetUserData()) {
            hashMap.put("UserData", runInstancesRequest.getUserData());
        }
        if (runInstancesRequest.isSetInstanceType()) {
            hashMap.put("InstanceType", runInstancesRequest.getInstanceType());
        }
        if (runInstancesRequest.isSetPlacement() && ((Placement)((Object)(list2 = runInstancesRequest.getPlacement()))).isSetAvailabilityZone()) {
            hashMap.put("Placement.AvailabilityZone", ((Placement)((Object)list2)).getAvailabilityZone());
        }
        if (runInstancesRequest.isSetKernelId()) {
            hashMap.put("KernelId", runInstancesRequest.getKernelId());
        }
        if (runInstancesRequest.isSetRamdiskId()) {
            hashMap.put("RamdiskId", runInstancesRequest.getRamdiskId());
        }
        list2 = runInstancesRequest.getBlockDeviceMapping();
        int n2 = 1;
        for (BlockDeviceMapping blockDeviceMapping : list2) {
            if (blockDeviceMapping.isSetVirtualName()) {
                hashMap.put("BlockDeviceMapping." + n2 + "." + "VirtualName", blockDeviceMapping.getVirtualName());
            }
            if (blockDeviceMapping.isSetDeviceName()) {
                hashMap.put("BlockDeviceMapping." + n2 + "." + "DeviceName", blockDeviceMapping.getDeviceName());
            }
            ++n2;
        }
        if (runInstancesRequest.isSetMonitoring()) {
            hashMap.put("Monitoring", runInstancesRequest.isMonitoring() + "");
        }
        return hashMap;
    }

    private Map<String, String> convertTerminateInstances(TerminateInstancesRequest terminateInstancesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "TerminateInstances");
        List<String> list = terminateInstancesRequest.getInstanceId();
        int n = 1;
        for (String string : list) {
            hashMap.put("InstanceId." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertDeleteVolume(DeleteVolumeRequest deleteVolumeRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DeleteVolume");
        if (deleteVolumeRequest.isSetVolumeId()) {
            hashMap.put("VolumeId", deleteVolumeRequest.getVolumeId());
        }
        return hashMap;
    }

    private Map<String, String> convertCreateVolume(CreateVolumeRequest createVolumeRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "CreateVolume");
        if (createVolumeRequest.isSetSize()) {
            hashMap.put("Size", createVolumeRequest.getSize());
        }
        if (createVolumeRequest.isSetSnapshotId()) {
            hashMap.put("SnapshotId", createVolumeRequest.getSnapshotId());
        }
        if (createVolumeRequest.isSetAvailabilityZone()) {
            hashMap.put("AvailabilityZone", createVolumeRequest.getAvailabilityZone());
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeVolumes(DescribeVolumesRequest describeVolumesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeVolumes");
        List<String> list = describeVolumesRequest.getVolumeId();
        int n = 1;
        for (String string : list) {
            hashMap.put("VolumeId." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertDetachVolume(DetachVolumeRequest detachVolumeRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DetachVolume");
        if (detachVolumeRequest.isSetVolumeId()) {
            hashMap.put("VolumeId", detachVolumeRequest.getVolumeId());
        }
        if (detachVolumeRequest.isSetInstanceId()) {
            hashMap.put("InstanceId", detachVolumeRequest.getInstanceId());
        }
        if (detachVolumeRequest.isSetDevice()) {
            hashMap.put("Device", detachVolumeRequest.getDevice());
        }
        if (detachVolumeRequest.isSetForce()) {
            hashMap.put("Force", detachVolumeRequest.isForce() + "");
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeSnapshots");
        List<String> list = describeSnapshotsRequest.getSnapshotId();
        int n = 1;
        for (String string : list) {
            hashMap.put("SnapshotId." + n, string);
            ++n;
        }
        return hashMap;
    }

    private Map<String, String> convertDeleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DeleteSnapshot");
        if (deleteSnapshotRequest.isSetSnapshotId()) {
            hashMap.put("SnapshotId", deleteSnapshotRequest.getSnapshotId());
        }
        return hashMap;
    }

    private Map<String, String> convertCreateSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "CreateSnapshot");
        if (createSnapshotRequest.isSetVolumeId()) {
            hashMap.put("VolumeId", createSnapshotRequest.getVolumeId());
        }
        return hashMap;
    }

    private Map<String, String> convertAttachVolume(AttachVolumeRequest attachVolumeRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "AttachVolume");
        if (attachVolumeRequest.isSetVolumeId()) {
            hashMap.put("VolumeId", attachVolumeRequest.getVolumeId());
        }
        if (attachVolumeRequest.isSetInstanceId()) {
            hashMap.put("InstanceId", attachVolumeRequest.getInstanceId());
        }
        if (attachVolumeRequest.isSetDevice()) {
            hashMap.put("Device", attachVolumeRequest.getDevice());
        }
        return hashMap;
    }

    private Map<String, String> convertDescribeRegions(DescribeRegionsRequest describeRegionsRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DescribeRegions");
        List<String> list = describeRegionsRequest.getRegionName();
        int n = 1;
        for (String string : list) {
            hashMap.put("RegionName." + n, string);
            ++n;
        }
        return hashMap;
    }

    static {
        ERROR_PATTERN_ONE = Pattern.compile(".*\\<RequestId>(.*)\\</RequestId>.*\\<Error>\\<Code>(.*)\\</Code>\\<Message>(.*)\\</Message>\\</Error>.*(\\<Error>)?.*", 40);
        ERROR_PATTERN_TWO = Pattern.compile(".*\\<Error>\\<Code>(.*)\\</Code>\\<Message>(.*)\\</Message>\\</Error>.*(\\<Error>)?.*\\<RequestID>(.*)\\</RequestID>.*", 40);
        DEFAULT_ENCODING = "UTF-8";
        try {
            jaxbContext = JAXBContext.newInstance((String)"com.amazonaws.ec2.model", (ClassLoader)AmazonEC2.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            throw new ExceptionInInitializerError(jAXBException);
        }
        unmarshaller = new ThreadLocal<Unmarshaller>(){

            @Override
            protected synchronized Unmarshaller initialValue() {
                try {
                    return jaxbContext.createUnmarshaller();
                }
                catch (JAXBException jAXBException) {
                    throw new ExceptionInInitializerError(jAXBException);
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResponseTransformer {
        private ResponseTransformer() {
        }

        private static String transform(String string, String string2) {
            return ResponseTransformer.transform(ResponseTransformer.fromString(string), ResponseTransformer.fromResource(string2), null);
        }

        private static String transform(Source source, Source source2, Map<String, String> map) {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer(source2);
                StringWriter stringWriter = new StringWriter();
                if (map != null) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        transformer.setParameter(entry.getKey(), entry.getValue());
                    }
                }
                transformer.transform(source, new StreamResult(stringWriter));
                return stringWriter.toString();
            }
            catch (Exception exception) {
                throw new RuntimeException("XSLT transformation failed", exception);
            }
        }

        private static Source fromString(String string) {
            return new StreamSource(new StringReader(string));
        }

        private static Source fromResource(String string) {
            return new StreamSource(AmazonEC2.class.getClassLoader().getResourceAsStream("com/amazonaws/ec2/model/" + string + "Response.xslt"));
        }
    }
}

