/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.Action;
import com.oopsconsultancy.xmltask.BufferStore;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.Task;
import org.w3c.dom.Node;

public class PrintAction
extends Action {
    private final String buffer;
    private final String ident;
    private final Task task;

    private PrintAction(Task task, String path, String buffer, String ident) {
        this.task = task;
        this.buffer = buffer;
        this.ident = ident;
    }

    public static PrintAction newInstanceFromPath(Task task, String path, String ident) {
        return new PrintAction(task, path, null, ident);
    }

    public static PrintAction newInstanceFromBuffer(Task task, String buffer, String ident) {
        return new PrintAction(task, null, buffer, ident);
    }

    public boolean apply(Node node) throws Exception {
        Node[] nodes = null;
        String id = null;
        if (node == null) {
            if (this.buffer == null) {
                System.err.println("No buffer specified");
                return false;
            }
            nodes = BufferStore.get(this.buffer, this.task);
            if (nodes == null) {
                System.err.println("Couldn't find any entries for buffer '" + this.buffer + "'");
                return false;
            }
            id = "buffer '" + this.buffer + "'";
        } else {
            nodes = new Node[]{node};
            id = "node";
        }
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        for (int i = 0; i < nodes.length; ++i) {
            try {
                System.out.println("{ " + id + " output" + (this.ident != null ? " - " + this.ident : ""));
                serializer.transform(new DOMSource(nodes[i]), new StreamResult(System.out));
                System.out.println("} " + id + " output");
                continue;
            }
            catch (Exception e) {
                System.err.println("Problem during output");
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void log(String msg, Task task) {
        if (task != null) {
            task.log(msg, 3);
        } else {
            System.out.println(msg);
        }
    }
}

