/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.rememberme;

import java.util.Date;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.providers.rememberme.RememberMeAuthenticationToken;
import org.acegisecurity.ui.AuthenticationDetailsSource;
import org.acegisecurity.ui.AuthenticationDetailsSourceImpl;
import org.acegisecurity.ui.logout.LogoutHandler;
import org.acegisecurity.ui.rememberme.RememberMeServices;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.RequestUtils;

public class TokenBasedRememberMeServices
implements RememberMeServices,
InitializingBean,
LogoutHandler {
    public static final String ACEGI_SECURITY_HASHED_REMEMBER_ME_COOKIE_KEY = "ACEGI_SECURITY_HASHED_REMEMBER_ME_COOKIE";
    public static final String DEFAULT_PARAMETER = "_acegi_security_remember_me";
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices == null ? (class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices = TokenBasedRememberMeServices.class$("org.acegisecurity.ui.rememberme.TokenBasedRememberMeServices")) : class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices));
    protected AuthenticationDetailsSource authenticationDetailsSource = new AuthenticationDetailsSourceImpl();
    private String key;
    private String parameter = "_acegi_security_remember_me";
    private UserDetailsService userDetailsService;
    protected long tokenValiditySeconds = 1209600L;
    private boolean alwaysRemember = false;
    private static final int DEFAULT_ORDER = Integer.MAX_VALUE;
    private String cookieName = "ACEGI_SECURITY_HASHED_REMEMBER_ME_COOKIE";
    static /* synthetic */ Class class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices;
    static /* synthetic */ Class class$org$acegisecurity$userdetails$UserDetailsService;

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.key);
        Assert.hasLength((String)this.parameter);
        Assert.hasLength((String)this.cookieName);
        Assert.notNull((Object)this.userDetailsService);
    }

    private void autoDetectAndUseAnyUserDetailsService(ApplicationContext applicationContext) {
        Map map = applicationContext.getBeansOfType(class$org$acegisecurity$userdetails$UserDetailsService == null ? (class$org$acegisecurity$userdetails$UserDetailsService = TokenBasedRememberMeServices.class$("org.acegisecurity.userdetails.UserDetailsService")) : class$org$acegisecurity$userdetails$UserDetailsService);
        if (map.size() > 1) {
            throw new IllegalArgumentException("More than one UserDetailsService beans detected please refer to the one using  [ principalRepositoryBeanRef  ] attribute");
        }
        if (map.size() == 1) {
            this.setUserDetailsService((UserDetailsService)map.values().iterator().next());
        }
    }

    public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!this.cookieName.equals(cookies[i].getName())) continue;
            String cookieValue = cookies[i].getValue();
            for (int j = 0; j < cookieValue.length() % 4; ++j) {
                cookieValue = cookieValue + "=";
            }
            if (Base64.isArrayByteBase64((byte[])cookieValue.getBytes())) {
                String cookieAsPlainText;
                String[] cookieTokens;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Remember-me cookie detected");
                }
                if ((cookieTokens = StringUtils.delimitedListToStringArray((String)(cookieAsPlainText = new String(Base64.decodeBase64((byte[])cookieValue.getBytes()))), (String)":")).length == 3) {
                    long tokenExpiryTime;
                    try {
                        tokenExpiryTime = new Long(cookieTokens[1]);
                    }
                    catch (NumberFormatException nfe) {
                        this.cancelCookie(request, response, "Cookie token[1] did not contain a valid number (contained '" + cookieTokens[1] + "')");
                        return null;
                    }
                    if (this.isTokenExpired(tokenExpiryTime)) {
                        this.cancelCookie(request, response, "Cookie token[1] has expired (expired on '" + new Date(tokenExpiryTime) + "'; current time is '" + new Date() + "')");
                        return null;
                    }
                    UserDetails userDetails = this.loadUserDetails(request, response, cookieTokens);
                    if (userDetails == null) {
                        this.cancelCookie(request, response, "Cookie token[0] contained username '" + cookieTokens[0] + "' but was not found");
                        return null;
                    }
                    if (!this.isValidUserDetails(request, response, userDetails, cookieTokens)) {
                        return null;
                    }
                    String expectedTokenSignature = this.makeTokenSignature(tokenExpiryTime, userDetails);
                    if (!expectedTokenSignature.equals(cookieTokens[2])) {
                        this.cancelCookie(request, response, "Cookie token[2] contained signature '" + cookieTokens[2] + "' but expected '" + expectedTokenSignature + "'");
                        return null;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Remember-me cookie accepted");
                    }
                    RememberMeAuthenticationToken auth = new RememberMeAuthenticationToken(this.key, userDetails, userDetails.getAuthorities());
                    auth.setDetails(this.authenticationDetailsSource.buildDetails(request));
                    return auth;
                }
                this.cancelCookie(request, response, "Cookie token did not contain 3 tokens; decoded value was '" + cookieAsPlainText + "'");
                return null;
            }
            this.cancelCookie(request, response, "Cookie token was not Base64 encoded; value was '" + cookieValue + "'");
            return null;
        }
        return null;
    }

    protected String makeTokenSignature(long tokenExpiryTime, UserDetails userDetails) {
        String expectedTokenSignature = DigestUtils.md5Hex((String)(userDetails.getUsername() + ":" + tokenExpiryTime + ":" + userDetails.getPassword() + ":" + this.key));
        return expectedTokenSignature;
    }

    protected boolean isValidUserDetails(HttpServletRequest request, HttpServletResponse response, UserDetails userDetails, String[] cookieTokens) {
        if (!(userDetails.isAccountNonExpired() && userDetails.isCredentialsNonExpired() && userDetails.isEnabled())) {
            this.cancelCookie(request, response, "Cookie token[0] contained username '" + cookieTokens[0] + "' but account has expired, credentials have expired, or user is disabled");
            return false;
        }
        return true;
    }

    protected UserDetails loadUserDetails(HttpServletRequest request, HttpServletResponse response, String[] cookieTokens) {
        UserDetails userDetails = null;
        try {
            userDetails = this.userDetailsService.loadUserByUsername(cookieTokens[0]);
        }
        catch (UsernameNotFoundException notFound) {
            this.cancelCookie(request, response, "Cookie token[0] contained username '" + cookieTokens[0] + "' but was not found");
            return null;
        }
        return userDetails;
    }

    protected boolean isTokenExpired(long tokenExpiryTime) {
        return tokenExpiryTime < System.currentTimeMillis();
    }

    protected void cancelCookie(HttpServletRequest request, HttpServletResponse response, String reasonForLog) {
        if (reasonForLog != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Cancelling cookie for reason: " + reasonForLog));
        }
        response.addCookie(this.makeCancelCookie(request));
    }

    public String getKey() {
        return this.key;
    }

    public String getParameter() {
        return this.parameter;
    }

    public long getTokenValiditySeconds() {
        return this.tokenValiditySeconds;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void loginFail(HttpServletRequest request, HttpServletResponse response) {
        this.cancelCookie(request, response, "Interactive authentication attempt was unsuccessful");
    }

    protected boolean rememberMeRequested(HttpServletRequest request, String parameter) {
        if (this.alwaysRemember) {
            return true;
        }
        return RequestUtils.getBooleanParameter((HttpServletRequest)request, (String)parameter, (boolean)false);
    }

    public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        if (!this.rememberMeRequested(request, this.parameter)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Did not send remember-me cookie (principal did not set parameter '" + this.parameter + "')"));
            }
            return;
        }
        Assert.notNull((Object)successfulAuthentication.getPrincipal());
        Assert.notNull((Object)successfulAuthentication.getCredentials());
        String username = this.retrieveUserName(successfulAuthentication);
        String password = this.retrievePassword(successfulAuthentication);
        if (!StringUtils.hasLength((String)username) || !StringUtils.hasLength((String)password)) {
            return;
        }
        long expiryTime = System.currentTimeMillis() + this.tokenValiditySeconds * 1000L;
        String signatureValue = DigestUtils.md5Hex((String)(username + ":" + expiryTime + ":" + password + ":" + this.key));
        String tokenValue = username + ":" + expiryTime + ":" + signatureValue;
        String tokenValueBase64 = new String(Base64.encodeBase64((byte[])tokenValue.getBytes()));
        response.addCookie(this.makeValidCookie(tokenValueBase64, request, this.tokenValiditySeconds));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added remember-me cookie for user '" + username + "', expiry: '" + new Date(expiryTime) + "'"));
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.cancelCookie(request, response, "Logout of user " + (authentication == null ? "Unknown" : authentication.getName()));
    }

    protected String retrieveUserName(Authentication successfulAuthentication) {
        if (this.isInstanceOfUserDetails(successfulAuthentication)) {
            return ((UserDetails)successfulAuthentication.getPrincipal()).getUsername();
        }
        return successfulAuthentication.getPrincipal().toString();
    }

    protected String retrievePassword(Authentication successfulAuthentication) {
        if (this.isInstanceOfUserDetails(successfulAuthentication)) {
            return ((UserDetails)successfulAuthentication.getPrincipal()).getPassword();
        }
        return successfulAuthentication.getCredentials().toString();
    }

    private boolean isInstanceOfUserDetails(Authentication authentication) {
        return authentication.getPrincipal() instanceof UserDetails;
    }

    protected Cookie makeCancelCookie(HttpServletRequest request) {
        Cookie cookie = new Cookie(this.cookieName, null);
        cookie.setMaxAge(0);
        cookie.setPath(StringUtils.hasLength((String)request.getContextPath()) ? request.getContextPath() : "/");
        return cookie;
    }

    protected Cookie makeValidCookie(String tokenValueBase64, HttpServletRequest request, long maxAge) {
        Cookie cookie = new Cookie(this.cookieName, tokenValueBase64);
        cookie.setMaxAge(new Long(maxAge).intValue());
        cookie.setPath(StringUtils.hasLength((String)request.getContextPath()) ? request.getContextPath() : "/");
        return cookie;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        Assert.notNull((Object)authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setTokenValiditySeconds(long tokenValiditySeconds) {
        this.tokenValiditySeconds = tokenValiditySeconds;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public boolean isAlwaysRemember() {
        return this.alwaysRemember;
    }

    public void setAlwaysRemember(boolean alwaysRemember) {
        this.alwaysRemember = alwaysRemember;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

