/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.json;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.json.JSONArray;
import com.wavemaker.json.JSONObject;
import com.wavemaker.json.JSONState;
import com.wavemaker.json.type.FieldDefinition;
import com.wavemaker.json.type.ListTypeDefinition;
import com.wavemaker.json.type.MapTypeDefinition;
import com.wavemaker.json.type.ObjectTypeDefinition;
import com.wavemaker.json.type.PrimitiveTypeDefinition;
import com.wavemaker.json.type.TypeState;
import com.wavemaker.json.type.converters.ReadObjectConverter;
import com.wavemaker.json.type.reflect.ReflectTypeUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternateJSONTransformer {
    public static final char PROP_SEP = '.';
    protected static final Logger logger = Logger.getLogger(AlternateJSONTransformer.class);

    public static Object toObject(JSONObject obj, Class<?> klass) {
        return AlternateJSONTransformer.toObject(new JSONState(), (Object)obj, klass);
    }

    public static Object toObject(JSONState jsonState, Object obj, Class<?> klass) {
        TypeState typeState = jsonState.getTypeState();
        FieldDefinition fieldDefinition = ReflectTypeUtils.getFieldDefinition(klass, typeState, false, null);
        return AlternateJSONTransformer.toObjectInternal(jsonState, obj, obj, fieldDefinition, typeState, 0, new Stack<String>());
    }

    public static Object toObject(JSONState jsonState, Object obj, FieldDefinition fieldDefinition) {
        return AlternateJSONTransformer.toObjectInternal(jsonState, obj, obj, fieldDefinition, jsonState.getTypeState(), 0, new Stack<String>());
    }

    private static Object toObjectInternal(JSONState jsonState, Object obj, Object root, FieldDefinition fieldDefinition, TypeState typeState, int arrayLevel, Stack<String> setterQueue) {
        Object ret;
        block15: {
            Tuple.Three<Object, FieldDefinition, Integer> tuple;
            if (null == fieldDefinition) {
                throw new NullArgumentException("fieldDefinition");
            }
            ret = null;
            if (null != jsonState.getValueTransformer() && null != (tuple = jsonState.getValueTransformer().transformToJava(obj, fieldDefinition, arrayLevel, root, AlternateJSONTransformer.getPropertyFromQueue(setterQueue), jsonState.getTypeState()))) {
                obj = tuple.v1;
                fieldDefinition = (FieldDefinition)tuple.v2;
                arrayLevel = (Integer)tuple.v3;
            }
            if (null != obj && fieldDefinition.getDimensions() == arrayLevel && null == fieldDefinition.getTypeDefinition()) {
                fieldDefinition = ReflectTypeUtils.getFieldDefinition(obj.getClass(), typeState, false, null);
            }
            try {
                if (null == fieldDefinition.getTypeDefinition()) {
                    ret = obj;
                    break block15;
                }
                if (arrayLevel == fieldDefinition.getDimensions() && fieldDefinition.getTypeDefinition() instanceof ReadObjectConverter) {
                    ret = ((ReadObjectConverter)fieldDefinition.getTypeDefinition()).readObject(obj, root, AlternateJSONTransformer.getPropertyFromQueue(setterQueue));
                    break block15;
                }
                if (null == obj) {
                    ret = null;
                    break block15;
                }
                if (arrayLevel < fieldDefinition.getDimensions()) {
                    ret = AlternateJSONTransformer.toCollectionOrArray(jsonState, obj, root, fieldDefinition, typeState, arrayLevel, setterQueue);
                    break block15;
                }
                if (fieldDefinition.getTypeDefinition() instanceof PrimitiveTypeDefinition) {
                    ret = fieldDefinition.getTypeDefinition().newInstance(obj);
                    break block15;
                }
                if (fieldDefinition.getTypeDefinition() instanceof MapTypeDefinition) {
                    ret = AlternateJSONTransformer.toMap(jsonState, obj, root, fieldDefinition, typeState, arrayLevel, setterQueue);
                    break block15;
                }
                if (obj instanceof JSONObject && fieldDefinition.getTypeDefinition() instanceof ObjectTypeDefinition) {
                    ret = AlternateJSONTransformer.toObjectInternal(jsonState, (JSONObject)obj, root, fieldDefinition, typeState, arrayLevel, setterQueue);
                    break block15;
                }
                throw new WMRuntimeException(Resource.JSON_UNKNOWN_OBJECT_TYPE, new Object[]{obj, obj.getClass(), fieldDefinition});
            }
            catch (InstantiationException e) {
                throw new WMRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new WMRuntimeException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new WMRuntimeException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new WMRuntimeException((Throwable)e);
            }
        }
        return ret;
    }

    private static Object toObjectInternal(JSONState jsonState, JSONObject obj, Object root, FieldDefinition fieldDefinition, TypeState typeState, int arrayLevel, Stack<String> setterQueue) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (null == fieldDefinition) {
            throw new NullArgumentException("fieldDefinition");
        }
        if (null == fieldDefinition.getTypeDefinition()) {
            throw new WMRuntimeException(Resource.JSON_TYPEDEF_REQUIRED);
        }
        if (!(fieldDefinition.getTypeDefinition() instanceof ObjectTypeDefinition)) {
            throw new WMRuntimeException(Resource.JSON_OBJECTTYPEDEF_REQUIRED, new Object[]{fieldDefinition.getTypeDefinition(), fieldDefinition.getTypeDefinition().getClass()});
        }
        ObjectTypeDefinition otd = (ObjectTypeDefinition)fieldDefinition.getTypeDefinition();
        Object instance = otd.newInstance(new Object[0]);
        Iterator i$ = obj.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entryO;
            Map.Entry entry = entryO = i$.next();
            String key = (String)entry.getKey();
            FieldDefinition nestedFieldDefinition = otd.getFields().get(key);
            if (null == nestedFieldDefinition) {
                throw new WMRuntimeException(Resource.JSON_NO_PROP_MATCHES_KEY, new Object[]{key, fieldDefinition});
            }
            if (!PropertyUtils.isWriteable((Object)instance, (String)key)) {
                logger.warn((Object)Resource.JSON_NO_WRITE_METHOD.getMessage(new Object[]{fieldDefinition, key}));
                continue;
            }
            setterQueue.push(key);
            jsonState.getSettersCalled().add(AlternateJSONTransformer.getPropertyFromQueue(setterQueue));
            Object paramValue = AlternateJSONTransformer.toObjectInternal(jsonState, entry.getValue(), root, nestedFieldDefinition, typeState, 0, setterQueue);
            PropertyUtils.setProperty((Object)instance, (String)key, (Object)paramValue);
            setterQueue.pop();
        }
        return instance;
    }

    private static Object toCollectionOrArray(JSONState jsonState, Object obj, Object root, FieldDefinition fieldDefinition, TypeState typeState, int arrayLevel, Stack<String> setterQueue) throws InstantiationException, IllegalAccessException {
        if (null == fieldDefinition) {
            throw new NullArgumentException("fieldDefinition");
        }
        ListTypeDefinition ltd = fieldDefinition.getArrayTypes().get(arrayLevel);
        JSONArray jsonArray = (JSONArray)obj;
        Object listObject = ltd.newInstance(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object arrayElement = AlternateJSONTransformer.toObjectInternal(jsonState, jsonArray.get(i), root, fieldDefinition, typeState, arrayLevel + 1, setterQueue);
            ltd.add(listObject, i, arrayElement);
        }
        return listObject;
    }

    private static Map<?, ?> toMap(JSONState jsonState, Object obj, Object root, FieldDefinition fieldDefinition, TypeState typeState, int arrayLevel, Stack<String> setterQueue) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (null == fieldDefinition) {
            throw new NullArgumentException("fieldDefinition");
        }
        MapTypeDefinition mtd = (MapTypeDefinition)fieldDefinition.getTypeDefinition();
        if (!(obj instanceof JSONObject)) {
            throw new WMRuntimeException(Resource.JSON_OBJECT_REQUIRED_FOR_MAP_CONVERSION, new Object[]{obj, null != obj ? obj.getClass() : obj});
        }
        JSONObject jsonObject = (JSONObject)((Object)obj);
        Map ret = (Map)fieldDefinition.getTypeDefinition().newInstance(new Object[0]);
        FieldDefinition keyFD = mtd.getKeyFieldDefinition();
        FieldDefinition valueFD = mtd.getValueFieldDefinition();
        Iterator i$ = jsonObject.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = i$.next();
            Object key = AlternateJSONTransformer.toObjectInternal(jsonState, entry.getKey(), root, keyFD, typeState, 0, setterQueue);
            Object value = AlternateJSONTransformer.toObjectInternal(jsonState, entry.getValue(), root, valueFD, typeState, 0, setterQueue);
            ret.put(key, value);
        }
        return ret;
    }

    protected static String getPropertyFromQueue(Stack<String> setterQueue) {
        return StringUtils.join(setterQueue, (char)'.');
    }
}

