/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.json;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.EntryComparator;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.json.JSONState;
import com.wavemaker.json.type.FieldDefinition;
import com.wavemaker.json.type.GenericFieldDefinition;
import com.wavemaker.json.type.MapTypeDefinition;
import com.wavemaker.json.type.ObjectTypeDefinition;
import com.wavemaker.json.type.PrimitiveTypeDefinition;
import com.wavemaker.json.type.TypeState;
import com.wavemaker.json.type.converters.WriteObjectConverter;
import com.wavemaker.json.type.reflect.ReflectTypeUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONMarshaller {
    private static final boolean DEFAULT_PRETTY_PRINT = false;
    private static final boolean DEFAULT_SORT = false;
    protected static final Logger logger = Logger.getLogger(JSONMarshaller.class);

    public static String marshal(Object obj) throws IOException {
        return JSONMarshaller.marshal(obj, new JSONState(), false);
    }

    public static String marshal(Object obj, JSONState jsonState) throws IOException {
        return JSONMarshaller.marshal(obj, jsonState, false);
    }

    public static String marshal(Object obj, JSONState jsonState, boolean sort) throws IOException {
        return JSONMarshaller.marshal(obj, jsonState, sort, false);
    }

    public static String marshal(Object obj, JSONState jsonState, boolean sort, boolean prettyPrint) throws IOException {
        StringWriter sw = new StringWriter();
        JSONMarshaller.marshal(sw, obj, jsonState, sort, prettyPrint);
        String ret = sw.toString();
        sw.close();
        return ret;
    }

    public static String marshal(Object obj, JSONState jsonState, FieldDefinition fieldDefinition, boolean sort) throws IOException {
        StringWriter sw = new StringWriter();
        JSONMarshaller.marshal(sw, obj, jsonState, fieldDefinition, sort, false);
        String ret = sw.toString();
        sw.close();
        return ret;
    }

    public static void marshal(Writer writer, Object obj) throws IOException {
        JSONMarshaller.marshal(writer, obj, new JSONState(), false);
    }

    public static void marshal(Writer writer, Object obj, JSONState jsonState, boolean sort) throws IOException {
        JSONMarshaller.marshal(writer, obj, jsonState, sort, false);
    }

    public static void marshal(Writer writer, Object obj, JSONState jsonState, boolean sort, boolean prettyPrint) throws IOException {
        TypeState typeState = jsonState.getTypeState();
        FieldDefinition fieldDefinition = null == obj ? ReflectTypeUtils.getFieldDefinition((Type)null, typeState, false, null) : ReflectTypeUtils.getFieldDefinition(obj.getClass(), typeState, false, null);
        JSONMarshaller.marshal(writer, obj, jsonState, fieldDefinition, sort, prettyPrint);
    }

    public static void marshal(Writer writer, Object obj, JSONState jsonState, FieldDefinition rootFieldDefinition, boolean sort, boolean prettyPrint) throws IOException {
        TypeState typeState = jsonState.getTypeState();
        JSONMarshaller.doMarshal(writer, obj, obj, jsonState, sort, true, new Stack<Object>(), new Stack<String>(), rootFieldDefinition, 0, typeState, prettyPrint, 0, Logger.getLogger(JSONMarshaller.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object doMarshal(Writer writer, Object obj, Object root, JSONState js, boolean sort, boolean topLevel, Stack<Object> touchedObjects, Stack<String> propertyNames, FieldDefinition fieldDefinition, int arrayLevel, TypeState typeState, boolean prettyPrint, int level, Logger logger) throws IOException {
        if (null == fieldDefinition) {
            throw new NullArgumentException("fieldDefinition");
        }
        touchedObjects.push(obj);
        try {
            Tuple.Three<Object, FieldDefinition, Integer> tuple;
            if (null != obj && null == fieldDefinition.getTypeDefinition()) {
                fieldDefinition = ReflectTypeUtils.getFieldDefinition(obj.getClass(), typeState, false, null);
                arrayLevel = 0;
            }
            if (null != js.getValueTransformer() && null != (tuple = js.getValueTransformer().transformToJSON(obj, fieldDefinition, arrayLevel, root, JSONMarshaller.getPropertyName(propertyNames, js), js.getTypeState()))) {
                obj = tuple.v1;
                fieldDefinition = (FieldDefinition)tuple.v2;
                arrayLevel = (Integer)tuple.v3;
            }
            if (arrayLevel == fieldDefinition.getDimensions() && null != fieldDefinition.getTypeDefinition() && fieldDefinition.getTypeDefinition() instanceof WriteObjectConverter) {
                ((WriteObjectConverter)fieldDefinition.getTypeDefinition()).writeObject(obj, root, JSONMarshaller.getPropertyName(propertyNames, js), writer);
            } else if (null == obj) {
                writer.write("null");
            } else if (arrayLevel < fieldDefinition.getDimensions() || obj.getClass().isArray()) {
                writer.write("[");
                boolean firstElement = true;
                if (obj instanceof Collection) {
                    for (Object elem : (Collection)obj) {
                        if (!firstElement) {
                            writer.write(",");
                            if (prettyPrint) {
                                writer.write(" ");
                            }
                        }
                        JSONMarshaller.doMarshal(writer, elem, root, js, sort, false, touchedObjects, propertyNames, fieldDefinition, arrayLevel + 1, typeState, prettyPrint, level, logger);
                        if (!firstElement) continue;
                        firstElement = false;
                    }
                } else if (obj.getClass().isArray()) {
                    int length = Array.getLength(obj);
                    for (int i = 0; i < length; ++i) {
                        Object elem = Array.get(obj, i);
                        if (!firstElement) {
                            writer.write(",");
                            if (prettyPrint) {
                                writer.write(" ");
                            }
                        }
                        JSONMarshaller.doMarshal(writer, elem, root, js, sort, false, touchedObjects, propertyNames, fieldDefinition, arrayLevel + 1, typeState, prettyPrint, level, logger);
                        if (!firstElement) continue;
                        firstElement = false;
                    }
                } else {
                    throw new WMRuntimeException(Resource.JSON_UNKNOWN_COLL_OR_ARRAY, new Object[]{obj, obj.getClass()});
                }
                writer.write("]");
            } else if (null != fieldDefinition.getTypeDefinition() && fieldDefinition.getTypeDefinition() instanceof PrimitiveTypeDefinition) {
                ((PrimitiveTypeDefinition)fieldDefinition.getTypeDefinition()).toJson(writer, obj);
            } else {
                JSONMarshaller.handleObject(obj, root, js, writer, touchedObjects, propertyNames, sort, fieldDefinition, arrayLevel, typeState, prettyPrint, level, logger);
            }
            Object var14_14 = null;
            return var14_14;
        }
        finally {
            touchedObjects.pop();
        }
    }

    private static void handleObject(Object obj, Object root, JSONState js, Writer writer, Stack<Object> touchedObjects, Stack<String> propertyNames, boolean sort, FieldDefinition fieldDefinition, int arrayLevel, TypeState typeState, boolean prettyPrint, int level, Logger logger) throws IOException {
        if (null == fieldDefinition) {
            throw new NullArgumentException("fieldDefinition");
        }
        writer.write(123);
        boolean firstProperty = true;
        if (obj instanceof Map || fieldDefinition.getTypeDefinition() instanceof MapTypeDefinition) {
            Set entries = null;
            if (sort) {
                TreeSet entriesTemp = new TreeSet(new EntryComparator());
                entriesTemp.addAll(((Map)obj).entrySet());
                entries = entriesTemp;
            }
            for (Map.Entry entry : entries == null ? ((Map)obj).entrySet() : entries) {
                String key = (String)entry.getKey();
                fieldDefinition = null != fieldDefinition.getTypeDefinition() && fieldDefinition.getTypeDefinition() instanceof MapTypeDefinition ? ((MapTypeDefinition)fieldDefinition.getTypeDefinition()).getValueFieldDefinition() : new GenericFieldDefinition();
                firstProperty = JSONMarshaller.handleObjectInternal(obj, root, key, entry.getValue(), firstProperty, js, writer, touchedObjects, propertyNames, sort, fieldDefinition, arrayLevel, typeState, prettyPrint, level + 1, logger);
            }
        } else if (fieldDefinition.getTypeDefinition() instanceof ObjectTypeDefinition) {
            ObjectTypeDefinition otd = (ObjectTypeDefinition)fieldDefinition.getTypeDefinition();
            if (otd.getTypeName().equals(obj.getClass().getName())) {
                for (Map.Entry<String, FieldDefinition> entry : otd.getFields().entrySet()) {
                    Object value;
                    String name = entry.getKey();
                    fieldDefinition = entry.getValue();
                    try {
                        value = PropertyUtils.getProperty((Object)obj, (String)name);
                    }
                    catch (IllegalArgumentException e) {
                        throw new WMRuntimeException(Resource.ERROR_GETTING_PROPERTY, (Throwable)e, new Object[]{name, obj, obj.getClass().getName()});
                    }
                    catch (IllegalAccessException e) {
                        throw new WMRuntimeException(Resource.ERROR_GETTING_PROPERTY, (Throwable)e, new Object[]{name, obj, obj.getClass().getName()});
                    }
                    catch (InvocationTargetException e) {
                        throw new WMRuntimeException(Resource.ERROR_GETTING_PROPERTY, (Throwable)e, new Object[]{name, obj, obj.getClass().getName()});
                    }
                    catch (NoSuchMethodException e) {
                        logger.warn((Object)Resource.JSON_NO_GETTER_IN_TYPE.getMessage(new Object[]{name, obj, obj.getClass().getName()}));
                        continue;
                    }
                    firstProperty = JSONMarshaller.handleObjectInternal(obj, root, name, value, firstProperty, js, writer, touchedObjects, propertyNames, sort, fieldDefinition, 0, typeState, prettyPrint, level + 1, logger);
                }
            }
        } else {
            throw new WMRuntimeException(Resource.JSON_BAD_HANDLE_TYPE, new Object[]{fieldDefinition.getTypeDefinition()});
        }
        if (prettyPrint) {
            writer.write("\n");
            JSONMarshaller.writeIndents(writer, level);
        }
        writer.write(125);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handleObjectInternal(Object object, Object root, String key, Object value, boolean firstProperty, JSONState js, Writer writer, Stack<Object> touchedObjects, Stack<String> propertyNames, boolean sort, FieldDefinition fieldDefinition, int arrayLevel, TypeState typeState, boolean prettyPrint, int level, Logger logger) throws IOException {
        if (null == fieldDefinition) {
            throw new NullArgumentException("fieldDefinition");
        }
        propertyNames.push(key);
        String propertyName = JSONMarshaller.getPropertyName(propertyNames, js);
        try {
            if (js.getExcludes().contains(propertyName)) {
                boolean bl = firstProperty;
                return bl;
            }
            if (null != js.getPropertyFilter() && js.getPropertyFilter().filter(object, key, value)) {
                boolean bl = firstProperty;
                return bl;
            }
            if (JSONMarshaller.isCycle(value, touchedObjects, propertyName, js)) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)Resource.JSON_CYCLE_FOUND.getMessage(new Object[]{value, js.getCycleHandler()}));
                }
                if (js.getCycleHandler().equals((Object)JSONState.CycleHandler.FAIL)) {
                    throw new WMRuntimeException(Resource.JSON_CYCLE_FOUND, new Object[]{value, js.getCycleHandler()});
                }
                if (js.getCycleHandler().equals((Object)JSONState.CycleHandler.NULL)) {
                    value = null;
                } else {
                    if (js.getCycleHandler().equals((Object)JSONState.CycleHandler.NO_PROPERTY)) {
                        boolean bl = firstProperty;
                        return bl;
                    }
                    throw new WMRuntimeException(Resource.JSON_BAD_CYCLE_HANDLER, new Object[]{js.getCycleHandler()});
                }
            }
            if (!firstProperty) {
                writer.write(44);
            }
            if (prettyPrint) {
                writer.write("\n");
                JSONMarshaller.writeIndents(writer, level);
            }
            if (js.isUnquoteKeys()) {
                writer.write(key + ":");
            } else {
                writer.write("\"" + key + "\":");
            }
            if (prettyPrint) {
                writer.write(" ");
            }
            JSONMarshaller.doMarshal(writer, value, root, js, sort, false, touchedObjects, propertyNames, fieldDefinition, arrayLevel, typeState, prettyPrint, level, logger);
            if (firstProperty) {
                firstProperty = false;
            }
            boolean bl = firstProperty;
            return bl;
        }
        finally {
            propertyNames.pop();
        }
    }

    private static void writeIndents(Writer writer, int level) throws IOException {
        for (int i = 0; i < level; ++i) {
            writer.write(9);
        }
    }

    private static String getPropertyName(Stack<String> propertyNames, JSONState js) {
        return StringUtils.join(propertyNames.subList(js.getTrimStackLevel(), propertyNames.size()), (char)'.');
    }

    private static boolean isCycle(Object obj, Stack<Object> touchedObjects, String propertyName, JSONState js) {
        boolean cycle;
        boolean bl = cycle = -1 != touchedObjects.search(obj);
        if (cycle && null != js.getRequiredProperties() && js.getRequiredProperties().contains(propertyName)) {
            cycle = false;
        }
        return cycle;
    }
}

