/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.json.type.reflect;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.json.core.JSONUtils;
import com.wavemaker.json.type.PrimitiveTypeDefinition;
import com.wavemaker.json.type.reflect.ReflectTypeDefinition;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.util.ClassUtils;

public class PrimitiveReflectTypeDefinition
extends ReflectTypeDefinition
implements PrimitiveTypeDefinition {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object newInstance(Object ... args) {
        if (!(1 == args.length || 2 == args.length && args[1] instanceof Class)) {
            throw new IllegalArgumentException(Resource.JSON_PRIM_NEWINSTANCE_ARG_REQ.getMessage(new Object[]{Arrays.toString(args)}));
        }
        Object obj = args[0];
        Class klass = args.length > 1 ? (Class)args[1] : this.getKlass();
        if (Class.class.isAssignableFrom(klass)) {
            try {
                return ClassUtils.forName((String)obj.toString());
            }
            catch (ClassNotFoundException e) {
                throw new WMRuntimeException((Throwable)e);
            }
            catch (LinkageError e) {
                throw new WMRuntimeException((Throwable)e);
            }
        }
        if (ClassUtils.isAssignable((Class)klass, obj.getClass())) {
            return obj;
        }
        if (klass.isPrimitive()) {
            if (obj instanceof Number) {
                Number number = (Number)obj;
                if (Byte.TYPE.equals(klass)) {
                    return number.byteValue();
                }
                if (Short.TYPE.equals(klass)) {
                    return number.shortValue();
                }
                if (Integer.TYPE.equals(klass)) {
                    return number.intValue();
                }
                if (Long.TYPE.equals(klass)) {
                    return number.longValue();
                }
                if (Float.TYPE.equals(klass)) {
                    return Float.valueOf(number.floatValue());
                }
                if (!Double.TYPE.equals(klass)) throw new WMRuntimeException(Resource.JSON_UNKNOWN_NUMBER_TYPE, new Object[]{klass, obj});
                return number.doubleValue();
            }
            String string = obj.toString();
            try {
                if (Byte.TYPE.equals(klass)) {
                    return Byte.valueOf(string);
                }
                if (Short.TYPE.equals(klass)) {
                    return Short.valueOf(string);
                }
                if (Integer.TYPE.equals(klass)) {
                    return Integer.valueOf(string);
                }
                if (Long.TYPE.equals(klass)) {
                    return Long.valueOf(string);
                }
                if (Float.TYPE.equals(klass)) {
                    return Float.valueOf(string);
                }
                if (Double.TYPE.equals(klass)) {
                    return Double.valueOf(string);
                }
                if (Boolean.TYPE.equals(klass)) {
                    return Boolean.valueOf(string);
                }
                if (!Character.TYPE.equals(klass)) throw new WMRuntimeException(Resource.JSON_UNKNOWN_NUMBER_TYPE, new Object[]{klass, string});
                return Character.valueOf(string.charAt(0));
            }
            catch (NumberFormatException e) {
                throw new WMRuntimeException(Resource.JSON_FAILED_TO_CONVERT, (Throwable)e, new Object[]{string, klass});
            }
        }
        if (klass.equals(AtomicInteger.class) && obj instanceof Number) {
            Number number = (Number)obj;
            return new AtomicInteger(number.intValue());
        }
        if (klass.equals(AtomicLong.class) && obj instanceof Number) {
            Number number = (Number)obj;
            return new AtomicLong(number.longValue());
        }
        try {
            Constructor c = klass.getConstructor(String.class);
            return c.newInstance(obj.toString());
        }
        catch (SecurityException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    public void toJson(Writer writer, Object obj) throws IOException {
        if (CharSequence.class.isAssignableFrom(obj.getClass())) {
            writer.write(JSONUtils.quote(obj.toString()));
        } else if (Character.class.isAssignableFrom(obj.getClass())) {
            writer.write(JSONUtils.quote(obj.toString()));
        } else if (Number.class.isAssignableFrom(obj.getClass())) {
            writer.write(JSONUtils.numberToString((Number)obj));
        } else if (Boolean.class.isAssignableFrom(obj.getClass())) {
            writer.write(obj.toString());
        } else if (Class.class.isAssignableFrom(obj.getClass())) {
            writer.write(JSONUtils.quote(((Class)obj).getName()));
        } else {
            throw new WMRuntimeException(Resource.JSON_UNKNOWN_PRIMITIVE_TYPE, new Object[]{obj, obj.getClass()});
        }
    }
}

