/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.json.type.reflect;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.json.type.TypeDefinition;
import com.wavemaker.json.type.TypeState;
import com.wavemaker.json.type.reflect.ReflectTypeUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectTypeState
implements TypeState {
    private final Map<String, TypeDefinition> knownTypes = new HashMap<String, TypeDefinition>();
    private final PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();

    @Override
    public void addType(TypeDefinition typeDefinition) {
        this.knownTypes.put(typeDefinition.getTypeName(), typeDefinition);
    }

    @Override
    public TypeDefinition getType(String typeName) {
        if (this.knownTypes.containsKey(typeName)) {
            return this.knownTypes.get(typeName);
        }
        try {
            TypeDefinition td = ReflectTypeUtils.getTypeDefinition(ClassUtils.forName((String)typeName), this, false);
            this.addType(td);
            return td;
        }
        catch (ClassNotFoundException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (LinkageError e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isTypeKnown(String typeName) {
        return this.knownTypes.containsKey(typeName);
    }

    public PropertyUtilsBean getPropertyUtilsBean() {
        return this.propertyUtilsBean;
    }

    public Map<String, TypeDefinition> getKnownTypes() {
        return this.knownTypes;
    }
}

