/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.Utils;
import org.antlr.runtime.BitSet;
import org.antlr.tool.Grammar;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalSet
implements IntSet {
    public static final IntervalSet COMPLETE_SET = IntervalSet.of(0, 65535);
    protected List<Interval> intervals;

    public IntervalSet() {
        this.intervals = new ArrayList<Interval>(2);
    }

    public IntervalSet(List<Interval> list) {
        this.intervals = list;
    }

    public static IntervalSet of(int n) {
        IntervalSet intervalSet = new IntervalSet();
        intervalSet.add(n);
        return intervalSet;
    }

    public static IntervalSet of(int n, int n2) {
        IntervalSet intervalSet = new IntervalSet();
        intervalSet.add(n, n2);
        return intervalSet;
    }

    @Override
    public void add(int n) {
        this.add(n, n);
    }

    public void add(int n, int n2) {
        this.add(Interval.create(n, n2));
    }

    protected void add(Interval interval) {
        if (interval.b < interval.a) {
            return;
        }
        ListIterator<Interval> listIterator = this.intervals.listIterator();
        while (listIterator.hasNext()) {
            Interval interval2 = listIterator.next();
            if (interval.equals(interval2)) {
                return;
            }
            if (interval.adjacent(interval2) || !interval.disjoint(interval2)) {
                Interval interval3;
                Interval interval4 = interval.union(interval2);
                listIterator.set(interval4);
                if (listIterator.hasNext() && (interval4.adjacent(interval3 = listIterator.next()) || !interval4.disjoint(interval3))) {
                    listIterator.remove();
                    listIterator.previous();
                    listIterator.set(interval4.union(interval3));
                }
                return;
            }
            if (!interval.startsBeforeDisjoint(interval2)) continue;
            listIterator.previous();
            listIterator.add(interval);
            return;
        }
        this.intervals.add(interval);
    }

    @Override
    public void addAll(IntSet intSet) {
        if (intSet == null) {
            return;
        }
        if (!(intSet instanceof IntervalSet)) {
            throw new IllegalArgumentException(new StringBuffer().append("can't add non IntSet (").append(intSet.getClass().getName()).append(") to IntervalSet").toString());
        }
        IntervalSet intervalSet = (IntervalSet)intSet;
        int n = intervalSet.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval interval = intervalSet.intervals.get(i);
            this.add(interval.a, interval.b);
        }
    }

    public IntSet complement(int n, int n2) {
        return this.complement(IntervalSet.of(n, n2));
    }

    @Override
    public IntSet complement(IntSet intSet) {
        Object object;
        Object object2;
        if (intSet == null) {
            return null;
        }
        if (!(intSet instanceof IntervalSet)) {
            throw new IllegalArgumentException(new StringBuffer().append("can't complement with non IntervalSet (").append(intSet.getClass().getName()).append(")").toString());
        }
        IntervalSet intervalSet = (IntervalSet)intSet;
        int n = intervalSet.getMaxElement();
        IntervalSet intervalSet2 = new IntervalSet();
        int n2 = this.intervals.size();
        if (n2 == 0) {
            return intervalSet2;
        }
        Interval interval = this.intervals.get(0);
        if (interval.a > 0) {
            IntervalSet intervalSet3 = IntervalSet.of(0, interval.a - 1);
            object2 = (IntervalSet)intervalSet3.and(intervalSet);
            intervalSet2.addAll((IntSet)object2);
        }
        for (int i = 1; i < n2; ++i) {
            object2 = this.intervals.get(i - 1);
            object = this.intervals.get(i);
            IntervalSet intervalSet4 = IntervalSet.of(((Interval)object2).b + 1, ((Interval)object).a - 1);
            IntervalSet intervalSet5 = (IntervalSet)intervalSet4.and(intervalSet);
            intervalSet2.addAll(intervalSet5);
        }
        Interval interval2 = this.intervals.get(n2 - 1);
        if (interval2.b < n) {
            object2 = IntervalSet.of(interval2.b + 1, n);
            object = (IntervalSet)((IntervalSet)object2).and(intervalSet);
            intervalSet2.addAll((IntSet)object);
        }
        return intervalSet2;
    }

    @Override
    public IntSet subtract(IntSet intSet) {
        return this.and(((IntervalSet)intSet).complement(COMPLETE_SET));
    }

    @Override
    public IntSet or(IntSet intSet) {
        IntervalSet intervalSet = new IntervalSet();
        intervalSet.addAll(this);
        intervalSet.addAll(intSet);
        return intervalSet;
    }

    @Override
    public IntSet and(IntSet intSet) {
        if (intSet == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.intervals;
        ArrayList arrayList2 = (ArrayList)((IntervalSet)intSet).intervals;
        IntervalSet intervalSet = null;
        int n = arrayList.size();
        int n2 = arrayList2.size();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            Interval interval;
            Interval interval2 = (Interval)arrayList.get(n3);
            if (interval2.startsBeforeDisjoint(interval = (Interval)arrayList2.get(n4))) {
                ++n3;
                continue;
            }
            if (interval.startsBeforeDisjoint(interval2)) {
                ++n4;
                continue;
            }
            if (interval2.properlyContains(interval)) {
                if (intervalSet == null) {
                    intervalSet = new IntervalSet();
                }
                intervalSet.add(interval2.intersection(interval));
                ++n4;
                continue;
            }
            if (interval.properlyContains(interval2)) {
                if (intervalSet == null) {
                    intervalSet = new IntervalSet();
                }
                intervalSet.add(interval2.intersection(interval));
                ++n3;
                continue;
            }
            if (interval2.disjoint(interval)) continue;
            if (intervalSet == null) {
                intervalSet = new IntervalSet();
            }
            intervalSet.add(interval2.intersection(interval));
            if (interval2.startsAfterNonDisjoint(interval)) {
                ++n4;
                continue;
            }
            if (!interval.startsAfterNonDisjoint(interval2)) continue;
            ++n3;
        }
        if (intervalSet == null) {
            return new IntervalSet();
        }
        return intervalSet;
    }

    @Override
    public boolean member(int n) {
        int n2 = this.intervals.size();
        for (int i = 0; i < n2; ++i) {
            Interval interval = this.intervals.get(i);
            int n3 = interval.a;
            int n4 = interval.b;
            if (n < n3) break;
            if (n < n3 || n > n4) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNil() {
        return this.intervals == null || this.intervals.size() == 0;
    }

    @Override
    public int getSingleElement() {
        if (this.intervals != null && this.intervals.size() == 1) {
            Interval interval = this.intervals.get(0);
            if (interval.a == interval.b) {
                return interval.a;
            }
        }
        return -7;
    }

    public int getMaxElement() {
        if (this.isNil()) {
            return -7;
        }
        Interval interval = this.intervals.get(this.intervals.size() - 1);
        return interval.b;
    }

    public int getMinElement() {
        if (this.isNil()) {
            return -7;
        }
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval interval = this.intervals.get(i);
            int n2 = interval.a;
            int n3 = interval.b;
            for (int j = n2; j <= n3; ++j) {
                if (j < 0) continue;
                return j;
            }
        }
        return -7;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof IntervalSet)) {
            return false;
        }
        IntervalSet intervalSet = (IntervalSet)object;
        return ((Object)this.intervals).equals(intervalSet.intervals);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Grammar grammar) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.intervals == null || this.intervals.size() == 0) {
            return "{}";
        }
        if (this.intervals.size() > 1) {
            stringBuffer.append("{");
        }
        Iterator<Interval> iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            int n = interval.a;
            int n2 = interval.b;
            if (n == n2) {
                if (grammar != null) {
                    stringBuffer.append(grammar.getTokenDisplayName(n));
                } else {
                    stringBuffer.append(n);
                }
            } else if (grammar != null) {
                stringBuffer.append(new StringBuffer().append(grammar.getTokenDisplayName(n)).append("..").append(grammar.getTokenDisplayName(n2)).toString());
            } else {
                stringBuffer.append(new StringBuffer().append(n).append("..").append(n2).toString());
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        if (this.intervals.size() > 1) {
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    @Override
    public int size() {
        int n = 0;
        int n2 = this.intervals.size();
        if (n2 == 1) {
            Interval interval = this.intervals.get(0);
            return interval.b - interval.a + 1;
        }
        for (int i = 0; i < n2; ++i) {
            Interval interval = this.intervals.get(i);
            n += interval.b - interval.a + 1;
        }
        return n;
    }

    @Override
    public List toList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval interval = this.intervals.get(i);
            int n2 = interval.a;
            int n3 = interval.b;
            for (int j = n2; j <= n3; ++j) {
                arrayList.add(Utils.integer(j));
            }
        }
        return arrayList;
    }

    public int get(int n) {
        int n2 = this.intervals.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Interval interval = this.intervals.get(i);
            int n4 = interval.a;
            int n5 = interval.b;
            for (int j = n4; j <= n5; ++j) {
                if (n3 == n) {
                    return j;
                }
                ++n3;
            }
        }
        return -1;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        int n = this.intervals.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Interval interval = this.intervals.get(i);
            int n3 = interval.a;
            int n4 = interval.b;
            int n5 = n3;
            while (n5 <= n4) {
                nArray[n2] = n5++;
                ++n2;
            }
        }
        return nArray;
    }

    public BitSet toRuntimeBitSet() {
        BitSet bitSet = new BitSet(this.getMaxElement() + 1);
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval interval = this.intervals.get(i);
            int n2 = interval.a;
            int n3 = interval.b;
            for (int j = n2; j <= n3; ++j) {
                bitSet.add(j);
            }
        }
        return bitSet;
    }

    @Override
    public void remove(int n) {
        throw new NoSuchMethodError("IntervalSet.remove() unimplemented");
    }
}

