/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime;

import com.wavemaker.common.WMRuntimeInitException;
import com.wavemaker.runtime.service.ServiceManager;
import com.wavemaker.runtime.service.ServiceWire;
import com.wavemaker.runtime.service.reflect.ReflectServiceWire;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeAccess {
    private HttpServletRequest request = null;
    private static RuntimeAccess staticRuntime = null;
    private ServiceManager serviceManager = null;
    private int tenantId = -1;

    public static RuntimeAccess getInstance() {
        if (null == staticRuntime) {
            throw new WMRuntimeInitException("RuntimeAccess uninitialized; request init failed.");
        }
        return staticRuntime;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Object getService(String serviceId) {
        return this.serviceManager.getService(serviceId);
    }

    public Object getService(Class<?> serviceType) {
        return this.serviceManager.getService(serviceType);
    }

    public ServiceWire getServiceWire(String serviceId) {
        return this.serviceManager.getServiceWire(serviceId);
    }

    public Object getServiceBean(String serviceId) {
        return ((ReflectServiceWire)this.getServiceWire(serviceId)).getServiceBean();
    }

    public static void setRuntimeBean(RuntimeAccess bean) {
        staticRuntime = bean;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void setTenantId(int val) {
        this.getSession().setAttribute("logOnTenantId", (Object)val);
    }

    public int getTenantId() {
        Object o = this.getSession().getAttribute("logOnTenantId");
        if (o == null) {
            return -1;
        }
        return (Integer)o;
    }
}

