/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data;

import com.wavemaker.common.util.StringUtils;
import com.wavemaker.runtime.data.DataServiceInternal;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.runtime.data.DataServiceOperation;
import com.wavemaker.runtime.data.DataServiceType;
import com.wavemaker.runtime.data.ExternalDataModelConfig;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import com.wavemaker.runtime.service.ElementType;
import com.wavemaker.runtime.service.ServiceType;
import com.wavemaker.runtime.service.definition.AbstractDeprecatedServiceDefinition;
import com.wavemaker.runtime.service.definition.ReflectServiceDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataServiceDefinition
extends AbstractDeprecatedServiceDefinition
implements DataServiceInternal,
ReflectServiceDefinition {
    private DataServiceInternal.ElementTypeFactory elementTypeFactory;
    private final DataServiceMetaData metaData;
    private SessionFactory sessionFactory;
    private ExternalDataModelConfig externalConfig;

    private static String getName(String cfgfile) {
        cfgfile = cfgfile.replace("\\", "/");
        cfgfile = StringUtils.fromLastOccurrence((String)cfgfile, (String)"/");
        return StringUtils.fromFirstOccurrence((String)cfgfile, (String)".", (int)-1);
    }

    public DataServiceDefinition(String hbConfFile, Properties p, boolean useIndividualCRUDOperations) {
        this(DataServiceDefinition.getName(hbConfFile), DataServiceUtils.initConfiguration(hbConfFile, p), useIndividualCRUDOperations);
    }

    public DataServiceDefinition(DataServiceMetaData metaData) {
        this.elementTypeFactory = DEFAULT_ELEMENT_TYPE_FACTORY;
        this.sessionFactory = null;
        this.externalConfig = null;
        this.metaData = metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataServiceDefinition(String serviceName, Configuration hbcfg, boolean isImportDB, boolean useIndividualCRUDOperations) {
        block7: {
            this.elementTypeFactory = DEFAULT_ELEMENT_TYPE_FACTORY;
            this.sessionFactory = null;
            this.externalConfig = null;
            this.metaData = new DataServiceMetaData(serviceName, hbcfg);
            try {
                this.sessionFactory = hbcfg.buildSessionFactory();
                Session session = null;
                try {
                    session = this.sessionFactory.openSession();
                    this.metaData.init((org.hibernate.Session)session, useIndividualCRUDOperations);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    try {
                        session.close();
                    }
                    catch (RuntimeException ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    session.close();
                }
                catch (RuntimeException ignore) {}
            }
            catch (RuntimeException ex) {
                if (isImportDB) break block7;
                throw ex;
            }
        }
    }

    private DataServiceDefinition(String serviceName, Configuration hbcfg, boolean useIndividualCRUDOperations) {
        this(serviceName, hbcfg, false, useIndividualCRUDOperations);
    }

    @Override
    public void setExternalConfig(ExternalDataModelConfig externalConfig) {
        this.externalConfig = externalConfig;
    }

    public DataServiceMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void setElementTypeFactory(DataServiceInternal.ElementTypeFactory elementTypeFactory) {
        this.elementTypeFactory = elementTypeFactory;
    }

    @Override
    public List<ElementType> getInputTypes(String operationName) {
        DataServiceOperation op = this.metaData.getOperation(operationName);
        List<String> inputNames = op.getInputNames();
        List<String> inputTypes = op.getInputTypes();
        List<Boolean> inputIsList = op.getInputIsList();
        ArrayList<ElementType> rtn = new ArrayList<ElementType>(inputTypes.size());
        for (int i = 0; i < inputTypes.size(); ++i) {
            ElementType et = DEFAULT_ELEMENT_TYPE_FACTORY.getElementType(inputTypes.get(i));
            et.setName(inputNames.get(i));
            et.setList(inputIsList.get(i));
            rtn.add(et);
        }
        return rtn;
    }

    @Override
    public List<String> getOperationNames() {
        return new ArrayList<String>(this.metaData.getOperationNames());
    }

    @Override
    public ElementType getOutputType(String operationName) {
        DataServiceOperation op = this.metaData.getOperation(operationName);
        String outputType = op.getOutputType();
        if (outputType == null) {
            return null;
        }
        ElementType rtn = DEFAULT_ELEMENT_TYPE_FACTORY.getElementType(outputType);
        rtn.setName("rtn");
        if (op.isQuery() && this.externalConfig != null) {
            rtn.setList(!this.externalConfig.returnsSingleResult(operationName));
        } else {
            rtn.setList(!op.getReturnsSingleResult());
        }
        return rtn;
    }

    @Override
    public String getPackageName() {
        if (this.metaData.getServiceClassName() != null) {
            return (String)StringUtils.splitPackageAndClass((String)this.metaData.getServiceClassName()).v1;
        }
        throw new AssertionError((Object)"Metadata service class must be set");
    }

    @Override
    public String getDataPackage() {
        return this.metaData.getDataPackage();
    }

    @Override
    public String getServiceId() {
        return this.metaData.getName();
    }

    @Override
    public ServiceType getServiceType() {
        return new DataServiceType();
    }

    @Override
    public String getRuntimeConfiguration() {
        return this.getServiceId() + ".spring.xml";
    }

    @Override
    public void dispose() {
        this.metaData.dispose();
        try {
            if (this.sessionFactory != null) {
                this.sessionFactory.close();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public String getServiceClass() {
        if (this.metaData.getServiceClassName() != null) {
            return this.metaData.getServiceClassName();
        }
        throw new AssertionError((Object)"Metadata service class must be set");
    }

    @Override
    public List<ElementType> getTypes() {
        Collection<String> entities = this.metaData.getEntityClassNames();
        Collection<String> helperTypes = this.metaData.getHelperClassNames();
        return DataServiceUtils.getTypes(entities, helperTypes, this.elementTypeFactory);
    }

    public String outputTypeToString(String operationName) {
        ElementType et = this.getOutputType(operationName);
        return et.getJavaType();
    }

    public String inputTypesToString(String operationName) {
        StringBuilder rtn = new StringBuilder();
        for (ElementType et : this.getInputTypes(operationName)) {
            rtn.append(et.getJavaType()).append(" ");
            rtn.append("list: " + et.isList());
        }
        return rtn.toString();
    }

    @Override
    public List<String> getEventNotifiers() {
        return Collections.emptyList();
    }

    @Override
    public DataServiceOperation getOperation(String operationName) {
        return this.metaData.getOperation(operationName);
    }

    @Override
    public boolean isLiveDataService() {
        return true;
    }
}

