/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data;

import com.wavemaker.runtime.service.ElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataServiceOperation {
    private String name = null;
    private String queryName = null;
    private List<String> outputTypes = new ArrayList<String>();
    private List<String> outputNames = new ArrayList<String>();
    private List<String> inputTypes = new ArrayList<String>();
    private List<String> inputNames = new ArrayList<String>();
    private List<Boolean> inputIsList = new ArrayList<Boolean>();
    private String taskGetter = null;
    private boolean returnsSingleResult = false;
    private boolean requiresResultWrapper = false;
    private List<DataServiceOperation> overloadedOperations = new ArrayList<DataServiceOperation>();
    private List<ElementType> literalTaskInputs = new ArrayList<ElementType>();
    private String code = null;

    public DataServiceOperation() {
    }

    public DataServiceOperation(String name, String taskGetter) {
        this(name, null, taskGetter);
    }

    public DataServiceOperation(String name, String queryName, String taskGetter) {
        this.name = name;
        this.queryName = queryName;
        this.taskGetter = taskGetter;
    }

    public DataServiceOperation addOverloadedOperation() {
        return this.addOverloadedOperation(Collections.<String>emptyList(), Collections.<String>emptyList());
    }

    public DataServiceOperation addOverloadedOperation(List<String> inputTypes, List<String> inputNames) {
        DataServiceOperation op = new DataServiceOperation(this.getName(), this.getQueryName(), this.getTaskGetter());
        this.overloadedOperations.add(op);
        for (int i = 0; i < inputTypes.size(); ++i) {
            op.addInput(inputTypes.get(i), inputNames.get(0));
        }
        op.setOutputType(this.getOutputType());
        op.setReturnsSingleResult(this.getReturnsSingleResult());
        return op;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setReturnsSingleResult(Boolean b) {
        this.returnsSingleResult = b;
    }

    public boolean getReturnsSingleResult() {
        return this.returnsSingleResult;
    }

    public boolean isQuery() {
        return this.queryName != null;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public DataServiceOperation addInput(String inputName, Class<?> inputType) {
        return this.addInput(inputName, inputType.getName());
    }

    public DataServiceOperation addInput(String inputName, Class<?> inputType, Boolean isList) {
        return this.addInput(inputName, inputType.getName(), isList);
    }

    public DataServiceOperation addInput(String inputName, String inputType) {
        return this.addInput(inputName, inputType, Boolean.FALSE);
    }

    public DataServiceOperation addInput(String inputName, String inputType, Boolean isList) {
        this.inputNames.add(inputName);
        this.inputTypes.add(inputType);
        this.inputIsList.add(isList);
        return this;
    }

    public void setOutputType(String outputType) {
        this.outputTypes.clear();
        this.outputTypes.add(outputType);
    }

    public void setOutputType(Class<?> outputType) {
        this.setOutputType(outputType.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getInputTypes() {
        return this.inputTypes;
    }

    public List<String> getInputNames() {
        return this.inputNames;
    }

    public List<Boolean> getInputIsList() {
        return this.inputIsList;
    }

    public String getOutputType() {
        if (this.outputTypes.isEmpty()) {
            return null;
        }
        return this.outputTypes.get(0);
    }

    public List<String> getOutputTypes() {
        return this.outputTypes;
    }

    public List<String> getOutputNames() {
        return this.outputNames;
    }

    public void setOutputNames(List<String> outputNames) {
        this.outputNames = outputNames;
    }

    public void setOutputTypes(List<String> outputTypes) {
        this.outputTypes = outputTypes;
    }

    public String getTaskGetter() {
        return this.taskGetter;
    }

    public List<ElementType> getTaskInputs() {
        return this.literalTaskInputs;
    }

    public void addTaskInput(ElementType taskInput) {
        this.literalTaskInputs.add(taskInput);
    }

    public List<DataServiceOperation> getOverloadedOperations() {
        return this.overloadedOperations;
    }

    public void setRequiresResultWrapper(boolean requiresResultWrapper) {
        this.requiresResultWrapper = requiresResultWrapper;
    }

    public boolean requiresResultWrapper() {
        return this.requiresResultWrapper;
    }
}

