/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data;

import com.wavemaker.common.Resource;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.SystemUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.runtime.data.DataOperationFactory;
import com.wavemaker.runtime.data.DataServiceLoggers;
import com.wavemaker.runtime.data.DataServiceOperation;
import com.wavemaker.runtime.data.DataServiceRuntimeException;
import com.wavemaker.runtime.data.QueryOptions;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import com.wavemaker.runtime.service.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataServiceOperationManager {
    private static final String INSERT_OP = "insert%s";
    private static final String DELETE_OP = "delete%s";
    private static final String UPDATE_OP = "update%s";
    private static final String LIST_OP = "get%sList";
    private static final String COUNT_OP = "get%sCount";
    private static final String SEARCH_QBE_ARG = "searchInstance";
    private static final String SEARCH_OPTIONS_ARG = "searchOptions";
    private Map<String, DataServiceOperation> queries = new HashMap<String, DataServiceOperation>();
    private Map<String, DataServiceOperation> operations = new HashMap<String, DataServiceOperation>();
    private Collection<String> queryOperations = new HashSet<String>();
    private final DataOperationFactory factory;

    public DataServiceOperationManager(DataOperationFactory factory, boolean useIndividualCRUDOperations) {
        this.factory = factory;
        this.initQueries();
        if (useIndividualCRUDOperations) {
            this.initAPIOperations();
        }
        this.initQueryOperations();
    }

    public Map<String, DataServiceOperation> getOperations() {
        return this.operations;
    }

    public DataServiceOperation getOperation(String name) {
        DataServiceOperation rtn = this.operations.get(name);
        if (rtn == null) {
            rtn = this.queries.get(name);
        }
        return rtn;
    }

    public Collection<String> getOperationNames() {
        return this.operations.keySet();
    }

    private void initQueries() {
        for (String s : this.factory.getQueryNames()) {
            this.addQueryOperation(s);
        }
    }

    private void addQueryOperation(String queryName) {
        String operationName = DataServiceUtils.queryToOperationName(queryName);
        DataServiceOperation op = new DataServiceOperation(operationName, queryName, "getQueryTask");
        if (DataServiceLoggers.metaDataLogger.isDebugEnabled()) {
            DataServiceLoggers.metaDataLogger.debug((Object)("Processing query " + queryName));
        }
        op.setReturnsSingleResult(this.factory.queryReturnsSingleResult(operationName, queryName));
        for (Tuple.Three<String, String, Boolean> input : this.factory.getQueryInputs(queryName)) {
            op.addInput((String)input.v1, (String)input.v2, (Boolean)input.v3);
        }
        op.setOutputTypes(this.factory.getQueryReturnTypes(operationName, queryName));
        op.setOutputNames(this.factory.getQueryReturnNames(operationName, queryName));
        op.setRequiresResultWrapper(this.factory.requiresResultWrapper(operationName, queryName));
        this.queries.put(queryName, op);
    }

    private void initQueryOperations() {
        for (DataServiceOperation op : this.queries.values()) {
            if (this.queryOperations.contains(op.getName())) continue;
            this.addOperation(op);
        }
    }

    private void initAPIOperations() {
        for (String fullyQualifiedClassName : this.factory.getEntityClassNames()) {
            String name = StringUtils.fromLastOccurrence((String)fullyQualifiedClassName, (String)".");
            this.addCreateOp(name, fullyQualifiedClassName);
            for (DataServiceOperation op : this.getQueryForType(fullyQualifiedClassName)) {
                this.addOperation(op);
            }
            this.addSearchOperation(name, fullyQualifiedClassName);
            this.addCountOperation(name, fullyQualifiedClassName);
            this.addUpdateOp(name, fullyQualifiedClassName);
            this.addGenericOp(name, fullyQualifiedClassName, DELETE_OP, "getDeleteTask");
        }
    }

    private void addCreateOp(String name, String fullyQualifiedClassName) {
        DataServiceOperation op = this.addGenericOp(name, fullyQualifiedClassName, INSERT_OP, "getInsertTask");
        op.setOutputType(fullyQualifiedClassName);
        op.setReturnsSingleResult(Boolean.TRUE);
    }

    private void addUpdateOp(String name, String fullyQualifiedClassName) {
        String opName = String.format(UPDATE_OP, name);
        DataServiceOperation op = new DataServiceOperation(opName, "getUpdateTask");
        String argName = StringUtils.lowerCaseFirstLetter((String)name);
        op.addInput(argName, fullyQualifiedClassName);
        this.addOperation(op);
    }

    private DataServiceOperation addGenericOp(String name, String fullyQualifiedClassName, String crudOp, String taskGetter) {
        String opName = String.format(crudOp, name);
        DataServiceOperation op = new DataServiceOperation(opName, taskGetter);
        op.addInput(StringUtils.lowerCaseFirstLetter((String)name), fullyQualifiedClassName);
        this.addOperation(op);
        return op;
    }

    private void addSearchOperation(String name, String fullyQualifiedClassName) {
        String opName = String.format(LIST_OP, name);
        DataServiceOperation op = new DataServiceOperation(opName, "getSearchTask");
        op.setOutputType(fullyQualifiedClassName);
        op.setReturnsSingleResult(Boolean.FALSE);
        op.addInput(SEARCH_QBE_ARG, fullyQualifiedClassName);
        op.addInput(SEARCH_OPTIONS_ARG, QueryOptions.class);
        this.addNullToInstanceCode(op, SEARCH_QBE_ARG, fullyQualifiedClassName);
        this.addOperation(op);
        DataServiceOperation op1 = op.addOverloadedOperation();
        op1.addInput(SEARCH_QBE_ARG, fullyQualifiedClassName);
        this.addNullToInstanceCode(op1, SEARCH_QBE_ARG, fullyQualifiedClassName);
        op.addOverloadedOperation().addTaskInput(new ElementType(fullyQualifiedClassName, Class.class.getName()));
    }

    private void addNullToInstanceCode(DataServiceOperation op, String argName, String className) {
        String eol = SystemUtils.getLineBreak();
        op.setCode("if (" + argName + " == null) {" + eol + "            " + argName + " = new " + className + "();" + eol + "        }");
    }

    private void addCountOperation(String name, String fullyQualifiedClassName) {
        String opName = String.format(COUNT_OP, name);
        DataServiceOperation op = new DataServiceOperation(opName, "getCountTask");
        op.setReturnsSingleResult(true);
        op.setOutputType(Integer.class);
        op.addInput(SEARCH_QBE_ARG, fullyQualifiedClassName);
        op.addInput(SEARCH_OPTIONS_ARG, QueryOptions.class);
        this.addNullToInstanceCode(op, SEARCH_QBE_ARG, fullyQualifiedClassName);
        this.addOperation(op);
        DataServiceOperation op1 = op.addOverloadedOperation();
        op1.addInput(SEARCH_QBE_ARG, fullyQualifiedClassName);
        this.addNullToInstanceCode(op1, SEARCH_QBE_ARG, fullyQualifiedClassName);
        op.addOverloadedOperation().addTaskInput(new ElementType(fullyQualifiedClassName, Class.class.getName()));
    }

    private void addOperation(DataServiceOperation op) {
        if (this.operations.containsKey(op.getName())) {
            throw new DataServiceRuntimeException(Resource.DUPLICATE_OPERATION, op.getName());
        }
        this.operations.put(op.getName(), op);
        if (op.isQuery()) {
            this.queryOperations.add(op.getName());
        }
    }

    private List<DataServiceOperation> getQueryForType(String type) {
        ArrayList<DataServiceOperation> rtn = new ArrayList<DataServiceOperation>();
        for (DataServiceOperation op : this.queries.values()) {
            if (!type.equals(op.getOutputType())) continue;
            rtn.add(op);
        }
        return rtn;
    }
}

