/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.spring;

import com.wavemaker.runtime.WMAppContext;
import com.wavemaker.runtime.data.spring.ConfigurationExt;
import com.wavemaker.runtime.data.spring.ConfigurationRegistry;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.springframework.beans.BeanUtils;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class ConfigurationAndSessionFactoryBean
extends LocalSessionFactoryBean {
    private String name = null;
    private Class configurationExtClass = ConfigurationExt.class;
    public static String projectName;

    public void setConfigurationClass(Class configurationClass) {
        throw new IllegalArgumentException("Cannot customize configuration class");
    }

    public Configuration newConfiguration() {
        if (this.name == null) {
            throw new IllegalStateException("name must be set before creating new Configuration");
        }
        WMAppContext wmApp = WMAppContext.getInstance();
        Configuration rtn = wmApp != null && wmApp.isMultiTenant() ? (ConfigurationExt)((Object)BeanUtils.instantiateClass((Class)this.configurationExtClass)) : super.newConfiguration();
        ConfigurationRegistry.getInstance().register(this.name, rtn);
        return rtn;
    }

    protected SessionFactory buildSessionFactory() throws Exception {
        SessionFactory rtn = super.buildSessionFactory();
        ConfigurationRegistry.getInstance().register(this.name, rtn);
        return rtn;
    }

    public void destroy() {
        ConfigurationRegistry.getInstance().remove(this.name);
        super.destroy();
    }

    public void setName(String name) {
        this.name = name;
    }
}

