/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.spring;

import com.wavemaker.common.util.StringUtils;
import com.wavemaker.runtime.WMAppContext;
import com.wavemaker.runtime.data.DataServiceLoggers;
import com.wavemaker.runtime.data.DataServiceManager;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.runtime.data.DataServiceRuntimeException;
import com.wavemaker.runtime.data.DefaultTaskManager;
import com.wavemaker.runtime.data.Task;
import com.wavemaker.runtime.data.TaskManager;
import com.wavemaker.runtime.data.ThreadContext;
import com.wavemaker.runtime.data.spring.ConfigurationRegistry;
import com.wavemaker.runtime.data.task.DefaultRollback;
import com.wavemaker.runtime.data.task.PreProcessor;
import com.wavemaker.runtime.data.util.QueryHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringDataServiceManager
implements DataServiceManager {
    public static final Log txLogger = DataServiceLoggers.transactionLogger;
    private final PlatformTransactionManager txMgr;
    private final HibernateTemplate hibernateTemplate;
    private final TaskManager taskMgr;
    private final DataServiceMetaData metaData;
    private final Configuration cfg;
    private final SessionFactory sessionFactory;

    public SpringDataServiceManager(String configurationName, HibernateTemplate hibernateTemplate, PlatformTransactionManager txMgr) {
        this(configurationName, hibernateTemplate, txMgr, DefaultTaskManager.getInstance(), Collections.emptyMap());
    }

    public SpringDataServiceManager(String configurationName, HibernateTemplate hibernateTemplate, PlatformTransactionManager txMgr, TaskManager taskMgr, Map<String, String> properties) {
        if (configurationName == null) {
            throw new IllegalArgumentException("configurationName must be set");
        }
        if (hibernateTemplate == null) {
            throw new IllegalArgumentException("hibernateTemplate must be set");
        }
        if (txMgr == null) {
            throw new IllegalArgumentException("platformTransactionManager must be set");
        }
        if (taskMgr == null) {
            throw new IllegalArgumentException("taskManager must be set");
        }
        this.hibernateTemplate = hibernateTemplate;
        this.txMgr = txMgr;
        this.taskMgr = taskMgr;
        ConfigurationRegistry reg = ConfigurationRegistry.getInstance();
        this.cfg = reg.getConfiguration(configurationName);
        if (this.cfg == null) {
            throw new DataServiceRuntimeException("Cannot find configuration for " + configurationName);
        }
        this.sessionFactory = reg.getSessionFactory(configurationName);
        if (this.sessionFactory == null) {
            throw new DataServiceRuntimeException("Cannot find session factory for " + configurationName);
        }
        String s = properties.get("useIndividualCRUDOperations");
        boolean useIndividualCRUDOperations = Boolean.valueOf(s);
        this.metaData = SpringDataServiceManager.initMetaData(configurationName, this.cfg, hibernateTemplate, useIndividualCRUDOperations, properties);
    }

    @Override
    public DataServiceMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public Session getSession() {
        if (!this.isTxRunning()) {
            txLogger.warn((Object)"begin a tx before accessing the session");
        }
        return (Session)this.invoke(this.taskMgr.getSessionTask(), new Object[0]);
    }

    @Override
    public void begin() {
        TransactionStatus txStatus;
        ThreadContext.Context ctx;
        if (txLogger.isInfoEnabled()) {
            txLogger.info((Object)"begin");
        }
        if ((ctx = ThreadContext.getContext(this.metaData.getName())) == null) {
            ctx = new ThreadContext.Context(this.txMgr, this.metaData, this.cfg, this.sessionFactory);
        }
        if ((txStatus = ctx.getTransactionStatus()) == null) {
            txStatus = this.txMgr.getTransaction(null);
            ctx.setTransactionStatus(txStatus);
        } else if (txLogger.isWarnEnabled()) {
            txLogger.warn((Object)"ignoring begin - tx already in progress");
            if (txLogger.isDebugEnabled()) {
                this.logStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        ThreadContext.Context ctx;
        if (txLogger.isInfoEnabled()) {
            txLogger.info((Object)"commit");
        }
        if ((ctx = ThreadContext.getContext(this.metaData.getName())) == null) {
            if (txLogger.isWarnEnabled()) {
                txLogger.warn((Object)"ignoring commit - no tx in progress");
                if (txLogger.isDebugEnabled()) {
                    this.logStackTrace();
                }
            }
            return;
        }
        TransactionStatus txStatus = ctx.getTransactionStatus();
        try {
            if (txStatus == null) {
                if (txLogger.isWarnEnabled()) {
                    txLogger.warn((Object)"ignoring commit - no tx status");
                    if (txLogger.isDebugEnabled()) {
                        this.logStackTrace();
                    }
                }
            } else {
                this.txMgr.commit(txStatus);
            }
            Object var4_3 = null;
            ctx.setTransactionStatus(null);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.setTransactionStatus(null);
            ThreadContext.unsetContext(this.metaData.getName());
            HashMap<String, ThreadContext.Context> contextHash = ThreadContext.getThreadLocalHash();
            if (contextHash != null && contextHash.size() > 0) {
                if (!TransactionSynchronizationManager.isSynchronizationActive()) {
                    TransactionSynchronizationManager.initSynchronization();
                }
            } else if (TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationManager.clear();
                Map map = TransactionSynchronizationManager.getResourceMap();
                for (Object entry : map.keySet()) {
                    TransactionSynchronizationManager.unbindResource(entry);
                }
            }
            throw throwable;
        }
        ThreadContext.unsetContext(this.metaData.getName());
        HashMap<String, ThreadContext.Context> contextHash = ThreadContext.getThreadLocalHash();
        if (contextHash != null && contextHash.size() > 0) {
            if (!TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationManager.initSynchronization();
            }
        } else if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.clear();
            Map map = TransactionSynchronizationManager.getResourceMap();
            for (Object entry : map.keySet()) {
                TransactionSynchronizationManager.unbindResource(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        ThreadContext.Context ctx;
        if (txLogger.isInfoEnabled()) {
            txLogger.info((Object)"rollback");
        }
        if ((ctx = ThreadContext.getContext(this.metaData.getName())) == null) {
            if (txLogger.isWarnEnabled()) {
                txLogger.warn((Object)"ignoring rollback - no tx in progress");
                if (txLogger.isDebugEnabled()) {
                    this.logStackTrace();
                }
            }
            return;
        }
        TransactionStatus txStatus = ctx.getTransactionStatus();
        try {
            if (txStatus == null) {
                if (txLogger.isWarnEnabled()) {
                    txLogger.warn((Object)"ignoring rollback - no tx status");
                    if (txLogger.isDebugEnabled()) {
                        this.logStackTrace();
                    }
                }
            } else {
                this.txMgr.rollback(txStatus);
            }
            Object var4_3 = null;
            ctx.setTransactionStatus(null);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.setTransactionStatus(null);
            ThreadContext.unsetContext(this.metaData.getName());
            throw throwable;
        }
        ThreadContext.unsetContext(this.metaData.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Task task, Object ... input) {
        Object object;
        block3: {
            boolean unset = false;
            ThreadContext.Context ctx = ThreadContext.getContext(this.metaData.getName());
            if (ctx == null) {
                ctx = new ThreadContext.Context(this.txMgr, this.metaData, this.cfg, this.sessionFactory);
                unset = true;
            }
            try {
                object = this.runInTx(task, input);
                Object var7_6 = null;
                if (!unset) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_7 = null;
                    if (!unset) break block4;
                    ThreadContext.unsetContext(this.metaData.getName());
                }
                throw throwable;
            }
            ThreadContext.unsetContext(this.metaData.getName());
        }
        return object;
    }

    @Override
    public void dispose() {
        try {
            if (this.isTxRunning()) {
                this.rollback();
            }
            this.getMetaData().dispose();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private boolean isTxRunning() {
        ThreadContext.Context ctx = ThreadContext.getContext(this.metaData.getName());
        if (ctx == null) {
            return false;
        }
        return ctx.getTransactionStatus() != null;
    }

    private Object runInTx(Task task, Object ... input) {
        RunInHibernate action = new RunInHibernate(task, input);
        TransactionTemplate txTemplate = new TransactionTemplate(this.txMgr);
        boolean rollbackOnly = task instanceof DefaultRollback && !this.isTxRunning();
        RunInTx tx = new RunInTx(action, rollbackOnly);
        if (txLogger.isInfoEnabled()) {
            if (this.isTxRunning()) {
                txLogger.info((Object)("tx is running executing \"" + task.getName() + "\" in current tx"));
            } else {
                txLogger.info((Object)("no tx running, wrapping execution of \"" + task.getName() + "\" in tx"));
                if (rollbackOnly) {
                    txLogger.info((Object)("rollback enabled for \"" + task.getName() + "\""));
                }
            }
        }
        Object rtn = txTemplate.execute((TransactionCallback)tx);
        if (txLogger.isInfoEnabled()) {
            if (this.isTxRunning()) {
                txLogger.info((Object)("tx is running after execution of \"" + task.getName() + "\""));
            } else {
                txLogger.info((Object)("tx is not running after execution of \"" + task.getName() + "\""));
            }
        }
        return rtn;
    }

    private void logStackTrace() {
        txLogger.debug((Object)StringUtils.toString((Throwable)new Throwable()));
    }

    private static DataServiceMetaData initMetaData(String configurationName, Configuration cfg, HibernateTemplate htemp, final boolean useIndividualCRUDOperations, Map<String, String> properties) {
        final DataServiceMetaData rtn = new DataServiceMetaData(configurationName, cfg, properties);
        htemp.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                rtn.init(session, useIndividualCRUDOperations);
                return null;
            }
        });
        return rtn;
    }

    private class RunInTx
    implements TransactionCallback {
        private final HibernateCallback action;
        private final boolean rollbackOnly;

        RunInTx(HibernateCallback action, boolean rollbackOnly) {
            this.action = action;
            this.rollbackOnly = rollbackOnly;
        }

        public Object doInTransaction(TransactionStatus status) {
            if (this.rollbackOnly) {
                status.setRollbackOnly();
            }
            return SpringDataServiceManager.this.hibernateTemplate.execute(this.action);
        }
    }

    private class RunInHibernate
    implements HibernateCallback {
        private final Task task;
        private Object[] input;

        RunInHibernate(Task task, Object[] input) {
            this.task = task;
            this.input = input;
        }

        public Object doInHibernate(Session session) {
            WMAppContext wmApp;
            Task preProcessorTask = ThreadContext.getPreProcessorTask();
            if (preProcessorTask != null && this.task instanceof PreProcessor) {
                if (txLogger.isInfoEnabled()) {
                    txLogger.info((Object)("Running preprocessor task " + preProcessorTask.getName()));
                }
                this.input = (Object[])preProcessorTask.run(session, SpringDataServiceManager.this.metaData.getName(), this.input, this.task, SpringDataServiceManager.this.taskMgr);
            }
            if ((wmApp = WMAppContext.getInstance()) != null && wmApp.isMultiTenant()) {
                Class[] clsArr = new Class[]{Session.class};
                ClassLoader cl = Session.class.getClassLoader();
                QueryHandler qh = new QueryHandler(session, SpringDataServiceManager.this.metaData.getConfiguration());
                session = (Session)Proxy.newProxyInstance(cl, clsArr, (InvocationHandler)qh);
            }
            return this.task.run(session, SpringDataServiceManager.this.metaData.getName(), this.input);
        }
    }
}

