/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.spring;

import com.wavemaker.runtime.data.DataServiceLoggers;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class ThreadLocalDriverManagerDataSource
extends DriverManagerDataSource {
    private static ThreadLocal<ConnectionProperties> threadLocal = new ThreadLocal();

    public static void setConnectionProperties(ConnectionProperties connectionProperties) {
        threadLocal.set(connectionProperties);
    }

    public static void unsetConnectionProperties() {
        threadLocal.set(null);
    }

    public String getDriverClassName() {
        ConnectionProperties props = threadLocal.get();
        if (props == null) {
            return "";
        }
        String rtn = props.getDriverClassName();
        if (rtn == null) {
            return "";
        }
        super.setDriverClassName(rtn);
        return rtn;
    }

    public String getPassword() {
        ConnectionProperties props = threadLocal.get();
        if (props == null) {
            return super.getPassword();
        }
        String rtn = props.getPassword();
        if (rtn == null) {
            return super.getPassword();
        }
        return rtn;
    }

    public String getUsername() {
        ConnectionProperties props = threadLocal.get();
        if (props == null) {
            return super.getUsername();
        }
        String rtn = props.getUsername();
        if (rtn == null) {
            return super.getUsername();
        }
        return rtn;
    }

    public String getUrl() {
        ConnectionProperties props = threadLocal.get();
        if (props == null) {
            return super.getUrl();
        }
        String rtn = props.getUrl();
        if (rtn == null) {
            return super.getUrl();
        }
        return rtn;
    }

    public Connection getConnection() throws SQLException {
        if (DataServiceLoggers.connectionLogger.isDebugEnabled()) {
            DataServiceLoggers.connectionLogger.debug((Object)("getConnection: " + this.getUrl() + " " + this.getUsername() + "/" + this.getPassword() + " " + this.getDriverClassName()));
        }
        return super.getConnection();
    }

    public static class ConnectionProperties {
        private String url;
        private String username;
        private String password;
        private String driver;

        public ConnectionProperties() {
            ThreadLocalDriverManagerDataSource.setConnectionProperties(this);
        }

        public void setDriverClassName(String driver) {
            this.driver = driver;
        }

        public String getDriverClassName() {
            return this.driver;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getUsername() {
            return this.username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

