/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.task;

import com.wavemaker.common.util.ObjectAccess;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.runtime.data.DataServiceLoggers;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.runtime.data.Task;
import com.wavemaker.runtime.data.task.BaseTask;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import com.wavemaker.runtime.service.OrderBy;
import com.wavemaker.runtime.service.PagingOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReadTask
extends BaseTask
implements Task {
    private static final PropertyTraversal NOOP_PROPERTY_TRAVERSAL = new PropertyTraversal(){

        public boolean keepGoing(Type type) {
            return true;
        }
    };
    private static final PropertyTraversal COMPONENT_PROPERTY_TRAVERSAL = new PropertyTraversal(){

        public boolean keepGoing(Type type) {
            return !type.isComponentType();
        }
    };
    private static final String ROOT_CRITERIA_KEY = "";

    protected Criteria initCriteriasMap(Map<String, Criteria> criterias, Class<?> rootType, Session session) {
        Criteria rtn = session.createCriteria(rootType);
        if (DataServiceLoggers.taskLogger.isDebugEnabled()) {
            DataServiceLoggers.taskLogger.debug((Object)("Created root criteria for " + rootType.getName()));
        }
        criterias.put(ROOT_CRITERIA_KEY, rtn);
        return rtn;
    }

    protected Criteria getRootCriteria(Map<String, Criteria> criterias) {
        return criterias.get(ROOT_CRITERIA_KEY);
    }

    protected void fetch(Criteria criteria, String propertyName) {
        criteria.setFetchMode(propertyName, FetchMode.JOIN);
    }

    protected Criteria getCriteriaForPath(String path, Map<String, Criteria> criterias) {
        return this.getCriteriaForPath(path, criterias, false);
    }

    protected Criteria getCriteriaForPath(String path, Map<String, Criteria> criterias, boolean fetch) {
        Criteria rtn = criterias.get(path);
        if (rtn != null) {
            return rtn;
        }
        Tuple.Two<String, String> p = this.splitPath(path);
        Criteria parent = this.getCriteriaForPath((String)p.v1, criterias);
        rtn = parent.createCriteria((String)p.v2);
        if (fetch) {
            this.fetch(parent, (String)p.v2);
        }
        criterias.put(path, rtn);
        return rtn;
    }

    protected Tuple.Two<String, String> splitPath(String path) {
        String parent = ROOT_CRITERIA_KEY;
        String child = path;
        int i = path.lastIndexOf(".");
        if (i > -1) {
            parent = path.substring(0, i);
            child = path.substring(i + 1);
        }
        return Tuple.tuple((Object)parent, (Object)child);
    }

    protected void applyPaging(PagingOptions options, Criteria c) {
        Long maxResults;
        if (options == null) {
            return;
        }
        Long firstResult = options.getFirstResult();
        if (firstResult != null) {
            c.setFirstResult(firstResult.intValue());
        }
        if ((maxResults = options.getMaxResults()) != null) {
            c.setMaxResults(maxResults.intValue());
        }
        options.nextPage();
    }

    protected void applyPaging(PagingOptions options, Query q) {
        Long maxResults;
        if (options == null) {
            return;
        }
        Long firstResult = options.getFirstResult();
        if (firstResult != null) {
            q.setFirstResult(firstResult.intValue());
        }
        if ((maxResults = options.getMaxResults()) != null) {
            q.setMaxResults(maxResults.intValue());
        }
        options.nextPage();
    }

    protected void applyOrderBy(PagingOptions options, Map<String, Criteria> criterias) {
        if (options == null) {
            return;
        }
        if (options.getOrderByList().isEmpty()) {
            this.getRootCriteria(criterias).addOrder(Order.asc((String)"id"));
            return;
        }
        for (OrderBy orderBy : options.getOrderByList()) {
            String orderByExp = orderBy.getPropertyPath();
            Tuple.Two<String, String> t = this.splitPath(orderByExp);
            Criteria c = this.getCriteriaForPath((String)t.v1, criterias);
            Order o = null;
            o = orderBy.isAsc() ? Order.asc((String)((String)t.v2)) : Order.desc((String)((String)t.v2));
            if (DataServiceLoggers.taskLogger.isDebugEnabled()) {
                DataServiceLoggers.taskLogger.debug((Object)("Added order by " + orderBy));
            }
            c.addOrder(o);
        }
    }

    protected String[] splitPropertyPath(String propertyPath) {
        String[] rtn = null;
        rtn = propertyPath.indexOf(".") == -1 ? new String[]{propertyPath} : propertyPath.split("\\.");
        return rtn;
    }

    protected Class<?> getPropertyType(Class<?> rootType, String propertyPath, String dbName) {
        Property p = this.getProperty(rootType, propertyPath, NOOP_PROPERTY_TRAVERSAL, dbName);
        Type hbmType = p.getType();
        return hbmType.getReturnedClass();
    }

    protected boolean isComponentType(Class<?> rootType, String propertyPath, String dbName) {
        Property p = this.getProperty(rootType, propertyPath, COMPONENT_PROPERTY_TRAVERSAL, dbName);
        return p == null;
    }

    protected boolean isNulleable(Class<?> rootType, String propertyPath, String dbName) {
        Property p = this.getProperty(rootType, propertyPath, NOOP_PROPERTY_TRAVERSAL, dbName);
        if (this.isRelatedMany(p.getType().getReturnedClass())) {
            return true;
        }
        return ((Column)p.getColumnIterator().next()).isNullable();
    }

    protected void logQuery(String query) {
        this.logQuery(query, Collections.<String, Object>emptyMap());
    }

    protected void logQuery(String query, Map<String, Object> bindParams) {
        if (DataServiceLoggers.taskLogger.isInfoEnabled()) {
            DataServiceLoggers.taskLogger.info((Object)query);
            if (!bindParams.isEmpty()) {
                DataServiceLoggers.taskLogger.debug(bindParams);
            }
        }
    }

    protected Object runQuery(Query query, boolean singleResult, String dbName) {
        if (singleResult) {
            return query.uniqueResult();
        }
        List rs = query.list();
        SessionFactory sessFact = AbstractReadTask.getSessionFactory(dbName);
        Type[] returnTypes = query.getReturnTypes();
        Class returnedClass = returnTypes[0].getReturnedClass();
        String[] propertyNames = sessFact.getClassMetadata(returnedClass).getPropertyNames();
        Type[] propertyTypes = sessFact.getClassMetadata(returnedClass).getPropertyTypes();
        ObjectAccess oa = ObjectAccess.getInstance();
        Iterator rsItr = rs.iterator();
        ArrayList finalResultSet = new ArrayList();
        while (rsItr.hasNext()) {
            Object obj = rsItr.next();
            if (finalResultSet.contains(obj)) continue;
            for (int i = 0; i < propertyTypes.length; ++i) {
                if (!propertyTypes[i].getName().contains("lob") && !propertyTypes[i].getName().toLowerCase().contains("binary")) continue;
                oa.setProperty(obj, propertyNames[i], null);
            }
            finalResultSet.add(obj);
        }
        return finalResultSet;
    }

    private Property getProperty(Class<?> rootType, String propertyPath, PropertyTraversal traversalStrategy, String dbName) {
        Property rtn = null;
        DataServiceMetaData m = AbstractReadTask.getMetaData(dbName);
        String entityName = rootType.getName();
        SessionFactory fac = AbstractReadTask.getSessionFactory(dbName);
        for (String s : this.splitPropertyPath(propertyPath)) {
            rtn = m.getProperty(entityName, s);
            Type hbmType = rtn.getType();
            if (!traversalStrategy.keepGoing(hbmType)) {
                return null;
            }
            entityName = DataServiceUtils.getJavaTypeName(hbmType, fac);
        }
        return rtn;
    }

    private static interface PropertyTraversal {
        public boolean keepGoing(Type var1);
    }
}

