/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.task;

import com.wavemaker.common.util.ObjectAccess;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.runtime.data.DataServiceLoggers;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.runtime.data.Task;
import com.wavemaker.runtime.data.ThreadContext;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import org.apache.commons.logging.Log;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTask
implements Task {
    private Log logger = DataServiceLoggers.taskLogger;
    private final ObjectAccess objectAccess = ObjectAccess.getInstance();

    protected ObjectAccess getObjectAccess() {
        return this.objectAccess;
    }

    protected static DataServiceMetaData getMetaData(String dbName) {
        ThreadContext.Context ctx = ThreadContext.getContext(dbName);
        return ctx.getMetaData();
    }

    protected static SessionFactory getSessionFactory(String dbName) {
        ThreadContext.Context ctx = ThreadContext.getContext(dbName);
        return ctx.getSessionFactory();
    }

    protected static Configuration getConfiguration(String dbName) {
        ThreadContext.Context ctx = ThreadContext.getContext(dbName);
        return ctx.getConfiguration();
    }

    protected boolean isRelatedMany(Class<?> c) {
        return DataServiceUtils.isRelatedMany(c);
    }

    protected Object loadById(Object o, Session session, String dbName) {
        return DataServiceUtils.loadById(o, session, BaseTask.getMetaData(dbName), this.logger);
    }

    protected Object loadIntoSession(Object o, Session session, String dbname) {
        Object rtn = this.loadById(o, session, dbname);
        if (rtn == null && DataServiceLoggers.taskLogger.isInfoEnabled()) {
            DataServiceLoggers.taskLogger.info((Object)("Skipping instance " + ObjectUtils.getId((Object)o) + " because it is transient"));
        }
        return rtn;
    }

    protected Object emptyInstanceWithId(Object o, DataServiceMetaData metaData) {
        String s = metaData.getIdPropertyName(o.getClass());
        Object id = this.getObjectAccess().getProperty(o, s);
        Object rtn = this.objectAccess.newInstance(this.getEntityClass(o));
        this.objectAccess.setProperty(rtn, s, id);
        return rtn;
    }

    protected Class<?> getEntityClass(Object entityInstance) {
        return DataServiceUtils.getEntityClass(entityInstance.getClass());
    }

    protected void maybeRefreshEntity(Object o, Session session, String dbName) {
        if (BaseTask.getMetaData(dbName).refreshEntity(o.getClass())) {
            session.flush();
            session.refresh(o);
        }
    }
}

