/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.task;

import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.runtime.data.DataServiceQueryException;
import com.wavemaker.runtime.data.Task;
import com.wavemaker.runtime.data.task.QueryTask;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckQueryTask
extends QueryTask
implements Task {
    @Override
    public Object run(Session session, String dbName, Object ... input) {
        Map<String, QueryTask.BindParameter> bindParams = this.handleBindParameters(input);
        Query query = this.createQuery(session, input);
        this.checkQueryReturnAliases(query);
        this.checkBindParameters(bindParams);
        return null;
    }

    @Override
    public String getName() {
        return "Built-in Check Query Task";
    }

    private void checkBindParameters(Map<String, QueryTask.BindParameter> bindParams) {
        ArrayList<String> illegalIdentifiers = new ArrayList<String>();
        for (String name : bindParams.keySet()) {
            if (StringUtils.isValidJavaIdentifier((String)name)) continue;
            illegalIdentifiers.add(name);
        }
        if (!illegalIdentifiers.isEmpty()) {
            throw new DataServiceQueryException("Bind parameter names must be legal java identifiers: " + ObjectUtils.toString(illegalIdentifiers));
        }
    }

    private void checkQueryReturnAliases(Query query) {
        if (query.getReturnAliases() == null) {
            return;
        }
        ArrayList<String> upperCaseAliases = new ArrayList<String>();
        ArrayList<String> illegalIdentifiers = new ArrayList<String>();
        Type[] types = query.getReturnTypes();
        List<String> names = DataServiceUtils.getColumnNames(types.length, Arrays.asList(query.getReturnAliases()));
        for (String name : names) {
            if (Character.isUpperCase(name.charAt(0))) {
                upperCaseAliases.add(name);
            }
            if (StringUtils.isValidJavaIdentifier((String)name)) continue;
            illegalIdentifiers.add(name);
        }
        if (!upperCaseAliases.isEmpty()) {
            throw new DataServiceQueryException("Query return aliases cannot start with upper-case letters: " + ObjectUtils.toString(upperCaseAliases));
        }
        if (!illegalIdentifiers.isEmpty()) {
            throw new DataServiceQueryException("Query return aliases must be legal java identifiers: " + ObjectUtils.toString(illegalIdentifiers));
        }
    }
}

